/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.ModelImage;
import pyrosim.gui.FloorBGImageEditor;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Global;

public class ManageFloorsDlg
extends guiDialog {
    private static final long serialVersionUID = -3663137074371411086L;
    private guiTable d_table;
    private PyroMod d_mediator;
    private UnitSystem d_unitSystem;
    private FloorBGImageEditor.EditBGImageAction d_editImageAction;
    private BGImageTableCell d_bgImageCell;

    public ManageFloorsDlg(JFrame jFrame, PyroMod pyroMod, FloorBGImageEditor.EditBGImageAction editBGImageAction) {
        super((Window)jFrame, Intl.intl("Manage Floors"), 9);
        Object object;
        this.d_mediator = pyroMod;
        this.d_editImageAction = editBGImageAction;
        this.d_editImageAction.acquire();
        JButton jButton = new JButton(new AddFloorAction());
        String[] stringArray = new String[Column.values().length];
        Class[] classArray = new Class[Column.values().length];
        for (int i = 0; i < Column.values().length; ++i) {
            object = Column.values()[i];
            stringArray[i] = ((Column)((Object)object)).desc;
            classArray[i] = ((Column)((Object)object)).type;
        }
        this.d_table = guiTableUtil.fixedColumnTable(stringArray, classArray, 0, Integer.MAX_VALUE, 31);
        this.d_table.setSortOrder(0);
        this.d_bgImageCell = new BGImageTableCell();
        this.d_table.setDefaultRenderer(ModelImage.class, this.d_bgImageCell);
        this.d_table.setDefaultEditor(ModelImage.class, this.d_bgImageCell);
        this.d_table.setDefaultEditor(UnitDouble.class, new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getLengthUnit()));
        this.d_table.autoSizeColumns(200);
        guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 18);
        object = new GridBagHelper(this.getDialogPane());
        ((GridBagHelper)object).addRow(jButton, 0);
        ((GridBagHelper)object).addRow(guiTableEditor2, new double[]{1.0, 1.0}, new int[]{0, 0});
        ((GridBagHelper)object).finalizeRows();
        this.loadValues();
        this.setDisposeAfterModal(false);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        Object object;
        int n;
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        TableModel tableModel = this.d_table.getModel();
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            for (Object object2 : Column.values()) {
                if (object2.nullAllowed || tableModel.getValueAt(n, object2.ordinal()) != null) continue;
                if (bl) {
                    int n2 = this.d_table.convertRowIndexToView(n) + 1;
                    String string = String.format(Intl.intl("Error on row %d: %s must not be empty."), n2, object2.desc);
                    JOptionPane.showMessageDialog(this, string, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            object = (String)tableModel.getValueAt(n, Column.NAME.ordinal());
            for (int i = n + 1; i < tableModel.getRowCount(); ++i) {
                String string = (String)tableModel.getValueAt(i, Column.NAME.ordinal());
                if (!((String)object).equals(string)) continue;
                if (bl) {
                    int n3 = this.d_table.convertRowIndexToView(n) + 1;
                    int n4 = this.d_table.convertRowIndexToView(i) + 1;
                    String string2 = String.format(Intl.intl("Error on rows %d and %d: each floor must have a unique name."), n3, n4);
                    JOptionPane.showMessageDialog(this, string2, Intl.intl("Error"), 0);
                }
                return false;
            }
        }
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            object = (UnitDouble)tableModel.getValueAt(n, Column.SLAB.ordinal());
            UnitDouble unitDouble = (UnitDouble)tableModel.getValueAt(n, Column.WALL.ordinal());
            if (!(((UnitDouble)object).getValueNoUnit() < 0.0) && !(unitDouble.getValueNoUnit() < 0.0)) continue;
            if (bl) {
                Object object2;
                int n5 = this.d_table.convertRowIndexToView(n) + 1;
                object2 = String.format(Intl.intl("Error on row %d: Slab Thickness and Wall Height must be >= 0."), n5);
                JOptionPane.showMessageDialog(this, object2, Intl.intl("Error"), 0);
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.d_editImageAction.release();
        super.dispose();
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        if (n != 1) {
            this.dispose();
        }
        return n;
    }

    private void loadValues() {
        int n = 0;
        for (Floor floor : this.d_mediator.getFloorManager().flatten()) {
            this.load(floor, n);
            ++n;
        }
    }

    private void load(Floor floor, int n) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
        guiDefaultTableModel2.setValueAt(floor.getName(), n, Column.NAME.ordinal());
        guiDefaultTableModel2.setValueAt(floor.getElevation(), n, Column.ELEVATION.ordinal());
        guiDefaultTableModel2.setValueAt(floor.getWallHeight(), n, Column.WALL.ordinal());
        guiDefaultTableModel2.setValueAt(floor.getSlabThickness(), n, Column.SLAB.ordinal());
        guiDefaultTableModel2.setValueAt(floor.getBgImage(), n, Column.BG.ordinal());
        guiDefaultTableModel2.setValueAt(floor.getClipColor(), n, Column.CLIPCOLOR.ordinal());
    }

    public void saveValues() {
        Floor floor;
        this.d_mediator.pauseUpdates();
        List<Floor> list = this.saveFloors();
        FloorManager floorManager = this.d_mediator.getFloorManager();
        ArrayList<Floor> arrayList = new ArrayList<Floor>();
        ArrayList<Floor> arrayList2 = new ArrayList<Floor>();
        HashMap<String, Floor> hashMap = new HashMap<String, Floor>();
        for (Floor floor2 : list) {
            floor = (Floor)floorManager.get(floor2.getName());
            if (floor != null) {
                if (!floor2.equals(floor)) {
                    floor.setName(floor2.getName());
                    floor.setBgImage(floor2.getBgImage());
                    floor.setElevation(floor2.getElevation());
                    floor.setSlabThickness(floor2.getSlabThickness());
                    floor.setWallHeight(floor2.getWallHeight());
                    floor.setClipColor(floor2.getClipColor());
                }
                hashMap.put(floor2.getName(), floor);
                continue;
            }
            arrayList2.add(floor2);
        }
        for (Floor floor2 : floorManager.flatten()) {
            floor = (Floor)hashMap.get(floor2.getName());
            if (floor != null) continue;
            arrayList.add(floor2);
        }
        floorManager.addAll(arrayList2);
        floorManager.removeAll(arrayList);
        this.d_mediator.resumeUpdates();
    }

    protected List<Floor> saveFloors() {
        ArrayList<Floor> arrayList = new ArrayList<Floor>();
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
        int n = guiDefaultTableModel2.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)guiDefaultTableModel2.getValueAt(i, Column.NAME.ordinal());
            UnitDouble unitDouble = (UnitDouble)guiDefaultTableModel2.getValueAt(i, Column.ELEVATION.ordinal());
            UnitDouble unitDouble2 = (UnitDouble)guiDefaultTableModel2.getValueAt(i, Column.WALL.ordinal());
            UnitDouble unitDouble3 = (UnitDouble)guiDefaultTableModel2.getValueAt(i, Column.SLAB.ordinal());
            ModelImage modelImage = (ModelImage)guiDefaultTableModel2.getValueAt(i, Column.BG.ordinal());
            Color color = (Color)guiDefaultTableModel2.getValueAt(i, Column.CLIPCOLOR.ordinal());
            Floor floor = new Floor(string, unitDouble, unitDouble3, unitDouble2, modelImage, color);
            arrayList.add(floor);
        }
        return arrayList;
    }

    private class BGImageTableCell
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = -4378633585542267895L;
        private FloorBGImageEditor d_editor;
        private FloorBGImageEditor d_renderer;
        private DefaultTableCellRenderer d_defaultRend = new DefaultTableCellRenderer();
        private DefaultCellEditor d_defaultEditor = new DefaultCellEditor(new JTextField());

        public BGImageTableCell() {
            this.d_editor = new FloorBGImageEditor(null, ManageFloorsDlg.this.d_editImageAction);
            this.d_renderer = new FloorBGImageEditor(null, ManageFloorsDlg.this.d_editImageAction);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BGImageTableCell.this.stopCellEditing();
                }
            };
            this.d_editor.addFloorEditedListener(actionListener);
            this.d_editor.addFloorDeletedListener(actionListener);
            this.d_renderer.addFloorEditedListener(actionListener);
            this.d_renderer.addFloorDeletedListener(actionListener);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                Rectangle[] rectangleArray;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                guiTable guiTable2 = (guiTable)mouseEvent.getSource();
                int n = guiTable2.rowAtPoint(mouseEvent.getPoint());
                int n2 = guiTable2.columnAtPoint(mouseEvent.getPoint());
                Rectangle rectangle = guiTable2.getCellRect(n, n2, false);
                Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
                for (Rectangle rectangle2 : rectangleArray = new Rectangle[]{this.d_renderer.getEditButton().getBounds(), this.d_renderer.getDeleteButton().getBounds()}) {
                    if (!rectangle2.contains(point)) continue;
                    return true;
                }
                return mouseEvent.getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = this.d_defaultEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
            return this.getComponent(this.d_editor, component, jTable, object, n, n2, true, true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.d_defaultRend.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this.getComponent(this.d_renderer, component, jTable, object, n, n2, bl, bl2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_editor.getEditingFloor().getBgImage();
        }

        private Component getComponent(FloorBGImageEditor floorBGImageEditor, Component component, JTable jTable, Object object, int n, int n2, boolean bl, boolean bl2) {
            String string = (String)jTable.getValueAt(n, Column.NAME.ordinal());
            if (string == null) {
                string = "";
            }
            ModelImage modelImage = (ModelImage)object;
            Floor floor = new Floor("");
            Floor floor2 = new Floor(string, new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), floor.getSlabThickness().add(floor.getWallHeight()), modelImage, Floor.DEFAULT_COLOR);
            floorBGImageEditor.setEditingFloor(floor2);
            Color color = component.getBackground();
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            if (component instanceof JComponent) {
                border = ((JComponent)component).getBorder();
            }
            floorBGImageEditor.setBorder(border);
            floorBGImageEditor.setBackground(color);
            return floorBGImageEditor;
        }
    }

    private static class NewFloorDlg
    extends guiDialog {
        private static final long serialVersionUID = 8076233534308445082L;
        private final List<Floor> d_floors;
        private final guiTextField d_name;
        private final ValueField<UnitDouble> d_elevation;
        private final ValueField<UnitDouble> d_slab;
        private final ValueField<UnitDouble> d_wall;
        private final Color d_newColor;

        public NewFloorDlg(Window window, List<Floor> list) {
            super(window, Intl.intl("New Floor"), 9);
            UnitDouble unitDouble;
            UnitDouble unitDouble2;
            UnitDouble unitDouble3;
            Object object;
            this.d_floors = list;
            this.d_name = new guiTextField();
            IUnitSrc iUnitSrc = UnitSystem.getSource(0);
            this.d_elevation = ValueFields.udFld(iUnitSrc);
            this.d_slab = ValueFields.udFld(iUnitSrc, UnitDoubleVR.above(0.0, SI.METER, true));
            this.d_wall = ValueFields.udFld(iUnitSrc, UnitDoubleVR.above(0.0, SI.METER, true));
            if (!list.isEmpty()) {
                object = list.get(list.size() - 1);
                unitDouble3 = ((Floor)object).getSlabThickness();
                unitDouble2 = ((Floor)object).getWallHeight();
                unitDouble = this.suggestElevation(list, unitDouble3);
                this.d_newColor = list.get(list.size() - 1).getClipColor();
            } else {
                object = new Floor("");
                unitDouble = ((Floor)object).getElevation();
                unitDouble2 = ((Floor)object).getWallHeight();
                unitDouble3 = ((Floor)object).getSlabThickness();
                this.d_newColor = Floor.DEFAULT_COLOR;
            }
            this.d_elevation.setValue(unitDouble);
            this.d_slab.setValue(unitDouble3);
            this.d_wall.setValue(unitDouble2);
            this.d_name.setValue(this.suggestName(unitDouble));
            object = propertyChangeEvent -> {
                if (!this.d_elevation.validateData(false, false)) {
                    return;
                }
                this.d_name.setValue(this.suggestName((UnitDouble)this.d_elevation.getValue()));
            };
            final PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
                UnitDouble unitDouble = (UnitDouble)this.d_slab.getValue();
                UnitDouble unitDouble2 = this.suggestElevation(list, unitDouble);
                this.d_elevation.setValue(unitDouble2);
            };
            this.d_slab.addValueCommitListener(propertyChangeListener);
            this.d_elevation.addValueChangeListener((PropertyChangeListener)object);
            this.d_elevation.addValueCommitListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    d_slab.removeValueCommitListener(propertyChangeListener);
                    d_elevation.removeValueCommitListener(this);
                }
            });
            this.d_name.addKeyListener(new KeyAdapter((PropertyChangeListener)object){
                final /* synthetic */ PropertyChangeListener val$elevationListener;
                {
                    this.val$elevationListener = propertyChangeListener;
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    d_elevation.removeValueChangeListener(this.val$elevationListener);
                    d_name.removeKeyListener(this);
                }
            });
            guiLabel guiLabel2 = new guiLabel(PyroGuiUtil.loadPyroSimIcon("floor_key.png"));
            guiLabel2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
            gridBagHelper.d_colSpace = 24;
            gridBagHelper.addRow(Intl.intl("Name:"), this.d_name, 1, 1.0, guiLabel2, new double[]{1.0, 1.0}, new int[]{0, 0});
            gridBagHelper.addRow(Intl.intl("Slab Thickness (A):"), this.d_slab, 1, 1.0);
            gridBagHelper.addRow(Intl.intl("Elevation (B):"), this.d_elevation, 1, 1.0);
            gridBagHelper.addRow(Intl.intl("Wall Height (C):"), this.d_wall, 1, 1.0);
            gridBagHelper.finalizeRows();
        }

        private String suggestName(UnitDouble unitDouble) {
            unitDouble = unitDouble.convert(PyroSim.getApp().getUnitSystem().getLengthUnit());
            return String.format(Intl.intl("Floor %s"), Global.format(unitDouble));
        }

        private UnitDouble suggestElevation(List<Floor> list, UnitDouble unitDouble) {
            if (list.isEmpty()) {
                assert (false);
                Floor floor = new Floor("");
                return floor.getElevation();
            }
            Floor floor = list.get(list.size() - 1);
            return floor.getCeilingLoc().add(unitDouble);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (bl) {
                Floor floor = this.save();
                for (Floor floor2 : this.d_floors) {
                    if (!floor.intersects(floor2)) continue;
                    String string = String.format(Intl.intl("Floor overlaps %s. Would you like to continue?"), floor2.getName());
                    int n = JOptionPane.showConfirmDialog(this, string, Intl.intl("Overlapping Floors"), 0);
                    if (n == 0) break;
                    return false;
                }
            }
            return true;
        }

        public Floor save() {
            return new Floor(this.d_name.getText(), (UnitDouble)this.d_elevation.getValue(), (UnitDouble)this.d_slab.getValue(), (UnitDouble)this.d_wall.getValue(), null, this.d_newColor);
        }
    }

    private class AddFloorAction
    extends guiAction {
        private static final long serialVersionUID = 8519975812980401958L;

        public AddFloorAction() {
            super(Intl.intl("Add Floor..."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ManageFloorsDlg.this.validateData(true, true)) {
                return;
            }
            List<Floor> list = ManageFloorsDlg.this.saveFloors();
            Collections.sort(list, new Floor.CompareLevel());
            NewFloorDlg newFloorDlg = new NewFloorDlg(ManageFloorsDlg.this.getOwner(), list);
            if (newFloorDlg.doModal() != 1) {
                return;
            }
            Floor floor = newFloorDlg.save();
            TableModel tableModel = ManageFloorsDlg.this.d_table.getModel();
            int n = tableModel.getRowCount();
            ManageFloorsDlg.this.load(floor, n);
        }
    }

    private static enum Column {
        NAME(Intl.intl("Name"), String.class, false),
        ELEVATION(Intl.intl("Elevation"), UnitDouble.class, false),
        SLAB(Intl.intl("Slab Thickness"), UnitDouble.class, false),
        WALL(Intl.intl("Wall Height"), UnitDouble.class, false),
        CLIPCOLOR(Intl.intl("Clip Color"), Color.class, false),
        BG(Intl.intl("Background Image"), ModelImage.class, true);

        public final String desc;
        public final Class type;
        public final boolean nullAllowed;

        private Column(String string2, Class clazz, boolean bl) {
            this.desc = string2;
            this.type = clazz;
            this.nullAllowed = bl;
        }
    }
}

