/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class LibraryDlg
extends guiDialog {
    private static final long serialVersionUID = 6394989489998116704L;
    private static final Map<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>> s_retrievers = new HashMap<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>>();
    private final PyroMod d_mediator = PyroSim.getApp().getMediator();
    private final guiComboBox<IMgrRetriever<? extends IPyroObject>> d_libCB;
    private final JList<IPyroObject> d_modelObjs;
    private final JList<IPyroObject> d_libObjs;
    private final JButton d_loadFromLibBtn;
    private final JButton d_saveToLibBtn;
    private final JButton d_chooseLibBtn;
    private final JButton d_saveLibBtn;
    private final JButton d_newLibBtn;
    private final JButton d_deleteLibObjBtn;
    private final JButton d_deleteModelObjBtn;
    private final guiLabel d_libLbl;
    private guiFileChooser d_libChooser;
    private String d_currentLib = "";
    private PyroMod d_libModel = null;
    private boolean d_libUnsaved = false;

    private static <T extends IPyroObject> void registerRetriever(IMgrRetriever<T> iMgrRetriever) {
        s_retrievers.put(iMgrRetriever.getType(), iMgrRetriever);
    }

    public LibraryDlg(JFrame jFrame, Class<? extends IPyroObject> clazz) {
        super((Window)jFrame, Intl.intl("PyroSim Libraries"), 16);
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
        }
        this.addWindowListener(new CloseListener());
        this.d_libCB = new guiComboBox();
        this.d_libCB.setRenderer(new RetrieverRenderer());
        this.d_libCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                LibraryDlg.this.updateLibSelection();
            }
        });
        this.d_libChooser = new guiFileChooser();
        this.d_libChooser.setAcceptAllFileFilterUsed(true);
        this.d_libChooser.addChoosableFileFilter(new ExampleFileFilter("fds", "Database File"));
        this.d_modelObjs = new JList(new DefaultListModel());
        this.d_libObjs = new JList(new DefaultListModel());
        JScrollPane jScrollPane = new JScrollPane(this.d_modelObjs);
        JScrollPane jScrollPane2 = new JScrollPane(this.d_libObjs);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane.getViewport().setScrollMode(2);
        jScrollPane2.getViewport().setScrollMode(2);
        Dimension dimension = new Dimension(170, 200);
        jScrollPane2.setPreferredSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        this.d_loadFromLibBtn = new JButton("<--");
        this.d_saveToLibBtn = new JButton("-->");
        this.d_chooseLibBtn = new JButton(Intl.intl("Load Library..."));
        this.d_saveLibBtn = new JButton(Intl.intl("Save Current Library..."));
        this.d_newLibBtn = new JButton(Intl.intl("Create New Library"));
        this.d_deleteModelObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_deleteLibObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_chooseLibBtn.addActionListener(new LoadLibraryAction());
        this.d_saveToLibBtn.addActionListener(new SaveToLibraryAction());
        this.d_loadFromLibBtn.addActionListener(new LoadFromLibraryAction());
        this.d_saveLibBtn.addActionListener(new SaveLibraryAction());
        this.d_newLibBtn.addActionListener(new CreateLibraryAction());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Current Model"));
        this.d_libLbl = new guiLabel(Intl.intl("Library - \"untitled\""));
        Dimension dimension2 = this.d_libLbl.getPreferredSize();
        dimension2.width = dimension.width;
        this.d_libLbl.setPreferredSize(dimension2);
        int n = 0;
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel2, this.d_libLbl, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, jScrollPane2, 0, n++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel2, this.d_newLibBtn, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_chooseLibBtn, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_saveLibBtn, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_deleteLibObjBtn, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        n = 0;
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel3, guiLabel2, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, jScrollPane, 0, n++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(guiPanel3, this.d_deleteModelObjBtn, 0, n++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 6));
        jPanel.add(this.d_loadFromLibBtn);
        jPanel.add(this.d_saveToLibBtn);
        n = 0;
        guiPanel guiPanel4 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel4, guiPanel3, 0, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        GridBagUtil.add(guiPanel4, jPanel, 1, 1, 1, 4, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, guiPanel2, 2, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        guiPanel guiPanel5 = this.getDialogPane();
        guiPanel5.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel5, new guiLabel(Intl.intl("Category:")), 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, this.d_libCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, new JSeparator(0), 0, 1, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, guiPanel4, 0, 2, 10, 1, 0, 0, 6, 6, 1, 1.0, 1.0, 17);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LibraryDlg.this.updateActions();
            }
        };
        this.d_modelObjs.addListSelectionListener(listSelectionListener);
        this.d_libObjs.addListSelectionListener(listSelectionListener);
        DeleteModelObjectsAction deleteModelObjectsAction = new DeleteModelObjectsAction();
        DeleteLibraryObjectsAction deleteLibraryObjectsAction = new DeleteLibraryObjectsAction();
        this.d_modelObjs.addKeyListener(deleteModelObjectsAction);
        this.d_libObjs.addKeyListener(deleteLibraryObjectsAction);
        this.d_deleteLibObjBtn.addActionListener(deleteLibraryObjectsAction);
        this.d_deleteModelObjBtn.addActionListener(deleteModelObjectsAction);
        ManagerRenderer managerRenderer = new ManagerRenderer();
        this.d_modelObjs.setCellRenderer(managerRenderer);
        this.d_libObjs.setCellRenderer(managerRenderer);
        this.d_saveToLibBtn.setEnabled(false);
        this.d_loadFromLibBtn.setEnabled(false);
        this.d_deleteModelObjBtn.setEnabled(false);
        this.d_deleteLibObjBtn.setEnabled(false);
        this.init();
        Collection<IMgrRetriever<? extends IPyroObject>> collection = theUtil.sort(new ANameSorter<IMgrRetriever<? extends IPyroObject>>(){

            @Override
            protected String getName(IMgrRetriever<? extends IPyroObject> iMgrRetriever) {
                return iMgrRetriever.getDescription();
            }
        }, s_retrievers.values());
        this.d_libCB.setItems(collection);
        if (clazz != null) {
            this.d_libCB.setSelectedItem(s_retrievers.get(clazz));
        } else {
            this.d_libCB.setSelectedIndex(0);
        }
        this.updateLibSelection();
    }

    private void updateLibSelection() {
        this.loadList(this.d_mediator, this.d_modelObjs);
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    private Composite getManager(PyroMod pyroMod) {
        return this.d_libCB.getSelectedItem().getManager(pyroMod);
    }

    private Predicate<? extends IPyroObject> getFilter() {
        return this.d_libCB.getSelectedItem().getFilter();
    }

    private void updateActions() {
        boolean bl = !this.d_modelObjs.isSelectionEmpty();
        boolean bl2 = !this.d_libObjs.isSelectionEmpty();
        this.d_deleteLibObjBtn.setEnabled(bl2);
        this.d_loadFromLibBtn.setEnabled(bl2);
        this.d_deleteModelObjBtn.setEnabled(bl);
        this.d_saveToLibBtn.setEnabled(bl);
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            if (!this.checkSaveNewLib()) {
                return;
            }
            PyroPrefs.set(PyroPrefs.PREF_LASTLIBRARY, this.d_currentLib, true);
        }
        super.setVisible(bl);
    }

    private boolean init() {
        String string = PyroPrefs.getString(PyroPrefs.PREF_LASTLIBRARY);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        if (!string.equals(PyroPrefs.PREF_LASTLIBRARY.defVal)) {
            arrayList.add(PyroPrefs.PREF_LASTLIBRARY.defVal);
        }
        for (String string2 : arrayList) {
            if (!this.loadLibraryModelFromFile(string2, false)) continue;
            this.setCurrentLibrary(string2);
            return true;
        }
        this.createLibrary();
        this.d_libUnsaved = false;
        return true;
    }

    private void setCurrentLibrary(String string) {
        this.d_currentLib = string;
        File file = new File(this.d_currentLib);
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), file);
        String string2 = String.format(Intl.intl("Library: ...%s"), file.getName());
        String string3 = String.format(Intl.intl("Library: %s"), file.getAbsolutePath());
        this.d_libLbl.setText(string2);
        this.d_libLbl.setToolTipText(string3);
    }

    public void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new PyroMod();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.fds");
    }

    private boolean checkSaveNewLib() {
        int n;
        return !this.d_libUnsaved || !((n = JOptionPane.showConfirmDialog(this, Intl.intl("The current library has not been saved.  Would you like to do so now?"), Intl.intl("Save New Library") + "?", 1)) == 0 ? !this.saveLibrary() : n == 2 || n == -1);
    }

    private boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        File file = new File(this.d_currentLib);
        if (file.isFile()) {
            this.d_libChooser.setSelectedFile(file);
        } else {
            this.d_libChooser.setCurrentDirectory(PyroSim.getApp().getLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString()));
        }
        int n = this.d_libChooser.showOpenDialog(this);
        if (n != 0) {
            return false;
        }
        file = this.d_libChooser.getSelectedFile();
        if (!this.loadLibraryModelFromFile(file.getAbsolutePath(), true)) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("The file \"%s\" could not be read."), file.getAbsolutePath()));
            return false;
        }
        this.setCurrentLibrary(file.getAbsolutePath());
        return true;
    }

    public boolean loadLibraryModelFromFile(String string, boolean bl) {
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), new File(string));
        try {
            this.d_libModel = new PyroMod();
            FDSParser fDSParser = FDS.newParser(6);
            FDSParseResult fDSParseResult = fDSParser.parseFile(string, this.d_libModel);
            if (bl) {
                fDSParseResult.warningReport.showWarnings(this, false);
            }
            this.d_libUnsaved = false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean saveLibrary() {
        ArrayList<? extends IPyroObject> arrayList = new ArrayList<IPyroObject>();
        for (IMgrRetriever<? extends IPyroObject> iMgrRetriever : s_retrievers.values()) {
            arrayList.addAll(LibraryDlg.getObjects(this.d_libModel, iMgrRetriever));
        }
        File file = Actions.exportToFile(this, new File(this.d_currentLib), this.d_libModel, arrayList, PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        if (file == null) {
            return false;
        }
        this.setCurrentLibrary(file.getAbsolutePath());
        this.d_libUnsaved = false;
        return true;
    }

    private boolean deleteObjs(JList<IPyroObject> jList, PyroMod pyroMod) {
        List<IPyroObject> list = jList.getSelectedValuesList();
        if (list.isEmpty()) {
            return false;
        }
        Task task = Actions.getDeleteTask(pyroMod, list);
        if (task == null) {
            return false;
        }
        pyroMod.getTaskManager().exec(task, Intl.intl("Delete Objects"));
        this.loadList(pyroMod, jList);
        this.preserveSelection(list, jList, this.getManager(pyroMod));
        return true;
    }

    private void preserveSelection(Collection<? extends IPyroObject> collection, JList<IPyroObject> jList, Composite<? extends IPyroObject> composite) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        jList.clearSelection();
        for (IPyroObject iPyroObject : collection) {
            if (!composite.containsDeep(iPyroObject)) continue;
            arrayList.add(this.indexOf(jList, iPyroObject));
        }
        jList.setSelectedIndices(theUtil.toIntArray(arrayList));
    }

    private int indexOf(JList<IPyroObject> jList, IPyroObject iPyroObject) {
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            if (jList.getModel().getElementAt(i) != iPyroObject) continue;
            return i;
        }
        return -1;
    }

    private static <T extends IPyroObject> Collection<T> getObjects(PyroMod pyroMod, IMgrRetriever<T> iMgrRetriever) {
        Composite<T> composite = iMgrRetriever.getManager(pyroMod);
        Predicate<T> predicate = iMgrRetriever.getFilter();
        Collection<T> collection = predicate != null ? composite.flatten(iMgrRetriever.getType(), predicate) : ((APyroObject)composite).flatten(iMgrRetriever.getType());
        return Util.sort(collection);
    }

    private void loadList(PyroMod pyroMod, JList<IPyroObject> jList) {
        jList.setListData((IPyroObject[])theUtil.toArray(LibraryDlg.getObjects(pyroMod, this.d_libCB.getSelectedItem()), IPyroObject.class));
    }

    private Set<? extends IPyroObject> getListContents(JList<IPyroObject> jList) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ListModel<IPyroObject> listModel = jList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            linkedIdentityHashSet.add(listModel.getElementAt(i));
        }
        return linkedIdentityHashSet;
    }

    public boolean copyListSelection(JList<IPyroObject> jList, JList<IPyroObject> jList2, PyroMod pyroMod, PyroMod pyroMod2) {
        Set<? extends IPyroObject> set = this.getListContents(jList2);
        List<IPyroObject> list = jList.getSelectedValuesList();
        if (list.isEmpty()) {
            return true;
        }
        try {
            Actions.doTransfer(pyroMod, pyroMod2, list);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        this.loadList(pyroMod2, jList2);
        Set<? extends IPyroObject> set2 = this.getListContents(jList2);
        set2.removeAll(set);
        this.preserveSelection(set2, jList2, this.getManager(pyroMod2));
        return true;
    }

    static {
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Materials"), Material.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getMaterialMgr();
            }
        });
        Predicate<Surface> predicate = new Predicate<Surface>(){

            @Override
            public boolean test(Surface surface) {
                return !surface.isPredefined();
            }
        };
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Surfaces"), Surface.class, (Predicate)predicate){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getSurfaceMgr();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Gas-phase Reactions"), Reaction.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getReactions();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Smoke Detector Models"), SmokeLinkModel.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getSmokeLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Heat Detector Models"), HeatLinkModel.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getHeatLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Sprinkler Link Models"), SprinklerLinkModel.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getSprinklerLinkModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Spray Models"), SprayModel.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getSprayModels();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Particles"), Particle.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getPartList();
            }
        });
        LibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Species"), ExSpec.class){

            @Override
            public Composite getManager(PyroMod pyroMod) {
                return pyroMod.getExSpecList();
            }
        });
    }

    private class ManagerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7049889130747457100L;

        private ManagerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            IPyroObject iPyroObject = (IPyroObject)object;
            this.setText(Util.getName(iPyroObject));
            return this;
        }
    }

    private class RetrieverRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4364493595770278351L;

        private RetrieverRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            IMgrRetriever iMgrRetriever = (IMgrRetriever)object;
            this.setText(iMgrRetriever.getDescription());
            return this;
        }
    }

    private class DeleteLibraryObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteLibraryObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.deleteSurfs();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                this.deleteSurfs();
            } else {
                super.keyReleased(keyEvent);
            }
        }

        private void deleteSurfs() {
            if (LibraryDlg.this.deleteObjs(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_libModel)) {
                LibraryDlg.this.d_libUnsaved = true;
            }
        }
    }

    private class DeleteModelObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteModelObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryDlg.this.deleteObjs(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_mediator);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                LibraryDlg.this.deleteObjs(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_mediator);
            } else {
                super.keyReleased(keyEvent);
            }
        }
    }

    private class SaveToLibraryAction
    implements ActionListener {
        private SaveToLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Application.getApp().beginWaitCursor();
            boolean bl = LibraryDlg.this.copyListSelection(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libObjs, LibraryDlg.this.d_mediator, LibraryDlg.this.d_libModel);
            if (bl) {
                LibraryDlg.this.d_libUnsaved = true;
            }
            Application.getApp().endWaitCursor();
        }
    }

    private class LoadFromLibraryAction
    implements ActionListener {
        private LoadFromLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Application.getApp().beginWaitCursor();
            LibraryDlg.this.copyListSelection(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libModel, LibraryDlg.this.d_mediator);
            Application.getApp().endWaitCursor();
        }
    }

    private class SaveLibraryAction
    implements ActionListener {
        private SaveLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryDlg.this.saveLibrary();
        }
    }

    private class LoadLibraryAction
    implements ActionListener {
        private LoadLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LibraryDlg.this.loadLibraryModel()) {
                LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
            }
        }
    }

    private class CreateLibraryAction
    implements ActionListener {
        private CreateLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryDlg.this.createLibrary();
            LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            LibraryDlg.this.d_status = 8;
        }
    }

    public static abstract class AMgrRetriever<T extends IPyroObject>
    implements IMgrRetriever<T> {
        private final Class<T> d_type;
        private final String d_desc;
        private final Predicate<T> d_filter;

        public AMgrRetriever(String string, Class<T> clazz) {
            this(string, clazz, null);
        }

        public AMgrRetriever(String string, Class<T> clazz, Predicate<T> predicate) {
            this.d_desc = string;
            this.d_filter = predicate;
            this.d_type = clazz;
        }

        @Override
        public String getDescription() {
            return this.d_desc;
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public Predicate<T> getFilter() {
            return this.d_filter;
        }
    }

    public static interface IMgrRetriever<T extends IPyroObject> {
        public String getDescription();

        public Composite<T> getManager(PyroMod var1);

        public Class<T> getType();

        public Predicate<T> getFilter();
    }
}

