/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class KeepOverwriteDlg
extends guiDialog {
    private static final long serialVersionUID = -4831590492032909584L;
    public static final int TYPE_MATERIAL = 0;
    public static final int TYPE_REACTION = 1;
    public static final int KEEP = 0;
    public static final int OVERWRITE = 1;
    public static final int RENAME = 2;
    private int d_choice = 0;
    private guiTextField d_name;
    private guiRadioButton d_keepRB;
    private guiRadioButton d_overRB;
    private guiRadioButton d_nameRB;
    private String d_origName;
    private int d_type;

    public KeepOverwriteDlg(JFrame jFrame, String string, int n) {
        super((Window)jFrame, "", 1);
        String string2 = "";
        string2 = n == 0 ? Intl.intl("Surface") : "Reaction";
        String string3 = "Duplicate " + string2 + " Name";
        this.setTitle(string3);
        this.d_type = n;
        this.d_origName = string;
        this.d_name = new guiTextField(this.d_origName);
        this.d_name.setEnabled(false);
        guiPanel guiPanel2 = this.getDialogPane();
        MultiLineLabel multiLineLabel = null;
        if (n == 0) {
            multiLineLabel = new MultiLineLabel("A material being pasted has the same name as a material existing in the model, but the two have different properties. Obstructions on the clipboard may reference the clipboard version of the material. What would you like to do?");
            this.d_keepRB = new guiRadioButton("<html><B>Keep</B> model version (change clipboard references)", true);
            this.d_overRB = new guiRadioButton("<html><B>Overwrite</B> model version with material on the clipboard", false);
            this.d_nameRB = new guiRadioButton("<html><B>Rename</B> and paste the clipboard material:");
        } else {
            multiLineLabel = new MultiLineLabel("A reaction being pasted has the same name as a reaction existing in the model, but the two have different properties. What would you like to do?");
            this.d_keepRB = new guiRadioButton("<html><B>Keep</B> model version", true);
            this.d_overRB = new guiRadioButton("<html><B>Overwrite</B> model version with reaction on the clipboard", false);
            this.d_nameRB = new guiRadioButton("<html><B>Rename</B> and paste the clipboard reaction:");
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.d_keepRB);
        buttonGroup.add(this.d_overRB);
        buttonGroup.add(this.d_nameRB);
        RBListen rBListen = new RBListen();
        this.d_keepRB.addItemListener(rBListen);
        this.d_overRB.addItemListener(rBListen);
        this.d_nameRB.addItemListener(rBListen);
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, multiLineLabel, 0, 0, 2, 1, 0, 0, 6, 0);
        GridBagUtil.add(guiPanel2, this.d_keepRB, 0, 1, 2, 1, 0, 0, 6, 0);
        GridBagUtil.add(guiPanel2, this.d_overRB, 0, 2, 2, 1, 0, 0, 6, 0);
        GridBagUtil.add(guiPanel2, this.d_nameRB, 0, 3, 1, 1, 0, 0, 6, 12);
        GridBagUtil.add(guiPanel2, this.d_name, 1, 3, 1, 1, 0, 0, 0, 0);
        this.pack();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_nameRB.isSelected()) {
            PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
            if (this.d_type == 0 && pyroMod.getSurfaceMgr().get(this.d_name.getValue()) != null) {
                JOptionPane.showMessageDialog(this, Intl.intl("Please enter a unique name for the new material or choose another option."), Intl.intl("Illegal Name"), 0);
                return false;
            }
            if (this.d_type == 1 && pyroMod.getReactions().get(this.d_name.getValue()) != null) {
                JOptionPane.showMessageDialog(this, Intl.intl("Please enter a unique name for the new reaction or choose another option."), Intl.intl("Illegal Name"), 0);
                return false;
            }
        }
        return true;
    }

    public int getChoice() {
        return this.d_choice;
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    public static void main(String[] stringArray) {
        new KeepOverwriteDlg(null, "Casey", 0).doModal();
    }

    private class RBListen
    implements ItemListener {
        private RBListen() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == KeepOverwriteDlg.this.d_keepRB) {
                KeepOverwriteDlg.this.d_choice = 0;
                KeepOverwriteDlg.this.d_name.setEnabled(false);
            } else if (itemEvent.getSource() == KeepOverwriteDlg.this.d_overRB) {
                KeepOverwriteDlg.this.d_choice = 1;
                KeepOverwriteDlg.this.d_name.setEnabled(false);
            } else if (itemEvent.getSource() == KeepOverwriteDlg.this.d_nameRB) {
                KeepOverwriteDlg.this.d_choice = 2;
                KeepOverwriteDlg.this.d_name.setEnabled(true);
            }
        }
    }
}

