/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.VariantEditor;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;

public class HvacEditor
extends guiPanel
implements IEditor<IHvacObject> {
    private static final long serialVersionUID = -6076515160878952939L;
    private IEditor<IHvacObject> d_aircoilEditor;
    private IEditor<IHvacObject> d_fanEditor;
    private IEditor<IHvacObject> d_filterEditor;
    private IEditor<IHvacObject> d_leakEditor;
    private IEditor<IHvacObject> d_currentEditor;

    public HvacEditor(PyroMod pyroMod, UnitSystem unitSystem) {
        this.d_aircoilEditor = new AircoilEditor(pyroMod, unitSystem);
        this.d_fanEditor = new FanEditor(pyroMod, unitSystem);
        this.d_filterEditor = new FilterEditor(pyroMod, unitSystem);
        this.d_leakEditor = new LeakEditor(pyroMod);
        this.d_currentEditor = this.d_fanEditor;
        this.setLayout(new CardLayout());
        this.add((Component)this.d_aircoilEditor.getEditorPanel(), "AIRCOIL");
        this.add((Component)this.d_fanEditor.getEditorPanel(), "FAN");
        this.add((Component)this.d_filterEditor.getEditorPanel(), "FILTER");
        this.add((Component)this.d_leakEditor.getEditorPanel(), "LEAK");
        ((CardLayout)this.getLayout()).next(this);
        this.setModified(false);
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.d_aircoilEditor.getEditorPanel().setEnabled(bl);
        this.d_fanEditor.getEditorPanel().setEnabled(bl);
        this.d_filterEditor.getEditorPanel().setEnabled(bl);
        this.d_leakEditor.getEditorPanel().setEnabled(bl);
    }

    @Override
    public void init(IHvacObject iHvacObject) {
        this.setEnabled(iHvacObject != null);
        if (iHvacObject == null) {
            return;
        }
        this.d_currentEditor = null;
        if (iHvacObject instanceof HvacAircoil) {
            this.d_currentEditor = this.d_aircoilEditor;
            ((CardLayout)this.getLayout()).show(this, "AIRCOIL");
        } else if (iHvacObject instanceof HvacFan) {
            this.d_currentEditor = this.d_fanEditor;
            ((CardLayout)this.getLayout()).show(this, "FAN");
        } else if (iHvacObject instanceof HvacFilter) {
            this.d_currentEditor = this.d_filterEditor;
            ((CardLayout)this.getLayout()).show(this, "FILTER");
        } else if (iHvacObject instanceof HvacLeak) {
            this.d_currentEditor = this.d_leakEditor;
            ((CardLayout)this.getLayout()).show(this, "LEAK");
        } else assert (false);
        this.d_currentEditor.init(iHvacObject);
        this.setModified(false);
    }

    @Override
    public IHvacObject preview(IHvacObject iHvacObject) {
        return this.d_currentEditor.preview(iHvacObject);
    }

    @Override
    public IHvacObject commit(IHvacObject iHvacObject) {
        IHvacObject iHvacObject2 = this.d_currentEditor.commit(iHvacObject);
        this.setModified(false);
        return iHvacObject2;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static class FilterEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 1946930149280272514L;
        private final guiTextField d_idTF;
        private final guiTextField d_fyi;
        private final guiRadioButton d_lossRB;
        private final guiRadioButton d_rampRB;
        private final ValueField<UnitDouble> d_cleanLoss;
        private final ValueField<UnitDouble> d_loss;
        private guiTableEditor d_tableEditor;
        private guiTable d_table;
        private final VariantEditor d_ramp;
        private final CustomFDSPanel d_customPnl;
        private PyroMod d_domain;

        public FilterEditor(PyroMod pyroMod, UnitSystem unitSystem) {
            this.d_domain = pyroMod;
            this.d_customPnl = new CustomFDSPanel(7);
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setLayout((LayoutManager)new MigLayout("insets 12", "", "[]5[]5[]5[]5[]10[]10[]"));
            jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
            jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Filter Id: "));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Description: "));
            this.d_idTF = new guiTextField();
            this.d_idTF.setEditable(false);
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)guiLabel2, "growx 0");
            this.add((Component)this.d_idTF, "shrink 0, growx, span");
            this.add((Component)guiLabel3, "grow 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)jTabbedPane, "span, growx, growy");
            this.d_lossRB = new guiRadioButton(Intl.intl("Linear"));
            this.d_rampRB = new guiRadioButton(Intl.intl("Custom"));
            new guiButtonGroup(this.d_lossRB, this.d_rampRB);
            guiPanel guiPanel3 = new guiPanel();
            guiPanel3.setLayout((LayoutManager)new MigLayout("insets 0 8 0 0"));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Clean Loss: "));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Loss: "));
            this.d_cleanLoss = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_loss = ValueFields.udFld(UnitSystem.getSource(28));
            String[] stringArray = new String[]{Intl.intl("Species"), Intl.intl("Efficiency"), Intl.intl("Initial Loading"), Intl.intl("Loading Multiplier")};
            this.d_tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, new Class[]{String.class, UnitDouble.class, UnitDouble.class, UnitDouble.class}), 0);
            this.d_table = this.d_tableEditor.getTable();
            guiTable.UnitDoubleEditor unitDoubleEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getMass());
            guiTable.UnitDoubleEditor unitDoubleEditor2 = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getUnitlessUnit());
            this.d_table.getColumnModel().getColumn(1).setCellEditor(unitDoubleEditor2);
            this.d_table.getColumnModel().getColumn(2).setCellEditor(unitDoubleEditor);
            this.d_table.getColumnModel().getColumn(3).setCellEditor(unitDoubleEditor2);
            this.d_table.setNullValuesAllowed(false);
            this.d_table.autoSizeColumns(120);
            TableColumn tableColumn = this.d_table.getColumnModel().getColumn(0);
            guiComboBox guiComboBox2 = new guiComboBox();
            ExSpecList exSpecList = pyroMod.getExSpecList();
            for (ExSpec exSpec : exSpecList.getMembers(ExSpec.class)) {
                guiComboBox2.addItem((String)exSpec.getName());
            }
            tableColumn.setCellEditor(new DefaultCellEditor(guiComboBox2));
            guiPanel3.add(guiLabel4);
            guiPanel3.add(this.d_cleanLoss, "wrap");
            guiPanel3.add(guiLabel5);
            guiPanel3.add(this.d_loss, "wrap");
            LinkStatus.link((AbstractButton)this.d_lossRB, guiPanel3);
            guiPanel guiPanel4 = new guiPanel();
            guiPanel4.setLayout((LayoutManager)new MigLayout("insets 0 8 0 0"));
            this.d_ramp = new VariantEditor(Intl.intl("Loss"), Intl.intl("Pressure Drop"), HvacFilter.FUNC_PROF, false);
            guiPanel4.add(this.d_ramp.getLabel());
            guiPanel4.add((Component)this.d_ramp.getEditor(), "wrap");
            LinkStatus.link((AbstractButton)this.d_rampRB, guiPanel4);
            guiPanel2.add((Component)new guiLabel(Intl.intl("Flow Loss Model")), "split 2, span");
            guiPanel2.add((Component)new JSeparator(), "wrap, growx");
            guiPanel2.add((Component)this.d_lossRB, "wrap");
            guiPanel2.add((Component)guiPanel3, "gapleft 10, wrap");
            guiPanel2.add((Component)this.d_rampRB, "wrap");
            guiPanel2.add((Component)guiPanel4, "gapleft 10, wrap");
            guiPanel2.add((Component)new guiLabel(Intl.intl("Species Filtration")), "split 2, span");
            guiPanel2.add((Component)new JSeparator(), "wrap, growx");
            guiPanel2.add((Component)this.d_tableEditor, "gapleft 10");
        }

        @Override
        public void init(IHvacObject iHvacObject) {
            if (iHvacObject != null) {
                HvacFilter hvacFilter = (HvacFilter)iHvacObject;
                this.d_idTF.setText(iHvacObject.getName());
                this.d_fyi.setText(iHvacObject.getDesc());
                this.d_ramp.init(hvacFilter.getCustomLoss(), true);
                this.d_cleanLoss.setValue((UnitDouble)iHvacObject.getProp("CLEAN_LOSS"));
                List list = (List)iHvacObject.getProp("LOSS");
                if (!list.isEmpty()) {
                    this.d_loss.setValue(list.get(0));
                } else {
                    this.d_loss.setValue(new UnitDouble(0.0, Unit.ONE));
                }
                List list2 = (List)iHvacObject.getProp("SPEC_ID");
                List list3 = (List)iHvacObject.getProp("EFFICIENCY");
                List list4 = (List)iHvacObject.getProp("LOADING");
                List list5 = (List)iHvacObject.getProp("LOADING_MULTIPLIER");
                guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
                guiDefaultTableModel2.setNumRows(list2.size());
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        guiDefaultTableModel2.setValueAt(((ExSpec)list2.get(i)).getName(), i, 0);
                        guiDefaultTableModel2.setValueAt(list3.get(i), i, 1);
                        guiDefaultTableModel2.setValueAt(list4.get(i), i, 2);
                        guiDefaultTableModel2.setValueAt(list5.get(i), i, 3);
                    }
                }
                switch ((HvacFilter.LossModel)((Object)iHvacObject.getProp("opt_loss_ramp"))) {
                    case CUSTOM: {
                        this.d_rampRB.setSelected(true);
                        break;
                    }
                    case LINEAR: {
                        this.d_lossRB.setSelected(true);
                    }
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(hvacFilter), new CustomFDSPanel.AdvPropWrapper<Boolean>(hvacFilter.isForceWrite(), 1));
            }
        }

        @Override
        public boolean isModified() {
            return super.isModified();
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_rampRB.isSelected() && !this.d_ramp.validateData(bl, bl2)) {
                return false;
            }
            ExSpecList exSpecList = this.d_domain.getExSpecList();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                String string;
                ExSpec exSpec;
                if (this.d_table.getValueAt(i, 0) == null || (exSpec = exSpecList.find(string = this.d_table.getValueAt(i, 0).toString(), ExSpec.class, true)) != null) continue;
                this.d_table.flagInvalidCell(i, 0, bl, bl2, String.format(Intl.intl("Unknown species: %s"), string));
                return false;
            }
            return true;
        }

        @Override
        protected void save(IHvacObject iHvacObject, boolean bl) {
            String string = this.d_fyi.getText();
            iHvacObject.setDesc(string);
            ExSpecList exSpecList = this.d_domain.getExSpecList();
            ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>();
            ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> arrayList3 = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> arrayList4 = new ArrayList<UnitDouble>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                String string2;
                ExSpec exSpec;
                if (this.d_table.getValueAt(i, 0) == null || (exSpec = exSpecList.find(string2 = this.d_table.getValueAt(i, 0).toString(), ExSpec.class, true)) == null) continue;
                arrayList.add(exSpec);
                arrayList2.add((UnitDouble)this.d_table.getValueAt(i, 1));
                arrayList3.add((UnitDouble)this.d_table.getValueAt(i, 2));
                arrayList4.add((UnitDouble)this.d_table.getValueAt(i, 3));
            }
            iHvacObject.setProp("SPEC_ID", arrayList);
            iHvacObject.setProp("EFFICIENCY", arrayList2);
            iHvacObject.setProp("LOADING", arrayList3);
            iHvacObject.setProp("LOADING_MULTIPLIER", arrayList4);
            if (this.d_lossRB.isSelected()) {
                iHvacObject.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.LINEAR);
                iHvacObject.setProp("LOSS", Arrays.asList((UnitDouble)this.d_loss.getValue()));
                iHvacObject.setProp("CLEAN_LOSS", this.d_cleanLoss.getValue());
            }
            if (this.d_rampRB.isSelected()) {
                iHvacObject.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.CUSTOM);
                ((HvacFilter)iHvacObject).setCustomLoss(this.d_ramp.getValue());
            }
            this.d_customPnl.save(Collections.singleton((HvacFilter)iHvacObject));
        }

        @Override
        public IHvacObject commit(final IHvacObject iHvacObject) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(iHvacObject, false);
                }
            };
            PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit HVAC Filter"));
            this.setModified(false);
            return iHvacObject;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class LeakEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 1L;
        private final guiTextField d_id;
        private final guiTextField d_fyi;
        private final guiComboBox<Vent> d_vent1Editor;
        private final guiComboBox<Vent> d_vent2Editor;
        private final ValueField<UnitDouble> d_leakArea;
        private final ValueField<UnitDouble> d_loss;
        private final guiCheckBox d_enthalpy;
        private final CustomFDSPanel d_customPnl;
        private PyroMod d_domain;

        public LeakEditor(PyroMod pyroMod) {
            this.d_domain = pyroMod;
            this.d_customPnl = new CustomFDSPanel(7);
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
            jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
            jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Leak Id: "));
            this.d_id = new guiTextField();
            this.d_id.setEditable(false);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Description: "));
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)guiLabel2, "growx 0");
            this.add((Component)this.d_id, "shrink 0, growx, span");
            this.add((Component)guiLabel3, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)jTabbedPane, "span, growx, growy");
            String string = Intl.intl("Ambient");
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Vent 1: "));
            this.d_vent1Editor = new PyroComboBox<Vent>((IPyroObject)this.d_domain.getObstructions(), (Vent)((Object)string), Vent.class);
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Vent 2: "));
            this.d_vent2Editor = new PyroComboBox<Vent>((IPyroObject)this.d_domain.getObstructions(), (Vent)((Object)string), Vent.class);
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Leak Area: "));
            this.d_leakArea = ValueFields.udFld(SIUS.getSource(79), UnitDoubleVR.above(0.0, SI.METER.multiply(SI.METER), true));
            guiLabel guiLabel7 = new guiLabel(Intl.intl("Flow Loss: "));
            this.d_loss = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_enthalpy = new guiCheckBox(Intl.intl("Enable Leak Enthalpy"));
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2, true);
            gridBagHelper.addRow(guiLabel4, this.d_vent1Editor);
            gridBagHelper.addRow(guiLabel5, this.d_vent2Editor);
            gridBagHelper.addRow(guiLabel6, this.d_leakArea);
            gridBagHelper.addRow(guiLabel7, this.d_loss);
            gridBagHelper.addRow(this.d_enthalpy);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void init(IHvacObject iHvacObject) {
            if (iHvacObject != null) {
                HvacLeak hvacLeak = (HvacLeak)iHvacObject;
                this.d_id.setText(iHvacObject.getName());
                this.d_fyi.setText(iHvacObject.getDesc());
                assert (iHvacObject instanceof HvacLeak);
                this.d_vent1Editor.setSelectedItem(hvacLeak.getVent1());
                this.d_vent2Editor.setSelectedItem(hvacLeak.getVent2());
                this.d_leakArea.setValue(hvacLeak.getLeakArea());
                this.d_loss.setValue(hvacLeak.getLoss());
                this.d_enthalpy.setSelected(hvacLeak.isEnthalpyCalc());
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(hvacLeak), new CustomFDSPanel.AdvPropWrapper<Boolean>(hvacLeak.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2);
        }

        @Override
        protected void save(IHvacObject iHvacObject, boolean bl) {
            HvacLeak hvacLeak = (HvacLeak)iHvacObject;
            String string = this.d_fyi.getText();
            hvacLeak.setDesc(string);
            hvacLeak.setVent1(this.d_vent1Editor.getSelectedItem());
            hvacLeak.setVent2(this.d_vent2Editor.getSelectedItem());
            hvacLeak.setLeakArea((UnitDouble)this.d_leakArea.getValue());
            hvacLeak.setLoss((UnitDouble)this.d_loss.getValue());
            hvacLeak.setEnthalpy(this.d_enthalpy.isSelected());
            this.d_customPnl.save(Collections.singleton(hvacLeak));
        }

        @Override
        public IHvacObject commit(final IHvacObject iHvacObject) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(iHvacObject, false);
                }
            };
            ((PyroMod)iHvacObject.getDomain()).getTaskManager().exec(aOneTimeTask, Intl.intl("Edit HVAC Leak"));
            this.setModified(false);
            return iHvacObject;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class FanEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 3387938989345252781L;
        private final guiTextField d_idTF;
        private final guiTextField d_fyi;
        private final CustomFDSPanel d_customPnl = new CustomFDSPanel(7);
        private final ValueField<UnitDouble> d_maxFlowFld;
        private final ValueField<UnitDouble> d_maxPressureFld;
        private final ValueField<UnitDouble> d_volFlowFld;
        private final ValueField<UnitDouble> d_lossFld;
        private final guiRadioButton d_quadBtn;
        private final guiRadioButton d_flowBtn;
        private final guiRadioButton d_rampBtn;
        private TimeFunctionEditor d_tauFan;
        private VariantEditor d_pressureFlowRamp;

        public FanEditor(PyroMod pyroMod, UnitSystem unitSystem) {
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setLayout((LayoutManager)new MigLayout("insets 12", "[][grow]", "[]10[]5[]5[]5[]5[]5[]5[]5[]5[]"));
            jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
            jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Fan Id: "));
            this.d_idTF = new guiTextField();
            this.d_idTF.setEditable(false);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Description: "));
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)guiLabel2, "growx 0");
            this.add((Component)this.d_idTF, "shrink 0, growx, span");
            this.add((Component)guiLabel3, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)jTabbedPane, "span, growx, growy");
            this.d_quadBtn = new guiRadioButton(Intl.intl("Quadratic"));
            this.d_flowBtn = new guiRadioButton(Intl.intl("Constant Flow"));
            this.d_rampBtn = new guiRadioButton(Intl.intl("Defined Ramp"));
            new guiButtonGroup(this.d_quadBtn, this.d_flowBtn, this.d_rampBtn);
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Maximum Flow Rate: "));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Maximum Pressure: "));
            this.d_maxFlowFld = ValueFields.udFld(UnitSystem.getSource(24));
            this.d_maxPressureFld = ValueFields.udFld(UnitSystem.getSource(7));
            LinkStatus.link((AbstractButton)this.d_quadBtn, guiLabel4, this.d_maxFlowFld, guiLabel5, this.d_maxPressureFld);
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Volume Flow Rate: "));
            this.d_volFlowFld = ValueFields.udFld(UnitSystem.getSource(24));
            LinkStatus.link((AbstractButton)this.d_flowBtn, guiLabel6, this.d_volFlowFld);
            this.d_pressureFlowRamp = new VariantEditor(Intl.intl("Fan Curve"), Intl.intl("Pressure Drop"), HvacFan.PRESSUREFLOW_PROFILE, false);
            LinkStatus.link((AbstractButton)this.d_rampBtn, this.d_pressureFlowRamp.getLabel(), this.d_pressureFlowRamp.getCombo(), this.d_pressureFlowRamp.getEditor());
            guiLabel guiLabel7 = new guiLabel(Intl.intl("Flow Loss: "));
            this.d_lossFld = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_tauFan = new TimeFunctionEditor(Intl.intl("Initial Ramp up time"), 13);
            guiPanel2.add((Component)guiLabel7, "split 2, span");
            guiPanel2.add(this.d_lossFld, "wrap");
            guiPanel2.add((Component)new guiLabel(Intl.intl("Fan Model")), "split 2, span");
            guiPanel2.add((Component)new JSeparator(), "growx, wrap");
            guiPanel2.add((Component)this.d_tauFan.getLabel(), "gapleft 10");
            guiPanel2.add((Component)this.d_tauFan.getCombo(), "split 2, span");
            guiPanel2.add((Component)this.d_tauFan.getEditor(), "wrap");
            guiPanel2.add((Component)this.d_quadBtn, "gapleft 10, span, wrap");
            guiPanel2.add((Component)guiLabel4, "gapleft 28");
            guiPanel2.add(this.d_maxFlowFld, "wrap");
            guiPanel2.add((Component)guiLabel5, "gapleft 28");
            guiPanel2.add(this.d_maxPressureFld, "wrap");
            guiPanel2.add((Component)this.d_flowBtn, "gapleft 10, span, wrap");
            guiPanel2.add((Component)guiLabel6, "gapleft 28");
            guiPanel2.add(this.d_volFlowFld, "wrap");
            guiPanel2.add((Component)this.d_rampBtn, "gapleft 10, span, wrap");
            guiPanel2.add((Component)this.d_pressureFlowRamp.getLabel(), "gapleft 28");
            guiPanel2.add((Component)this.d_pressureFlowRamp.getEditor(), "span, wrap");
        }

        @Override
        public void init(IHvacObject iHvacObject) {
            if (iHvacObject != null) {
                HvacFan hvacFan = (HvacFan)iHvacObject;
                this.d_idTF.setText(iHvacObject.getName());
                this.d_fyi.setText(iHvacObject.getDesc());
                this.d_tauFan.loadFunction(hvacFan.getTauFunc());
                this.d_pressureFlowRamp.init(hvacFan.getPressureFlow(), true);
                this.d_maxFlowFld.setValue((UnitDouble)iHvacObject.getProp("MAX_FLOW"));
                this.d_maxPressureFld.setValue((UnitDouble)iHvacObject.getProp("MAX_PRESSURE"));
                this.d_volFlowFld.setValue((UnitDouble)iHvacObject.getProp("VOLUME_FLOW"));
                if (iHvacObject.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_QUADRATIC)) {
                    this.d_quadBtn.setSelected(true);
                } else if (iHvacObject.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_PRESDROP)) {
                    this.d_rampBtn.setSelected(true);
                } else if (iHvacObject.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_VOLFLOW)) {
                    this.d_flowBtn.setSelected(true);
                }
                List list = (List)iHvacObject.getProp("LOSS");
                if (!list.isEmpty()) {
                    this.d_lossFld.setValue((UnitDouble)list.get(0));
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(hvacFan), new CustomFDSPanel.AdvPropWrapper<Boolean>(hvacFan.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            return !this.d_rampBtn.isSelected() || this.d_pressureFlowRamp.validateData(bl, bl2);
        }

        @Override
        protected void save(IHvacObject iHvacObject, boolean bl) {
            HvacFan hvacFan = (HvacFan)iHvacObject;
            hvacFan.setProp("LOSS", Arrays.asList((UnitDouble)this.d_lossFld.getValue()));
            String string = this.d_fyi.getText();
            hvacFan.setDesc(string);
            TimeFunction<?> timeFunction = this.d_tauFan.saveFunction();
            hvacFan.setTauFunc(timeFunction);
            if (this.d_quadBtn.isSelected()) {
                hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
                hvacFan.setProp("MAX_FLOW", this.d_maxFlowFld.getValue());
                hvacFan.setProp("MAX_PRESSURE", this.d_maxPressureFld.getValue());
            }
            if (this.d_flowBtn.isSelected()) {
                hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
                hvacFan.setProp("VOLUME_FLOW", this.d_volFlowFld.getValue());
            }
            if (this.d_rampBtn.isSelected()) {
                hvacFan.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
                Variant variant = this.d_pressureFlowRamp.getValue();
                hvacFan.setPressureFlow(variant);
            }
            this.d_customPnl.save(Collections.singleton(hvacFan));
        }

        @Override
        public IHvacObject commit(final IHvacObject iHvacObject) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(iHvacObject, false);
                }
            };
            ((PyroMod)iHvacObject.getDomain()).getTaskManager().exec(aOneTimeTask, Intl.intl("Edit HVAC Fan"));
            this.setModified(false);
            return iHvacObject;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class AircoilEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 7453401206554491498L;
        private final guiTextField d_id;
        private final guiTextField d_fyi;
        private final CustomFDSPanel d_customPnl = new CustomFDSPanel(7);
        private TimeFunctionEditor d_heatRate;
        private final ValueField<UnitDouble> d_heatRateFld;
        private final ValueField<UnitDouble> d_coolCpFld;
        private final ValueField<UnitDouble> d_coolMassFlowRateFld;
        private final ValueField<UnitDouble> d_coolTempFld;
        private final ValueField<UnitDouble> d_efficiencyFld;
        private final guiRadioButton d_directBtn;
        private final guiRadioButton d_coolantBtn;

        public AircoilEditor(PyroMod pyroMod, UnitSystem unitSystem) {
            this.setLayout((LayoutManager)new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            guiPanel guiPanel2 = new guiPanel();
            guiPanel2.setLayout((LayoutManager)new MigLayout("insets 12", "[][grow]", "[]10[][][][]"));
            jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
            jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Aircoil Id: "));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Description: "));
            this.d_id = new guiTextField();
            this.d_id.setEditable(false);
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)guiLabel2, "growx 0");
            this.add((Component)this.d_id, "shrink 0, growx, span");
            this.add((Component)guiLabel3, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)jTabbedPane, "span, growx, growy");
            this.d_directBtn = new guiRadioButton(Intl.intl("Direct"));
            this.d_coolantBtn = new guiRadioButton(Intl.intl("Coolant Properties"));
            new guiButtonGroup(this.d_directBtn, this.d_coolantBtn);
            guiPanel guiPanel3 = new guiPanel();
            guiPanel3.setLayout((LayoutManager)new MigLayout("insets 0 8 0 0"));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Heat Exchange Rate: "));
            this.d_heatRate = new TimeFunctionEditor(Intl.intl("Ramp-Up Time"), 29);
            this.d_heatRateFld = ValueFields.udFld(UnitSystem.getSource(78));
            guiPanel3.add(guiLabel4);
            guiPanel3.add(this.d_heatRateFld, "span, wrap");
            guiPanel3.add(this.d_heatRate.getLabel());
            guiPanel3.add(this.d_heatRate.getCombo());
            guiPanel3.add(this.d_heatRate.getEditor());
            LinkStatus.link((AbstractButton)this.d_directBtn, guiPanel3);
            guiPanel guiPanel4 = new guiPanel();
            guiPanel4.setLayout((LayoutManager)new MigLayout("insets 0 8 0 0, wrap 2"));
            guiLabel guiLabel5 = new guiLabel(Intl.intl("Coolant Specific Heat: "));
            guiLabel guiLabel6 = new guiLabel(Intl.intl("Coolant Mass Flow Rate: "));
            guiLabel guiLabel7 = new guiLabel(Intl.intl("Coolant Temperature: "));
            guiLabel guiLabel8 = new guiLabel(Intl.intl("Heat Exchanger Efficiency: "));
            this.d_coolCpFld = ValueFields.udFld(UnitSystem.getSource(11));
            this.d_coolMassFlowRateFld = ValueFields.udFld(UnitSystem.getSource(38));
            this.d_coolTempFld = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_efficiencyFld = ValueFields.udFld(UnitSystem.getSource(28));
            guiPanel4.add(guiLabel5);
            guiPanel4.add(this.d_coolCpFld);
            guiPanel4.add(guiLabel6);
            guiPanel4.add(this.d_coolMassFlowRateFld);
            guiPanel4.add(guiLabel7);
            guiPanel4.add(this.d_coolTempFld);
            guiPanel4.add(guiLabel8);
            guiPanel4.add(this.d_efficiencyFld);
            LinkStatus.link((AbstractButton)this.d_coolantBtn, guiPanel4);
            guiPanel2.add(new guiLabel(Intl.intl("Heat Transfer Model")));
            guiPanel2.add((Component)new JSeparator(), "wrap, growx");
            guiPanel2.add((Component)this.d_directBtn, "span 2, wrap");
            guiPanel2.add((Component)guiPanel3, "span, gapleft 10, wrap");
            guiPanel2.add((Component)this.d_coolantBtn, "span 2, wrap");
            guiPanel2.add((Component)guiPanel4, "span, gapleft 10, wrap");
        }

        @Override
        public void init(IHvacObject iHvacObject) {
            if (iHvacObject != null) {
                HvacAircoil hvacAircoil = (HvacAircoil)iHvacObject;
                this.d_id.setText(iHvacObject.getName());
                this.d_fyi.setText(iHvacObject.getDesc());
                this.d_heatRateFld.setValue(hvacAircoil.getFixedQ().val);
                this.d_heatRate.loadFunction(hvacAircoil.getFixedQ().func);
                this.d_coolCpFld.setValue((UnitDouble)iHvacObject.getProp("COOLANT_SPECIFIC_HEAT"));
                this.d_coolMassFlowRateFld.setValue((UnitDouble)iHvacObject.getProp("COOLANT_MASS_FLOW"));
                this.d_coolTempFld.setValue((UnitDouble)iHvacObject.getProp("COOLANT_TEMPERATURE"));
                this.d_efficiencyFld.setValue((UnitDouble)iHvacObject.getProp("EFFICIENCY"));
                HvacAircoil.Model model = (HvacAircoil.Model)((Object)iHvacObject.getProp("opt_aircoil_model"));
                switch (model) {
                    case COOLANT: {
                        this.d_coolantBtn.setSelected(true);
                        break;
                    }
                    case FIXEDQ: {
                        this.d_directBtn.setSelected(true);
                    }
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(hvacAircoil), new CustomFDSPanel.AdvPropWrapper<Boolean>(hvacAircoil.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_heatRate.validateData(bl, bl2);
        }

        @Override
        protected void save(IHvacObject iHvacObject, boolean bl) {
            HvacAircoil hvacAircoil = (HvacAircoil)iHvacObject;
            hvacAircoil.changedEvt(new Object[0]);
            hvacAircoil.setDesc(this.d_fyi.getText());
            if (this.d_directBtn.isSelected()) {
                UnitDouble unitDouble = (UnitDouble)this.d_heatRateFld.getValue();
                TimeFunction<?> timeFunction = this.d_heatRate.saveFunction();
                hvacAircoil.setFixedQ(new TimeBasedValue<UnitDouble>(unitDouble, timeFunction));
                hvacAircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.FIXEDQ);
            } else if (this.d_coolantBtn.isSelected()) {
                hvacAircoil.setProp("COOLANT_SPECIFIC_HEAT", this.d_coolCpFld.getValue());
                hvacAircoil.setProp("COOLANT_MASS_FLOW", this.d_coolMassFlowRateFld.getValue());
                hvacAircoil.setProp("COOLANT_TEMPERATURE", this.d_coolTempFld.getValue());
                hvacAircoil.setProp("EFFICIENCY", this.d_efficiencyFld.getValue());
                hvacAircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.COOLANT);
            }
            this.d_customPnl.save(Collections.singleton(hvacAircoil));
        }

        @Override
        public IHvacObject commit(final IHvacObject iHvacObject) {
            AOneTimeTask aOneTimeTask = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(iHvacObject, false);
                }
            };
            PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit HVAC Aircoil"));
            this.setModified(false);
            return iHvacObject;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    public static abstract class AHvacEditor
    extends guiPanel
    implements IEditor<IHvacObject> {
        private static final long serialVersionUID = 5816966357452647969L;

        protected abstract void save(IHvacObject var1, boolean var2);

        @Override
        public IHvacObject preview(IHvacObject iHvacObject) {
            if (!this.validateData(false, false)) {
                return null;
            }
            this.save(iHvacObject, true);
            return iHvacObject;
        }
    }
}

