/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.Disposable;

public class FloorBGImageEditor
extends guiPanel {
    private static final long serialVersionUID = 6723707473871121849L;
    private Floor d_floor = null;
    private EditBGImageAction d_editAction;
    private guiTextField d_fileName = new guiTextField();
    private JButton d_editButton = new JButton("...");
    private JButton d_deleteButton = new JButton(Intl.intl("Remove"));
    private LinkedList d_floorEditedListeners = new LinkedList();
    private LinkedList d_floorDeletedListeners = new LinkedList();

    public FloorBGImageEditor(Floor floor, EditBGImageAction editBGImageAction) {
        this.setLayout(new GridBagLayout());
        this.d_editAction = editBGImageAction;
        Insets insets = this.d_fileName.getBorder().getBorderInsets(this.d_fileName);
        this.d_fileName.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        this.d_fileName.setEditable(false);
        this.d_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloorBGImageEditor.this.editBGImage();
            }
        });
        this.d_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FloorBGImageEditor.this.deleteBGImage();
            }
        });
        Insets insets2 = this.d_editButton.getMargin();
        insets2.right = 2;
        insets2.left = 2;
        this.d_editButton.setMargin(insets2);
        this.d_deleteButton.setMargin(insets2);
        GridBagUtil.add(this, this.d_fileName, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_editButton, 1, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        GridBagUtil.add(this, this.d_deleteButton, 2, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0, 13);
        this.setEditingFloor(floor);
    }

    public void setEditingFloor(Floor floor) {
        this.d_floor = floor;
        this.updateComponents();
    }

    public Floor getEditingFloor() {
        return this.d_floor;
    }

    public void addFloorEditedListener(ActionListener actionListener) {
        this.d_floorEditedListeners.add(actionListener);
    }

    public void addFloorDeletedListener(ActionListener actionListener) {
        this.d_floorDeletedListeners.add(actionListener);
    }

    protected void deleteBGImage() {
        if (this.d_floor == null) {
            return;
        }
        this.d_floor.setBgImage(null);
        this.updateComponents();
        Iterator iterator = this.d_floorDeletedListeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(null);
        }
    }

    protected void editBGImage() {
        if (this.d_floor == null) {
            return;
        }
        boolean bl = this.d_editAction.editFloor(this.d_floor);
        if (bl) {
            this.updateComponents();
            Iterator iterator = this.d_floorEditedListeners.iterator();
            while (iterator.hasNext()) {
                ((ActionListener)iterator.next()).actionPerformed(null);
            }
        }
    }

    public guiTextField getFilenameTextField() {
        return this.d_fileName;
    }

    public JButton getEditButton() {
        return this.d_editButton;
    }

    public JButton getDeleteButton() {
        return this.d_deleteButton;
    }

    protected void updateComponents() {
        ModelImage modelImage = this.d_floor != null ? this.d_floor.getBgImage() : null;
        this.d_deleteButton.setEnabled(modelImage != null);
        String string = modelImage != null ? modelImage.getImage().getFilename() : null;
        this.d_fileName.setText(string);
        this.d_fileName.setToolTipText(string);
        this.d_fileName.setCaretPosition(0);
        if (this.d_floor != null) {
            this.d_editButton.setToolTipText("Edit the background image for the \"" + this.d_floor.getName() + "\" floor.");
            this.d_deleteButton.setToolTipText("Remove the background image from the \"" + this.d_floor.getName() + "\" floor.");
        } else {
            this.d_editButton.setToolTipText(null);
            this.d_deleteButton.setToolTipText(null);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setBackground(color);
        }
    }

    public static interface EditBGImageAction
    extends Disposable {
        public boolean editFloor(Floor var1);
    }

    private class FocusTP
    extends FocusTraversalPolicy {
        private FocusTP() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(FloorBGImageEditor.this.d_editButton)) {
                return FloorBGImageEditor.this.d_deleteButton;
            }
            if (component.equals(FloorBGImageEditor.this.d_deleteButton)) {
                return FloorBGImageEditor.this.d_fileName;
            }
            if (component.equals(FloorBGImageEditor.this.d_fileName)) {
                return null;
            }
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(FloorBGImageEditor.this.d_editButton)) {
                return null;
            }
            if (component.equals(FloorBGImageEditor.this.d_deleteButton)) {
                return FloorBGImageEditor.this.d_editButton;
            }
            if (component.equals(FloorBGImageEditor.this.d_fileName)) {
                return FloorBGImageEditor.this.d_deleteButton;
            }
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return FloorBGImageEditor.this.d_editButton;
        }

        @Override
        public Component getLastComponent(Container container) {
            return FloorBGImageEditor.this.d_fileName;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return FloorBGImageEditor.this.d_editButton;
        }
    }
}

