/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.SimParams;
import pyrosim.gui.MpiUtil;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.UncUtil;
import thunderheadeng.util.Win32Native;
import thunderheadeng.util.theUtil;

public class FDSRunMonitor
extends guiFrame {
    private static final long serialVersionUID = 5227479430480854756L;
    private static final Set<FDSRunMonitor> d_fdsRunningMonitors = new IdentityHashSet<FDSRunMonitor>();
    private static final int s_commPort;
    private static final Map<String, FDSRunMonitor> s_runningResultsMonitors;
    private JTextArea d_textArea;
    private JScrollPane d_textScrollPane;
    private Rectangle d_viewport = new Rectangle();
    private JButton d_kill = new JButton(Intl.intl("Kill"));
    private JButton d_stop = new JButton(Intl.intl("Stop"));
    private guiCheckBox d_cbRunResults = new guiCheckBox(Intl.intl("Show results when finished"));
    private JButton d_bRunResults = new JButton(Intl.intl("Show Results"));
    private JButton d_bSaveLog = new JButton(Intl.intl("Save Log"));
    private String d_progressStr = Intl.intl("Progress") + ": ";
    private String d_timeRemStr = Intl.intl("Time Remaining") + ": ";
    private String d_ammtProgStr;
    private guiLabel d_progressLbl = new guiLabel(this.d_progressStr);
    private guiLabel d_timeRemLbl = new guiLabel(this.d_timeRemStr);
    private guiLabel d_timeElapsedLbl = new guiLabel(Intl.intl("Time Elapsed") + ": ");
    private guiLabel d_ammtRemLbl;
    private guiLabel d_ammtElapsedLbl;
    private guiLabel d_ammtProgLbl;
    private Set<MonitoredProcess> d_monitoredProcesses = Collections.synchronizedSet(new HashSet());
    private Process d_fdsProcess = null;
    private boolean d_monitoring = true;
    private boolean d_endTime = false;
    private MonitoredProcess d_process = null;
    private static final String nl;
    private PyroMod d_mediator;
    private double d_startSimTime;
    private double d_endSimTime;
    private final String d_chid;
    private final File d_datafile;
    private final File d_smvFile;
    public static final int RESULTS_PREVIEW_MODE = 0;
    public static final int RESULTS_RUN_MODE = 1;
    public static final int FDS_RUN_MODE = 2;
    public static final int FDS_MPI_RUN_MODE = 3;
    private int d_mode = 2;

    private static synchronized void setFDSRunning(FDSRunMonitor fDSRunMonitor, boolean bl) {
        if (bl) {
            d_fdsRunningMonitors.add(fDSRunMonitor);
        } else {
            d_fdsRunningMonitors.remove(fDSRunMonitor);
        }
    }

    public static synchronized boolean isFDSRunning() {
        return !d_fdsRunningMonitors.isEmpty();
    }

    protected static synchronized boolean isFDSRunning(FDSRunMonitor fDSRunMonitor) {
        return d_fdsRunningMonitors.contains(fDSRunMonitor);
    }

    public FDSRunMonitor(String string, String string2) {
        super(string);
        File file;
        this.d_textArea = new JTextArea();
        this.d_textScrollPane = new JScrollPane(this.d_textArea);
        this.d_mediator = ((PyroSim)Application.getApp()).getMediator();
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        final Document document = this.d_textArea.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = document.getLength();
                        try {
                            int n2 = Math.min(100, n);
                            String string = document.getText(n - n2, n2);
                            int n3 = string.lastIndexOf(10);
                            if (n3 == -1) {
                                n3 = 0;
                            }
                            int n4 = n - (n2 - n3);
                            FDSRunMonitor.this.d_textArea.setCaretPosition(n4 + 1);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            FDSRunMonitor.this.d_textArea.setCaretPosition(document.getLength());
                        }
                    }
                });
            }
        });
        this.d_startSimTime = 0.0;
        this.d_endSimTime = 1000.0;
        UnitDouble unitDouble = this.d_mediator.getSimParams().getTime().getStartTime();
        UnitDouble unitDouble2 = this.d_mediator.getSimParams().getTime().getStopTime();
        if (unitDouble != null) {
            this.d_startSimTime = unitDouble.getValue(SI.SECOND) * 1000.0;
        }
        if (unitDouble2 != null) {
            this.d_endSimTime = unitDouble2.getValue(SI.SECOND) * 1000.0;
        }
        this.d_ammtProgStr = "0.0s / " + this.d_endSimTime / 1000.0 + "s";
        this.d_ammtRemLbl = new guiLabel("");
        this.d_ammtElapsedLbl = new guiLabel("0:00:00");
        this.d_ammtProgLbl = new guiLabel(this.d_ammtProgStr);
        ImageIcon imageIcon = PyroGuiUtil.loadPyroSimIcon("run16.png");
        this.setIconImage(imageIcon.getImage());
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.d_kill.addActionListener(actionEvent -> this.killFDS());
        this.d_stop.addActionListener(actionEvent -> this.gentleStop());
        this.d_kill.setEnabled(false);
        this.d_stop.setEnabled(false);
        this.d_textArea.setEditable(false);
        this.d_textScrollPane.setAutoscrolls(true);
        this.d_cbRunResults.addActionListener(actionEvent -> PyroPrefs.set(PyroPrefs.PREF_RUNSV, this.d_cbRunResults.isSelected(), true));
        this.d_datafile = new File(string2);
        this.d_chid = FDS6Renderer.getProperCHID(string2);
        this.d_smvFile = file = new File(this.d_datafile.getParent(), this.d_chid + ".smv");
        this.d_bRunResults.addActionListener(actionEvent -> {
            Thread thread = new Thread(() -> FDSRunMonitor.showResults(ResultsApp.RESULTS, this, this.d_smvFile));
            thread.start();
        });
        this.d_bSaveLog.addActionListener(actionEvent -> this.saveLog());
        this.setSize(500, 500);
        this.setResizable(true);
        int n = 0;
        GridBagUtil.add(container, new FlashyHeader(), 0, n++, 6, 1, 12, 12, 0, 12, 0, 1.0, 0.0);
        GridBagUtil.add(container, this.d_textScrollPane, 0, n++, 6, 1, 12, 12, 0, 12, 1, 1.0, 1.0, 10);
        GridBagUtil.add(container, this.d_progressLbl, 0, n, 1, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_ammtProgLbl, 1, n++, 1, 1, 12, 6, 0, 12, 2, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_timeElapsedLbl, 0, n, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_ammtElapsedLbl, 1, n++, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_timeRemLbl, 0, n, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_ammtRemLbl, 1, n++, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(container, this.d_cbRunResults, 0, n++, 6, 1, 12, 0, 0, 0, 0, 0.0, 0.0, 10);
        guiPanel guiPanel2 = new guiPanel(new FlowLayout(1, 6, 0));
        guiPanel2.add(this.d_kill);
        guiPanel2.add(this.d_stop);
        guiPanel2.add(this.d_bRunResults);
        guiPanel2.add(this.d_bSaveLog);
        GridBagUtil.add(container, guiPanel2, 0, n++, 6, 1, 12, 0, 12, 0, 0, 0.0, 0.0, 10);
    }

    private void setMode(int n) {
        this.d_mode = n;
        if (this.d_mode == 0 || this.d_mode == 1) {
            this.d_bRunResults.setEnabled(false);
        }
    }

    public static void showResults(ResultsApp resultsApp, FDSRunMonitor fDSRunMonitor, File file) {
        try {
            FDSRunMonitor.showResults(resultsApp, file, fDSRunMonitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location specified for the Results executable is invalid.\nPlease specify a valid file by going to \"File->Preferences.\""), Intl.intl("Invalid Results Executable Specified"), 0);
        }
        catch (Throwable throwable) {
            guiUtil.showError(Application.getApp().getActiveFrame(), Intl.intl("Error While Showing Results"), Intl.intl("An error ocurred while attempting to show the results."), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int showResults(ResultsApp resultsApp, File file, FDSRunMonitor fDSRunMonitor) throws FileNotFoundException, Exception {
        MonitoredProcess monitoredProcess2;
        FDSRunMonitor fDSRunMonitor2;
        String string;
        String string2 = resultsApp.getExePath();
        if (string2 == null) {
            return -1;
        }
        String string3 = string = file.getAbsolutePath();
        Map<String, FDSRunMonitor> map = s_runningResultsMonitors;
        synchronized (map) {
            Object object;
            File file2;
            String string4;
            if (resultsApp == ResultsApp.RESULTS && s_runningResultsMonitors.containsKey(string3)) {
                FDSRunMonitor fDSRunMonitor3 = s_runningResultsMonitors.get(string3);
                MonitoredProcess monitoredProcess3 = null;
                Set<MonitoredProcess> set = fDSRunMonitor3.d_monitoredProcesses;
                synchronized (set) {
                    for (MonitoredProcess monitoredProcess4 : fDSRunMonitor3.d_monitoredProcesses) {
                        if (!monitoredProcess4.isConnected()) continue;
                        monitoredProcess3 = monitoredProcess4;
                        break;
                    }
                }
                if (monitoredProcess3 != null) {
                    EventQueue.invokeLater(() -> fDSRunMonitor3.toFront());
                    monitoredProcess3.allowSetForegroundWindow();
                    monitoredProcess3.run(ClientCommand.REFRESH);
                }
                return 0;
            }
            if (fDSRunMonitor != null) {
                fDSRunMonitor2 = fDSRunMonitor;
            } else {
                fDSRunMonitor2 = new FDSRunMonitor(Intl.intl("Results") + " - " + file.getName(), file.getAbsolutePath());
                fDSRunMonitor2.setMode(1);
                fDSRunMonitor2.loadValues();
                fDSRunMonitor2.setVisible(true);
                fDSRunMonitor2.setLocationRelativeTo(fDSRunMonitor2.getParentFrame());
            }
            if (System.getProperty("unc_disable") == null) {
                try {
                    string4 = UncUtil.convertToLocal(string);
                    file2 = new File(string4);
                    if (file2.isFile()) {
                        string = string4;
                    } else {
                        System.err.printf("Error converting SMV filename: %s -> %s%n", string, string4);
                        System.err.printf("Error converting SMV filename: Using original filename.%n", new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if ((string4 = resultsApp.getExePath()) == null) {
                throw new FileNotFoundException();
            }
            if (!new File(string4).exists()) {
                throw new FileNotFoundException(string4);
            }
            file2 = new File(string);
            int n = FDSRunMonitor.newCommId();
            boolean bl = resultsApp == ResultsApp.RESULTS;
            boolean bl2 = bl && s_commPort != -1 && PyroPrefs.getBoolean(PyroPrefs.RESULTS_OPEN_THROUGH_SOCKET);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string4);
            if (!bl) {
                arrayList.add(string);
            } else {
                if (!bl2) {
                    arrayList.add("-r");
                    arrayList.add(string);
                }
                arrayList.add("-locale");
                arrayList.add(Locale.getDefault().toString());
                object = PyroSim.getApp().getMainFrame();
                Point point = ((Component)object).getLocationOnScreen();
                Dimension dimension = (((Frame)object).getExtendedState() & 6) == 6 ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : ((Component)object).getSize();
                arrayList.add("-x");
                arrayList.add(Integer.toString(point.x));
                arrayList.add("-y");
                arrayList.add(Integer.toString(point.y));
                arrayList.add("-w");
                arrayList.add(Integer.toString(dimension.width));
                arrayList.add("-h");
                arrayList.add(Integer.toString(dimension.height));
                if (s_commPort != -1) {
                    arrayList.add("-commport");
                    arrayList.add(Integer.toString(s_commPort));
                    arrayList.add("-commid");
                    arrayList.add(Integer.toString(n));
                }
            }
            object = Runtime.getRuntime().exec(theUtil.toArray(arrayList, String.class), null, file2.getParentFile());
            monitoredProcess2 = fDSRunMonitor2.monitorProcess((Process)object, n, resultsApp.name, string4, TextMonitor.class);
            if (resultsApp == ResultsApp.RESULTS) {
                if (bl2) {
                    monitoredProcess2.onConnect(monitoredProcess -> {
                        monitoredProcess.allowSetForegroundWindow();
                        monitoredProcess.openFile(file2);
                    });
                }
                s_runningResultsMonitors.put(string3, fDSRunMonitor2);
            }
        }
        try {
            int n = monitoredProcess2.d_process.waitFor();
            fDSRunMonitor2.stopMonitoring(monitoredProcess2);
            if ((fDSRunMonitor2.d_mode == 0 || fDSRunMonitor2.d_mode == 1) && n == 0) {
                fDSRunMonitor2.setVisible(false);
            }
            int n2 = n;
            return n2;
        }
        finally {
            if (resultsApp == ResultsApp.RESULTS) {
                s_runningResultsMonitors.remove(string3);
                System.out.println("done showing results");
            }
        }
    }

    public void previewResults(SimParams.OpenMp openMp) {
        this.setMode(0);
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        this.startFDSExecution(this.d_datafile.getAbsolutePath(), 1, openMp);
    }

    public void startFDS(SimParams.OpenMp openMp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        this.setMode(2);
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        this.startFDSExecution(this.d_datafile.getAbsolutePath(), 1, openMp);
    }

    private Component getParentFrame() {
        return Application.getApp() != null ? Application.getApp().getMainFrame() : null;
    }

    public void startFDSmpi(int n, SimParams.OpenMp openMp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        this.setMode(3);
        ImageIcon imageIcon = PyroGuiUtil.loadPyroSimIcon("runparallel16.png");
        this.setIconImage(imageIcon.getImage());
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        System.out.println("Starting fds_mpi for " + n + " grids.");
        String string = this.d_datafile.getAbsolutePath();
        this.startFDSExecution(string, n, openMp);
    }

    public void startClusterFDS(Map<String, Integer> map, int n, File file, SimParams.OpenMp openMp) {
        if (this.d_fdsProcess != null) {
            return;
        }
        ImageIcon imageIcon = PyroGuiUtil.loadPyroSimIcon("runcluster.png");
        this.setIconImage(imageIcon.getImage());
        this.loadValues();
        this.setVisible(true);
        this.setLocationRelativeTo(this.getParentFrame());
        System.out.println("Starting " + file + " for " + n + " grids.");
        this.startClusterFDSExecution(map, this.d_datafile.getAbsolutePath(), file, openMp);
    }

    public void saveLog() {
        File file = PyroSim.getFilenames().getSaveFile((Component)this, "log", Intl.intl("Log Files"));
        if (file == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.print(this.d_textArea.getText());
            printWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, Intl.intl("An unknown error occurred trying to write the file."), Intl.intl("Error Writing File"), 0);
        }
    }

    @Override
    public boolean close() {
        if (FDSRunMonitor.isFDSRunning(this)) {
            String string;
            String string2 = Intl.intl("Close and terminate FDS simulation?");
            if (JOptionPane.showConfirmDialog(this, string2, string = Intl.intl("Simulation in Progress"), 2) != 0) {
                return false;
            }
            this.killFDS();
        }
        return super.close();
    }

    public void loadValues() {
        if (this.d_mode == 0) {
            this.d_cbRunResults.setSelected(true);
            return;
        }
        boolean bl = PyroPrefs.getBoolean(PyroPrefs.PREF_RUNSV);
        this.d_cbRunResults.setSelected(bl);
    }

    private void startFDSExecution(String string, int n, SimParams.OpenMp openMp) {
        File file = this.getStopFile();
        if (file.exists()) {
            file.delete();
        }
        int n2 = this.runFDS(string, n, openMp);
        System.out.println("FDS Exit Code: " + n2);
        if (n2 == 0 && this.d_cbRunResults.isSelected()) {
            FDSRunMonitor.showResults(ResultsApp.RESULTS, this, this.d_smvFile);
        }
    }

    private void startClusterFDSExecution(Map<String, Integer> map, String string, File file, SimParams.OpenMp openMp) {
        File file2 = this.getStopFile();
        if (file2.exists()) {
            file2.delete();
        }
        int n = this.runClusterFDS(map, string, file, openMp);
        System.out.println("FDS Exit Code: " + n);
        if (n == 0 && this.d_cbRunResults.isSelected()) {
            FDSRunMonitor.showResults(ResultsApp.RESULTS, this, this.d_smvFile);
        }
    }

    private int runFDS(String string, int n, SimParams.OpenMp openMp) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = PyroPrefs.getFDSLocation();
        String string3 = PyroPrefs.getRunFDSLocation();
        String string4 = PyroPrefs.getMPIExecLocation();
        File file = new File(string).getParentFile();
        String string5 = null;
        switch (this.d_mode) {
            case 0: 
            case 2: 
            case 3: {
                string5 = string2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (string5 == null) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS File Specified"), 0);
            return -1;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CharSequence[] charSequenceArray = null;
        if (this.d_mode == 2 || this.d_mode == 0) {
            object4 = new File(string5);
            if (!((File)object4).exists()) {
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location specified for FDS is invalid.  Please specify a valid file by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS File Specified"), 0);
                return -1;
            }
            object3 = new File(string3);
            if (!((File)object3).exists()) {
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (runfds.exe)."), Intl.intl("Error Launching FDS"), 0);
                return -1;
            }
            object2 = new ArrayList<String>();
            object2.add(string3);
            object2.add("/belownormal");
            object2.add(string5);
            object2.add(string);
            charSequenceArray = object2.toArray(new String[object2.size()]);
            if (openMp.getOmpNumThreadsFlag()) {
                hashMap.put("OMP_NUM_THREADS", openMp.getOmpNumThreads());
            }
        } else if (this.d_mode == 3) {
            object4 = new File(string5);
            if (!((File)object4).exists()) {
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS_MPI has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS_MPI File Specified"), 0);
                return -1;
            }
            object3 = new File(string3);
            if (!((File)object3).exists()) {
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (runfds.exe)."), Intl.intl("Error Launching FDS"), 0);
                return -1;
            }
            object2 = new File(string4);
            if (!((File)object2).exists()) {
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (mpiexec.exe)."), Intl.intl("Error Launching FDS"), 0);
                return -1;
            }
            object = new ArrayList<String>();
            object.add(string3);
            object.add(string4);
            object.add("-n");
            object.add(Integer.toString(n));
            object.add("-localonly");
            object.add(string5);
            object.add(string);
            charSequenceArray = object.toArray(new String[object.size()]);
            if (openMp.getOmpNumThreadsMPIFlag()) {
                hashMap.put("OMP_NUM_THREADS", openMp.getOmpNumThreadsMPI());
            }
        } else {
            charSequenceArray = new String[]{};
        }
        try {
            System.out.println();
            FDSRunMonitor.setFDSRunning(this, true);
            System.out.println("Command: " + String.join((CharSequence)" ", charSequenceArray));
            System.out.println("CWD:     " + file.getPath());
            object4 = new ProcessBuilder((String[])charSequenceArray);
            MpiUtil.scrubEnvMpi(((ProcessBuilder)object4).environment());
            ((ProcessBuilder)object4).directory(file);
            object3 = ((ProcessBuilder)object4).environment();
            object3.putAll(hashMap);
            if (openMp.getOmpStacksizeFlag()) {
                object3.put("OMP_STACKSIZE", openMp.getOmpStacksize());
            }
            object2 = ((ProcessBuilder)object4).start();
            object = this.monitorProcess((Process)object2, FDSRunMonitor.newCommId(), "FDS", string5, FDSTextMonitor.class);
            this.d_fdsProcess = object2;
            this.d_kill.setEnabled(true);
            this.d_stop.setEnabled(true);
            int n2 = ((Process)object2).waitFor();
            this.d_kill.setEnabled(false);
            this.d_stop.setEnabled(false);
            FDSRunMonitor.setFDSRunning(this, false);
            this.stopMonitoring((MonitoredProcess)object);
            this.d_fdsProcess = null;
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run FDS."), Intl.intl("Error While Executing FDS"), 0);
            return -1;
        }
    }

    private int runClusterFDS(Map<String, Integer> map, String string, File file, SimParams.OpenMp openMp) {
        File file2 = new File(PyroPrefs.getMPIExecLocation());
        if (System.getProperties().containsKey("cluster_mpiexec")) {
            file2 = new File(System.getProperty("cluster_mpiexec"));
        }
        String string2 = PyroPrefs.getRunFDSLocation();
        if (file == null) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS File Specified"), 0);
            return -1;
        }
        int n = MpiUtil.testHydraServiceReady(this, file2);
        if (n != 0) {
            return -1;
        }
        if (!MpiUtil.mpiAuth(this, file2)) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cluster FDS was unable to start processes on this computer."), Intl.intl("MPI Error"), 0);
            return -1;
        }
        if (!file.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location for FDS_MPI has not yet been specified.  Please do so by") + nl + Intl.intl("going to \"File->Preferences.\""), Intl.intl("Invalid FDS_MPI File Specified"), 0);
            return -1;
        }
        if (!file2.exists()) {
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Cannot find program launcher (mpiexec.exe)."), Intl.intl("Error Launching FDS"), 0);
            return -1;
        }
        String string3 = this.d_datafile.getParent();
        if (System.getProperty("unc_disable") == null) {
            try {
                string3 = UncUtil.convertToUnc(string3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Unable to convert FDS file to UNC format."));
                return -1;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add(file2.getName());
        if (System.getProperties().containsKey("debugcluster")) {
            System.out.println("[debugcluster] Adding -v arg to mpiexec.");
            arrayList.add("-v");
        }
        if (System.getProperties().containsKey("cluster_delegate")) {
            System.out.println("[cluster_delegate] Adding -delegate arg to mpiexec.");
            arrayList.add("-delegate");
        }
        arrayList.add("-genvnone");
        arrayList.add("-gwdir");
        arrayList.add(string3);
        arrayList.add("-gpath");
        arrayList.add(file2.getParentFile().getPath());
        if (openMp.getOmpNumThreadsMPIFlag()) {
            arrayList.add("-genv");
            arrayList.add("OMP_NUM_THREADS");
            arrayList.add(openMp.getOmpNumThreadsMPI());
        }
        if (openMp.getOmpStacksizeFlag()) {
            arrayList.add("-genv");
            arrayList.add("OMP_STACKSIZE");
            arrayList.add(openMp.getOmpStacksize());
        }
        Set<String> set = map.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next();
            arrayList.add("-host");
            arrayList.add(string4);
            arrayList.add("-n");
            arrayList.add(map.get(string4).toString());
            arrayList.add(file.getName());
            arrayList.add(this.d_datafile.getName());
            if (!iterator.hasNext()) continue;
            arrayList.add(":");
        }
        try {
            File file3 = new File(file2.getParent());
            FDSRunMonitor.setFDSRunning(this, true);
            System.out.println("Command: " + String.join((CharSequence)" ", arrayList));
            System.out.println("CWD:     " + file3.getPath());
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            MpiUtil.scrubEnvMpi(processBuilder.environment());
            processBuilder.directory(file3);
            processBuilder.environment().put("PATH", ".");
            Process process = processBuilder.start();
            MonitoredProcess monitoredProcess = this.monitorProcess(process, FDSRunMonitor.newCommId(), "FDS", file.getName(), FDSTextMonitor.class);
            this.d_fdsProcess = process;
            this.d_kill.setEnabled(true);
            this.d_stop.setEnabled(true);
            int n2 = process.waitFor();
            this.d_kill.setEnabled(false);
            this.d_stop.setEnabled(false);
            FDSRunMonitor.setFDSRunning(this, false);
            this.stopMonitoring(monitoredProcess);
            this.d_fdsProcess = null;
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("An unknown error ocurred while attempting to run FDS."), Intl.intl("Error While Executing FDS"), 0);
            return -1;
        }
    }

    private MonitoredProcess monitorProcess(Process process, int n, String string, String string2, Class<? extends TextMonitor> clazz) {
        TextMonitor textMonitor;
        TextMonitor textMonitor2;
        Object object;
        try {
            object = clazz.getConstructor(FDSRunMonitor.class, InputStream.class, Color.class, Boolean.TYPE);
            boolean bl = this.d_process == null;
            textMonitor2 = (TextMonitor)((Constructor)object).newInstance(this, process.getInputStream(), Color.BLUE, bl);
            textMonitor = (TextMonitor)((Constructor)object).newInstance(this, process.getErrorStream(), Color.RED, bl);
            textMonitor2.startMonitoring();
            textMonitor.startMonitoring();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            assert (false);
            textMonitor = null;
            textMonitor2 = null;
        }
        object = new ProcessDestroyer(process);
        MonitoredProcess monitoredProcess = new MonitoredProcess(string2, process, n, textMonitor2, textMonitor, (Thread)object);
        this.d_monitoredProcesses.add(monitoredProcess);
        if (this.d_process == null) {
            this.print(nl + "Starting " + string + ": " + string2 + "..." + nl + "" + nl);
            this.d_process = monitoredProcess;
        }
        return monitoredProcess;
    }

    private static int newCommId() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public void killFDS() {
        if (this.d_fdsProcess == null) {
            return;
        }
        try {
            this.d_fdsProcess.getOutputStream().write(3);
            this.d_fdsProcess.getOutputStream().flush();
            this.d_fdsProcess.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private File getStopFile() {
        File file = this.d_datafile.getParentFile();
        String string = this.d_chid + ".stop";
        return new File(file, string);
    }

    public void gentleStop() {
        this.beginWaitCursor();
        try {
            final ProgressMonitor progressMonitor = new ProgressMonitor(this, "Stopping FDS Run", "", 0, 2);
            progressMonitor.setProgress(0);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            final SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() throws Exception {
                    FDSRunMonitor.this.getStopFile().createNewFile();
                    this.setProgress(1);
                    FDSRunMonitor.this.d_fdsProcess.waitFor();
                    this.setProgress(2);
                    return null;
                }

                @Override
                public void done() {
                    progressMonitor.setProgress(0);
                    progressMonitor.close();
                }
            };
            swingWorker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress" == propertyChangeEvent.getPropertyName()) {
                        if (progressMonitor.isCanceled()) {
                            swingWorker.cancel(true);
                            FDSRunMonitor.this.getStopFile().delete();
                        } else {
                            int n = (Integer)propertyChangeEvent.getNewValue();
                            progressMonitor.setProgress(n);
                        }
                    }
                }
            });
            swingWorker.execute();
        }
        catch (Exception exception) {
            this.endWaitCursor();
            return;
        }
        this.endWaitCursor();
    }

    @Override
    public void beginWaitCursor() {
        this.getRootPane().setEnabled(false);
        super.beginWaitCursor();
    }

    @Override
    public void endWaitCursor() {
        super.endWaitCursor();
        this.getRootPane().setEnabled(true);
    }

    private void stopMonitoring(MonitoredProcess monitoredProcess) {
        this.d_monitoredProcesses.remove(monitoredProcess);
        if (this.d_process == monitoredProcess) {
            this.d_process = null;
        }
        monitoredProcess.close();
    }

    public static boolean redirectStream(OutputStream outputStream, InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            PrintWriter printWriter = new PrintWriter(outputStream);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void print(String string) {
        this.d_textArea.append(string);
    }

    public void println(String string) {
        this.d_textArea.append(string);
        this.d_textArea.append(nl);
    }

    static {
        s_runningResultsMonitors = Collections.synchronizedMap(new HashMap());
        ClientListener clientListener = new ClientListener();
        s_commPort = clientListener.getCommPort();
        if (s_commPort != -1) {
            new Thread(clientListener).start();
        }
        nl = System.getProperty("line.separator");
    }

    private static enum ClientCommand {
        REFRESH(0),
        GET_PID(1),
        LOAD_RESULTS(2);

        public final int id;

        private ClientCommand(int n2) {
            this.id = n2;
        }
    }

    private static class ClientListener
    implements Runnable {
        private final int d_commPort;
        private final ServerSocket d_serverSkt;

        public ClientListener() {
            ServerSocket serverSocket = null;
            int n = -1;
            try {
                serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
                n = serverSocket.getLocalPort();
            }
            catch (IOException iOException) {
                System.err.println("[0x23489f] Failed creating a ServerSocket for results refreshing.");
                iOException.printStackTrace();
            }
            this.d_serverSkt = serverSocket;
            this.d_commPort = n;
        }

        public int getCommPort() {
            return this.d_commPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean connectToProcess(int n, Socket socket) throws Exception {
            Map map = s_runningResultsMonitors;
            synchronized (map) {
                for (FDSRunMonitor fDSRunMonitor : s_runningResultsMonitors.values()) {
                    Set set = fDSRunMonitor.d_monitoredProcesses;
                    synchronized (set) {
                        for (MonitoredProcess monitoredProcess : fDSRunMonitor.d_monitoredProcesses) {
                            if (monitoredProcess.commId != n || !monitoredProcess.connect(socket)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.d_serverSkt.accept();
                        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                        int n = dataInputStream.readInt();
                        this.connectToProcess(n, socket);
                    }
                }
                catch (Exception exception) {
                    System.err.println("[0x6723f] Failed trying to accept a results client. Trying again in 1 second.");
                    exception.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
    }

    private class ProcessDestroyer
    extends Thread {
        private final Process pid;

        public ProcessDestroyer(Process process) {
            this.pid = process;
        }

        @Override
        public void run() {
            FDSRunMonitor.this.killFDS();
            this.pid.destroy();
        }
    }

    public class TextMonitor
    extends Thread {
        private InputStream d_stream;
        private Color d_textColor;
        protected volatile boolean d_running = true;
        private boolean d_print;

        public TextMonitor(InputStream inputStream, Color color, boolean bl) {
            this.d_stream = inputStream;
            this.d_textColor = color;
            this.d_print = bl;
        }

        public void startMonitoring() {
            this.d_running = true;
            this.start();
        }

        public void stopMonitoring() {
        }

        public boolean isRunning() {
            return this.d_running;
        }

        protected void parseLine(String string) {
        }

        @Override
        public void run() {
            try {
                String string;
                InputStreamReader inputStreamReader = new InputStreamReader(this.d_stream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while (this.d_running && (string = bufferedReader.readLine()) != null) {
                    if (this.d_print) {
                        FDSRunMonitor.this.println(string);
                    }
                    this.parseLine(string);
                }
                if (this.d_print) {
                    FDSRunMonitor.this.print(nl);
                }
                this.d_running = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class FDSTextMonitor
    extends TextMonitor
    implements ActionListener {
        private long d_remainingTime;
        private int d_timeElapsed;
        private StringTokenizer d_token;
        private long d_startTime;
        private long d_checkTime;
        private long d_prevTime;
        private double d_requiredTotal;
        private double d_required;
        private double d_count;
        private double d_prevSimTime;
        private double d_currentSimTime;
        private double d_e;

        public FDSTextMonitor(InputStream inputStream, Color color, boolean bl) {
            super(inputStream, color, bl);
            this.d_prevTime = this.d_startTime = System.currentTimeMillis();
            this.d_requiredTotal = 0.0;
            this.d_count = 0.0;
            this.d_prevSimTime = 0.0;
            this.d_timeElapsed = 0;
            new Timer(1000, this).start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            long l;
            long l2;
            long l3;
            if (this.d_remainingTime >= 0L) {
                l3 = this.d_remainingTime--;
                l2 = l3 / 3600L;
                l3 -= l2 * 3600L;
                if ((l3 -= (l = l3 / 60L) * 60L) < 0L) {
                    l3 = 0L;
                }
                string = l2 + ":";
                string = l >= 10L ? string + l + ":" : string + "0" + l + ":";
                string = l3 >= 10L ? string + l3 : string + "0" + l3;
                FDSRunMonitor.this.d_ammtRemLbl.setText(string);
            }
            if (!FDSRunMonitor.this.d_endTime) {
                l3 = this.d_timeElapsed++;
                l2 = l3 / 3600L;
                l = (l3 -= l2 * 3600L) / 60L;
                string = l2 + ":";
                string = l >= 10L ? string + l + ":" : string + "0" + l + ":";
                string = l3 >= 10L ? string + l3 : string + "0" + (l3 -= l * 60L);
                FDSRunMonitor.this.d_ammtElapsedLbl.setText(string);
            }
        }

        @Override
        public void stopMonitoring() {
            this.d_running = false;
            FDSRunMonitor.this.d_endTime = true;
            this.d_remainingTime = 0L;
        }

        @Override
        protected void parseLine(String string) {
            this.d_token = new StringTokenizer(string, ",\t s:");
            if (this.d_token.hasMoreTokens()) {
                String string2 = this.d_token.nextToken();
                if (string2.equals("Time")) {
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    this.d_token.nextToken();
                    try {
                        this.d_checkTime = System.currentTimeMillis();
                        this.d_currentSimTime = new Double(this.d_token.nextToken()) * 1000.0;
                        long l = this.d_checkTime - this.d_prevTime;
                        double d = FDSRunMonitor.this.d_endSimTime - FDSRunMonitor.this.d_startSimTime;
                        FDSRunMonitor.this.d_ammtProgStr = this.d_currentSimTime / 1000.0 + "s / " + FDSRunMonitor.this.d_endSimTime / 1000.0 + "s";
                        FDSRunMonitor.this.d_ammtProgLbl.setText(FDSRunMonitor.this.d_ammtProgStr);
                        this.d_requiredTotal = this.d_required = (double)l * d / (this.d_currentSimTime - this.d_prevSimTime);
                        this.d_remainingTime = (long)((this.d_requiredTotal - (double)(this.d_checkTime - this.d_startTime)) / 1000.0);
                        this.d_prevSimTime = this.d_currentSimTime;
                        this.d_prevTime = this.d_checkTime;
                    }
                    catch (Exception exception) {
                        System.out.println("Line in incorrect format\n" + string);
                    }
                } else if (string2.equals("STOP")) {
                    FDSRunMonitor.this.d_endTime = true;
                }
            }
        }
    }

    private static class MonitoredProcess {
        public final String exePath;
        public final Process d_process;
        public final Thread destroyer;
        public final TextMonitor d_outputMonitor;
        public final TextMonitor d_errorMonitor;
        public final int commId;
        public Socket resultsSocket;
        public DataOutputStream out;
        public DataInputStream in;
        public List<Consumer<MonitoredProcess>> onConnect;

        public MonitoredProcess(String string, Process process, int n, TextMonitor textMonitor, TextMonitor textMonitor2, Thread thread) {
            this.exePath = string;
            this.d_process = process;
            this.d_outputMonitor = textMonitor;
            this.d_errorMonitor = textMonitor2;
            this.commId = n;
            this.destroyer = thread;
            this.onConnect = new ArrayList<Consumer<MonitoredProcess>>();
            Runtime.getRuntime().addShutdownHook(thread);
        }

        public synchronized boolean isConnected() {
            return this.resultsSocket != null;
        }

        public synchronized void onConnect(Consumer<MonitoredProcess> consumer) {
            if (this.resultsSocket != null) {
                consumer.accept(this);
            } else {
                this.onConnect.add(consumer);
            }
        }

        public synchronized boolean connect(Socket socket) {
            if (this.resultsSocket != null) {
                return false;
            }
            try {
                this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                this.in = new DataInputStream(socket.getInputStream());
                this.resultsSocket = socket;
                for (Consumer<MonitoredProcess> consumer : this.onConnect) {
                    consumer.accept(this);
                }
                this.onConnect.clear();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.out = null;
                this.in = null;
                return false;
            }
            return true;
        }

        public synchronized void close() {
            if (this.destroyer.getState() == Thread.State.NEW) {
                Runtime.getRuntime().removeShutdownHook(this.destroyer);
            }
            if (this.d_errorMonitor != null) {
                this.d_errorMonitor.stopMonitoring();
            }
            if (this.d_outputMonitor != null) {
                this.d_outputMonitor.stopMonitoring();
            }
            if (this.resultsSocket != null) {
                try {
                    this.resultsSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.resultsSocket = null;
                this.out = null;
                this.in = null;
            }
        }

        public synchronized void run(ClientCommand clientCommand) {
            if (this.resultsSocket == null) {
                return;
            }
            try {
                this.out.writeInt(clientCommand.id);
                this.out.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public synchronized void openFile(File file) {
            if (this.resultsSocket == null) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            try {
                this.out.writeInt(ClientCommand.LOAD_RESULTS.id);
                this.out.writeUTF(file.getPath());
                this.out.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public synchronized <T> T call(ClientCommand clientCommand, Class<T> clazz) {
            if (this.resultsSocket == null) {
                return null;
            }
            try {
                this.out.writeInt(clientCommand.id);
                this.out.flush();
                if (clazz.equals(Integer.class)) {
                    return (T)Integer.valueOf(this.in.readInt());
                }
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void allowSetForegroundWindow() {
            Integer n = this.call(ClientCommand.GET_PID, Integer.class);
            if (n != null) {
                Win32Native.allowSetForegroundWindow(n);
            }
        }
    }

    private class CustomTextArea
    extends JTextArea {
        private static final long serialVersionUID = 8424144956866515136L;
        private BufferedImage nistLogo;
        private final Composite alpha;

        public CustomTextArea() {
            try {
                this.nistLogo = ImageIO.read(ClassLoader.getSystemResource("pyrosim/icons/nist_logo.gif"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.alpha = AlphaComposite.getInstance(3, 0.1f);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.nistLogo == null) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            int n = 0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(this.alpha);
            for (int i = 0; i < rectangle.width; i += this.nistLogo.getWidth()) {
                while (n < rectangle.height) {
                    graphics.drawImage(this.nistLogo, i, n, this.nistLogo.getWidth(), this.nistLogo.getHeight(), this);
                    n += this.nistLogo.getHeight();
                }
                n = 0;
            }
            graphics2D.setComposite(composite);
        }
    }

    private class FlashyHeader
    extends JPanel {
        private static final long serialVersionUID = -4104573031898867922L;

        public FlashyHeader() {
            super(new GridBagLayout());
            ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/fds_dlg_logo.gif"));
            JLabel jLabel = new JLabel(imageIcon);
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            guiLabel guiLabel2 = new guiLabel("<html><b>Fire Dynamics Simulator (FDS)</b>");
            guiLabel guiLabel3 = new guiLabel("NIST Engineering Laboratory");
            guiLabel guiLabel4 = new guiLabel("National Institute of Standards and Technology (NIST)");
            GridBagUtil.add(this, jLabel, 0, 0, 1, 5, 0, 0, 0, 0);
            GridBagUtil.add(this, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0);
            GridBagUtil.add(this, guiLabel2, 1, 1, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, guiLabel3, 1, 2, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, guiLabel4, 1, 3, 1, 1, 0, 12, 0, 0);
            GridBagUtil.add(this, Box.createGlue(), 1, 4, 1, 1, 0, 0, 0, 0, 3, 0.0, 1.0);
        }
    }

    public static final class ResultsApp
    extends Enum<ResultsApp> {
        public static final /* enum */ ResultsApp SMOKEVIEW = new ResultsApp("Smokeview");
        public static final /* enum */ ResultsApp RESULTS = new ResultsApp("Results");
        public final String name;
        private static final /* synthetic */ ResultsApp[] $VALUES;

        public static ResultsApp[] values() {
            return (ResultsApp[])$VALUES.clone();
        }

        public static ResultsApp valueOf(String string) {
            return Enum.valueOf(ResultsApp.class, string);
        }

        private ResultsApp(String string2) {
            this.name = string2;
        }

        public String getExePath() {
            switch (this) {
                case SMOKEVIEW: {
                    return PyroPrefs.getSmokeviewLocation();
                }
                case RESULTS: {
                    return PyroPrefs.getResultsLocation();
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new ResultsApp[]{SMOKEVIEW, RESULTS};
        }
    }
}

