/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.DefaultFieldRenderer;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.IFDSFieldRenderer;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theUtil;

public class FDSRecordPreviewPanel
extends guiPanel {
    private static final long serialVersionUID = -5113367942772205385L;
    private FDSRenderer d_render;
    private FDSRenderProps d_renderProps;
    private String d_oldText;
    private JTextPane d_textPane;
    private boolean d_invalid;
    private Map<String, List<FDSRenderRecord>> d_prevRecs = null;
    public boolean d_renderDeps;
    private Predicate<FDSRenderRecord> d_recordFilter;

    public FDSRecordPreviewPanel(FDSRenderer fDSRenderer) {
        this(fDSRenderer, Filters.acceptAll());
    }

    public FDSRecordPreviewPanel(FDSRenderer fDSRenderer, Predicate<FDSRenderRecord> predicate) {
        super(new BorderLayout());
        this.d_recordFilter = predicate;
        this.d_render = fDSRenderer;
        this.d_renderProps = this.d_render.getProps();
        this.d_textPane = new JTextPane();
        this.d_textPane.setEditable(false);
        this.d_textPane.setFont(this.d_textPane.getFont().deriveFont(10.5f));
        JScrollPane jScrollPane = new JScrollPane(this.d_textPane);
        this.d_invalid = false;
        this.d_oldText = "";
        this.d_renderDeps = false;
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(new Dimension(10, 70));
        this.add((Component)jScrollPane, "Center");
    }

    public void setRecordFilter(Predicate<FDSRenderRecord> predicate) {
        this.d_recordFilter = predicate;
    }

    public void setRenderDeps(boolean bl) {
        this.d_renderDeps = bl;
    }

    public void setRecord(IPyroObject iPyroObject, boolean bl) {
        List<IPyroObject> list = iPyroObject == null ? Collections.EMPTY_LIST : Arrays.asList(iPyroObject);
        this.setRecord((Collection<? extends IPyroObject>)list, bl);
    }

    public void setRecord(Collection<? extends IPyroObject> collection, boolean bl) {
        StyledDocument styledDocument = (StyledDocument)this.d_textPane.getEditorKit().createDefaultDocument();
        Style style = styledDocument.addStyle("diff_style", null);
        StyleConstants.setBackground(style, new Color(240, 216, 168));
        if (collection != null) {
            Object object;
            Object object2;
            PrintWriter printWriter = new PrintWriter(new DocWriter(styledDocument));
            FDSRecordCollector fDSRecordCollector = new FDSRecordCollector(this.d_renderProps);
            this.d_render.renderObjects(fDSRecordCollector, collection, Collections.EMPTY_MAP);
            List list2 = this.d_renderDeps ? fDSRecordCollector.getRecords().stream().filter(this.d_recordFilter).collect(Collectors.toList()) : fDSRecordCollector.getRecordMap().entrySet().stream().filter(entry -> collection.contains(entry.getKey()) || entry.getKey() == null).map(Map.Entry::getValue).flatMap(list -> list.stream()).filter(this.d_recordFilter).collect(Collectors.toList());
            HashMap<String, List<FDSRenderRecord>> hashMap = new HashMap<String, List<FDSRenderRecord>>();
            for (Iterator iterator : list2) {
                List entry2 = hashMap.computeIfAbsent(((FDSRecord)((Object)iterator)).getType(), string -> new ArrayList());
                entry2.add(iterator);
            }
            LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
            if (bl && this.d_prevRecs != null) {
                for (Map.Entry entry2 : hashMap.entrySet()) {
                    if (((List)entry2.getValue()).size() != 1 || (object2 = this.d_prevRecs.get(entry2.getKey())) == null || object2.size() != 1) continue;
                    object = (FDSRenderRecord)((List)entry2.getValue()).get(0);
                    FDSRenderRecord fDSRenderRecord = (FDSRenderRecord)object2.get(0);
                    FDSRecord.DiffResult diffResult = fDSRenderRecord.diff((FDSRecord)object);
                    HashSet<String> hashSet = new HashSet<String>(diffResult.additional);
                    hashSet.addAll(diffResult.different);
                    linkedIdentityHashMap.put(object, new FieldRenderer(styledDocument, hashSet));
                }
            }
            this.d_prevRecs = hashMap;
            for (FDSRenderRecord fDSRenderRecord : list2) {
                this.d_renderProps.pushProps();
                this.d_renderProps.setRenderMultiLine(false);
                fDSRenderRecord.renderRecord(printWriter, this.d_renderProps, linkedIdentityHashMap.getOrDefault(fDSRenderRecord, DefaultFieldRenderer.INSTANCE));
                this.d_renderProps.popProps();
            }
            try {
                Iterator iterator;
                iterator = styledDocument.getText(0, styledDocument.getLength());
                if (((String)((Object)iterator)).equals(this.d_oldText)) {
                    return;
                }
                this.d_oldText = iterator;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.d_textPane.setDocument(styledDocument);
            for (FieldRenderer fieldRenderer : theUtil.filter(linkedIdentityHashMap.values(), FieldRenderer.class)) {
                object2 = fieldRenderer.d_changeIxes.values().iterator();
                while (object2.hasNext()) {
                    object = (int[])object2.next();
                    if (object == null) continue;
                    this.d_textPane.setCaretPosition((int)object[0]);
                    this.d_textPane.moveCaretPosition((int)object[1]);
                    this.d_textPane.setCharacterAttributes(style, true);
                }
            }
            this.d_textPane.setCaretPosition(0);
        } else {
            this.d_textPane.setDocument(styledDocument);
        }
    }

    private static class DocWriter
    extends Writer {
        private final Document d_doc;

        public DocWriter(Document document) {
            this.d_doc = document;
        }

        public int size() {
            return this.d_doc.getLength();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            try {
                this.d_doc.insertString(this.d_doc.getLength(), new String(cArray, n, n2), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class FieldRenderer
    implements IFDSFieldRenderer {
        private final Document d_doc;
        private Map<String, int[]> d_changeIxes;

        public FieldRenderer(Document document, Set<String> set) {
            this.d_doc = document;
            this.d_changeIxes = new HashMap<String, int[]>(set.size());
            for (String string : set) {
                this.d_changeIxes.put(string, null);
            }
        }

        @Override
        public void render(PrintWriter printWriter, String string, String string2) {
            int n = this.d_doc.getLength();
            printWriter.append(string2);
            int n2 = this.d_doc.getLength();
            if (this.d_changeIxes.containsKey(string)) {
                this.d_changeIxes.put(string, new int[]{n, n2});
            }
        }
    }
}

