/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ExSpecEditor;
import pyrosim.gui.ExSpecNewDlg;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.util.Util;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.Task;

public class ExSpecManagerDlg
extends ManagerDlg<ExSpec, ExSpecList> {
    private static final long serialVersionUID = 7991146854485689613L;
    private final IEditor d_editor = new ExSpecEditor(this);
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, ExSpec.class), new RenameAction<ExSpec, ExSpecList>(this, Intl.intl("extra species")), new ManagerDlg.DeleteAction(this)};
    private ExSpecList d_mgr;

    public ExSpecManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Edit Species"), true);
        this.setRenderer(new ExSpecListCellRen());
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(ExSpecList exSpecList, ExSpec exSpec) {
        this.d_mgr = exSpecList;
        ((RenameAction)this.d_actions[2]).init(exSpecList);
        super.init(this.d_mgr, this.d_editor, this.d_actions, exSpec);
        this.updateActions();
    }

    private class ExSpecListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4749567436250904536L;
        private Font d_italic = new Font("SansSerif", 2, 11);
        private Font d_plain = new Font("SansSerif", 0, 11);
        private Font d_bold = new Font("SansSerif", 1, 11);
        private Font d_boldItalic = new Font("SansSerif", 3, 11);

        private ExSpecListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3;
            Component component = super.getListCellRendererComponent((JList<?>)jList, Util.getName((ExSpec)object), n, bl, bl2);
            component.setEnabled(((ExSpec)object).isEnabled());
            boolean bl4 = bl3 = ((ExSpec)object).getType() == 0;
            if (n == ExSpecManagerDlg.this.d_edix && ExSpecManagerDlg.this.d_editor.isModified()) {
                if (bl3) {
                    component.setFont(this.d_boldItalic);
                } else {
                    component.setFont(this.d_italic);
                }
            } else if (bl3) {
                component.setFont(this.d_bold);
            } else {
                component.setFont(this.d_plain);
            }
            return component;
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -1252470174172443054L;

        public NewAction() {
            super(Intl.intl("New"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExSpec exSpec;
            Object object;
            if (!ExSpecManagerDlg.this.preSave()) {
                return;
            }
            PyroMod pyroMod = (PyroMod)ExSpecManagerDlg.this.d_mgr.getDomain();
            ExSpecNewDlg exSpecNewDlg = new ExSpecNewDlg(ExSpecManagerDlg.this, (PyroMod)ExSpecManagerDlg.this.d_mgr.getDomain());
            if (exSpecNewDlg.doModal() != 1) {
                return;
            }
            if (exSpecNewDlg.isPredefined()) {
                object = exSpecNewDlg.getSpeciesPredef();
                exSpec = new ExSpec(ExSpecList.PREDEFINED.get(object));
                assert (exSpec != null);
            } else if (exSpecNewDlg.isCustom()) {
                exSpec = exSpecNewDlg.isPrimitive() ? new ExSpec(exSpecNewDlg.getSpeciesCustom(), 1) : new ExSpec(exSpecNewDlg.getSpeciesCustom(), 2);
            } else {
                exSpec = null;
                assert (false);
            }
            object = new AddTask((IPyroObject)ExSpecManagerDlg.this.d_mgr, new IPyroObject[]{exSpec});
            SelectTask selectTask = new SelectTask(pyroMod, exSpec);
            selectTask.addTask((Task)object);
            pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Extra Species"));
            ExSpecManagerDlg.this.getList().updateModelView(ExSpecManagerDlg.this.d_mgr);
            ExSpecManagerDlg.this.getList().select(exSpec);
            ExSpecManagerDlg.this.d_editor.getEditorPanel().setModified(false);
            ExSpecManagerDlg.this.updateActions();
        }
    }
}

