/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.VariantEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.theUtil;

public class ExSpecEditor
extends guiPanel
implements IEditor<ExSpec> {
    private static final long serialVersionUID = -412288340484103187L;
    private ExSpecList d_exSpecList;
    private guiDialog d_parent;
    private guiTextField d_ID;
    private guiTextField d_FYI;
    private ValueField<Double> d_massFrac;
    private PrimitivePanel d_primitivePanel;
    private LumpedPanel d_lumpedPanel;
    private CustomFDSPanel d_advancedPanel;
    private VisDifPanel d_visDifPanel;
    private RadiationPanel d_radiationPanel;
    private DepositionPanel d_depositionPanel;
    private LiquidPanel d_liquidPanel;
    private GasPanel d_gasPanel;
    private JTabbedPane d_tabs;
    private static String CONST = Intl.intl("Constant");
    private static String RAMP = Intl.intl("Custom");

    public ExSpecEditor(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_exSpecList = pyroMod.getExSpecList();
        this.d_parent = guiDialog2;
        this.setLayout(new GridBagLayout());
        this.d_primitivePanel = new PrimitivePanel();
        this.d_lumpedPanel = new LumpedPanel(this.d_exSpecList);
        this.d_advancedPanel = new CustomFDSPanel(7);
        this.d_visDifPanel = new VisDifPanel();
        this.d_radiationPanel = new RadiationPanel();
        this.d_depositionPanel = new DepositionPanel();
        this.d_liquidPanel = new LiquidPanel();
        this.d_gasPanel = new GasPanel();
        HTMLLabel hTMLLabel = new HTMLLabel(Intl.intl("Species ID") + ":");
        hTMLLabel.setToolTipText("ID");
        this.d_ID = new guiTextField();
        this.d_ID.setEnabled(false);
        HTMLLabel hTMLLabel2 = new HTMLLabel(Intl.intl("Description") + ":");
        hTMLLabel2.setToolTipText("FYI");
        this.d_FYI = new guiTextField();
        HTMLLabel hTMLLabel3 = new HTMLLabel(Intl.intl("Initial Mass Fraction") + ":");
        hTMLLabel3.setToolTipText("MASS_FRACTION_O");
        this.d_massFrac = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_primitivePanel, this.d_lumpedPanel, this.d_advancedPanel, this.d_visDifPanel, this.d_radiationPanel, this.d_depositionPanel, this.d_liquidPanel, this.d_gasPanel));
        int n = 0;
        GridBagUtil.add(this, hTMLLabel, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_ID, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, hTMLLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_FYI, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, hTMLLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_massFrac, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_tabs, 0, n, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        guiLabel guiLabel2;
        int n;
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        return !bl || !theUtil.equal(ExSpecList.Predefined.AIR.getName(), this.d_ID.getValue()) || (Double)this.d_massFrac.getValue() == 0.0 || (n = JOptionPane.showConfirmDialog(this, guiLabel2 = new guiLabel(PyroGuiUtil.encodeToHtmlLabel(Intl.intl("AIR is usually the background species and should be set to 0. It will\nautomatically account for any unspecified mass fraction. If you have\ndefined a custom background species other than AIR, click OK to ignore\nthis warning."))), Intl.intl("Warning"), 2, 2)) == 0;
    }

    @Override
    public ExSpec preview(ExSpec exSpec) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(exSpec);
        return exSpec;
    }

    @Override
    public ExSpec commit(final ExSpec exSpec) {
        assert (exSpec != null);
        assert (this.isModified());
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                ExSpecEditor.this.save(exSpec);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Species"));
        this.setModified(false);
        return exSpec;
    }

    protected void save(ExSpec exSpec) {
        exSpec.setFYI(this.d_FYI.getText());
        exSpec.setMassFrac0((Double)this.d_massFrac.getValue());
        this.d_primitivePanel.saveData(exSpec);
        if (this.d_visDifPanel.isModified()) {
            this.d_visDifPanel.saveData(exSpec.getPrimParams());
        }
        if (this.d_radiationPanel.isModified()) {
            this.d_radiationPanel.saveData(exSpec.getPrimParams());
        }
        if (this.d_depositionPanel.isModified()) {
            this.d_depositionPanel.saveData(exSpec.getPrimParams());
        }
        if (this.d_gasPanel.isModified()) {
            this.d_gasPanel.saveData(exSpec.getPrimParams());
        }
        if (this.d_liquidPanel.isModified()) {
            this.d_liquidPanel.saveData(exSpec.getPrimParams());
        }
        if (this.d_lumpedPanel.isModified()) {
            this.d_lumpedPanel.saveData(exSpec);
        }
        this.d_advancedPanel.save(Collections.singleton(exSpec));
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    public guiPanel getEmptyPanel() {
        return new guiPanel();
    }

    public guiPanel getPrimitivePanel() {
        return this.d_primitivePanel;
    }

    public guiPanel getLumpedPanel() {
        return this.d_lumpedPanel;
    }

    public guiPanel getAdvancedPanel() {
        return this.d_advancedPanel;
    }

    private static void setEnabled(boolean bl, JComponent ... jComponentArray) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setEnabled(bl);
        }
    }

    private void setEditable(boolean bl, JTextField ... jTextFieldArray) {
        for (JTextField jTextField : jTextFieldArray) {
            jTextField.setEditable(bl);
        }
    }

    @Override
    public void init(ExSpec exSpec) {
        this.setEnabled(exSpec != null);
        this.setModified(false);
        if (exSpec == null) {
            return;
        }
        this.d_ID.setValue(exSpec.getName());
        this.d_FYI.setValue(exSpec.getFYI());
        this.d_FYI.setEnabled(true);
        this.d_massFrac.setValue(exSpec.getMassFrac0());
        this.d_massFrac.setEnabled(true);
        this.d_tabs.removeAll();
        this.clearPanels();
        this.d_ID.setEnabled(false);
        if (exSpec.getType() == 1) {
            this.d_tabs.addTab(Intl.intl("Primitive"), this.d_primitivePanel);
            this.d_primitivePanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Vis/Dif"), this.d_visDifPanel);
            this.d_visDifPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Radiation"), this.d_radiationPanel);
            this.d_radiationPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Soot"), this.d_depositionPanel);
            this.d_depositionPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Liquid"), this.d_liquidPanel);
            this.d_liquidPanel.init(exSpec);
            this.d_tabs.addTab(Intl.intl("Gas"), this.d_gasPanel);
            this.d_gasPanel.init(exSpec);
        } else if (exSpec.getType() == 0) {
            this.d_tabs.addTab(Intl.intl("Primitive"), this.d_primitivePanel);
            this.d_primitivePanel.init(exSpec);
        } else if (exSpec.getType() == 2 || exSpec.getType() == 3) {
            this.d_tabs.addTab(Intl.intl("Lumped"), this.d_lumpedPanel);
            this.d_lumpedPanel.init(exSpec);
        } else if (exSpec.getType() == 4) {
            this.d_tabs.addTab(Intl.intl("Reaction Fuel"), new guiPanel());
            this.d_FYI.setEnabled(false);
            this.d_massFrac.setEnabled(false);
        }
        if (exSpec.getType() != 4) {
            this.d_advancedPanel.load(Collections.singleton(exSpec), new CustomFDSPanel.AdvPropWrapper<Boolean>(exSpec.isForceWrite(), 1));
            this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
        }
    }

    public void clearPanels() {
        this.d_primitivePanel.init(null);
        this.d_lumpedPanel.init(null);
        this.d_visDifPanel.init(null);
        this.d_radiationPanel.init(null);
        this.d_depositionPanel.init(null);
        this.d_liquidPanel.init(null);
        this.d_gasPanel.init(null);
        this.d_advancedPanel.clear();
    }

    private class LiquidPanel
    extends guiPanel {
        private static final long serialVersionUID = 451490820008081996L;
        private VariantEditor d_specHeatLiquid = new VariantEditor(Intl.intl("Specific Heat"), ExSpec.SPECHEAT_PROFILE, false);
        private ValueField<UnitDouble> d_density = ValueFields.udFld(UnitSystem.getSource(4));
        private ValueField<UnitDouble> d_vapTemp;
        private ValueField<UnitDouble> d_meltTemp;
        private ValueField<UnitDouble> d_HoV;
        private ValueField<UnitDouble> d_EoF;
        private ValueField<UnitDouble> d_HVRefTemp;
        private guiCheckBox d_densitySet = new guiCheckBox(Intl.intl("Density:"));
        private guiCheckBox d_vapTempSet;
        private guiCheckBox d_meltTempSet;
        private guiCheckBox d_HoVSet;
        private guiCheckBox d_EoFSet;
        private guiCheckBox d_HVRefTempSet;

        public LiquidPanel() {
            this.d_densitySet.setToolTipText("DENSITY_LIQUID");
            LinkStatus.link((AbstractButton)this.d_densitySet, this.d_density);
            this.d_vapTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_vapTempSet = new guiCheckBox(Intl.intl("Vaporization Temperature:"));
            this.d_vapTempSet.setToolTipText("VAPORIZATION_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_vapTempSet, this.d_vapTemp);
            this.d_meltTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_meltTempSet = new guiCheckBox(Intl.intl("Melting Temperature:"));
            this.d_meltTempSet.setToolTipText("MELTING_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_meltTempSet, this.d_meltTemp);
            this.d_HoV = ValueFields.udFld(UnitSystem.getSource(46));
            this.d_HoVSet = new guiCheckBox(Intl.intl("Heat of Vaporization:"));
            this.d_HoVSet.setToolTipText("HEAT_OF_VAPORIZATION");
            LinkStatus.link((AbstractButton)this.d_HoVSet, this.d_HoV);
            this.d_EoF = ValueFields.udFld(UnitSystem.getSource(86));
            this.d_EoFSet = new guiCheckBox(Intl.intl("Enthalpy of Formation:"));
            this.d_EoFSet.setToolTipText("ENTHALPY_OF_FORMATION");
            LinkStatus.link((AbstractButton)this.d_EoFSet, this.d_EoF);
            this.d_HVRefTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_HVRefTempSet = new guiCheckBox(Intl.intl("H-V Reference Temperature:"));
            this.d_HVRefTempSet.setToolTipText("H_V_REFERENCE_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_HVRefTempSet, this.d_HVRefTemp);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_specHeatLiquid.getVisLabel(), this.d_specHeatLiquid.getCombo(), this.d_specHeatLiquid.getEditor());
            gridBagHelper.addRow(this.d_densitySet, null, this.d_density);
            gridBagHelper.addRow(this.d_vapTempSet, null, this.d_vapTemp);
            gridBagHelper.addRow(this.d_meltTempSet, null, this.d_meltTemp);
            gridBagHelper.addRow(this.d_HoVSet, null, this.d_HoV);
            gridBagHelper.addRow(this.d_EoFSet, null, this.d_EoF);
            gridBagHelper.addRow(this.d_HVRefTempSet, null, this.d_HVRefTemp);
            gridBagHelper.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            this.d_specHeatLiquid.init(primitiveParams.getSpecHeatLiquid());
            if (primitiveParams.getDensityLiquid().isConstant()) {
                this.d_density.setValue((UnitDouble)primitiveParams.getDensityLiquid().val);
            }
            this.d_densitySet.setSelected(primitiveParams.isDensityLiquidSet());
            if (primitiveParams.getVapTemp().isConstant()) {
                this.d_vapTemp.setValue((UnitDouble)primitiveParams.getVapTemp().val);
            }
            this.d_vapTempSet.setSelected(primitiveParams.isVapTempSet());
            if (primitiveParams.getMeltTemp().isConstant()) {
                this.d_meltTemp.setValue((UnitDouble)primitiveParams.getMeltTemp().val);
            }
            this.d_meltTempSet.setSelected(primitiveParams.isMeltingTempSet());
            if (primitiveParams.getHoVaporization().isConstant()) {
                this.d_HoV.setValue((UnitDouble)primitiveParams.getHoVaporization().val);
            }
            this.d_HoVSet.setSelected(primitiveParams.isHoVaporizationSet());
            if (primitiveParams.getEoFormation().isConstant()) {
                this.d_EoF.setValue((UnitDouble)primitiveParams.getEoFormation().val);
            }
            this.d_EoFSet.setSelected(primitiveParams.isEoFormationSet());
            if (primitiveParams.getHVRefTemp().isConstant()) {
                this.d_HVRefTemp.setValue((UnitDouble)primitiveParams.getHVRefTemp().val);
            }
            this.d_HVRefTempSet.setSelected(primitiveParams.isHVRefTempSet());
            this.setModified(false);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_specHeatLiquid.validateData(bl, bl2);
        }

        public void saveData(ExSpec.PrimitiveParams primitiveParams) {
            primitiveParams.setSpecHeatLiquid(this.d_specHeatLiquid.getValue());
            if (this.d_densitySet.isSelected()) {
                primitiveParams.setDensityLiquid((UnitDouble)this.d_density.getValue());
            } else {
                primitiveParams.setDensityLiquid(null);
            }
            if (this.d_vapTempSet.isSelected()) {
                primitiveParams.setVapTemp((UnitDouble)this.d_vapTemp.getValue());
            } else {
                primitiveParams.setVapTemp(null);
            }
            if (this.d_meltTempSet.isSelected()) {
                primitiveParams.setMeltingTemp((UnitDouble)this.d_meltTemp.getValue());
            } else {
                primitiveParams.setMeltingTemp(null);
            }
            if (this.d_HoVSet.isSelected()) {
                primitiveParams.setHoVaporization((UnitDouble)this.d_HoV.getValue());
            } else {
                primitiveParams.setHoVaporization(null);
            }
            if (this.d_EoFSet.isSelected()) {
                primitiveParams.setEoFormation((UnitDouble)this.d_EoF.getValue());
            } else {
                primitiveParams.setEoFormation(null);
            }
            if (this.d_HVRefTempSet.isSelected()) {
                primitiveParams.setHVRefTemp((UnitDouble)this.d_HVRefTemp.getValue());
            } else {
                primitiveParams.setHVRefTemp(null);
            }
        }
    }

    private class GasPanel
    extends guiPanel {
        private static final long serialVersionUID = 4588646765321711448L;
        private VariantEditor d_specHeat = new VariantEditor(Intl.intl("Specific Heat"), ExSpec.SPECHEAT_PROFILE, false);
        private ValueField<UnitDouble> d_referenceTemperature = ValueFields.udFld(UnitSystem.getSource(1));
        private ValueField<UnitDouble> d_referenceEnthalpy;
        private guiCheckBox d_refTempSet = new guiCheckBox(Intl.intl("Reference Temperature:"));
        private guiCheckBox d_refEnthalpySet;

        public GasPanel() {
            this.d_refTempSet.setToolTipText("REFERENCE_TEMPERATURE");
            LinkStatus.link((AbstractButton)this.d_refTempSet, this.d_referenceTemperature);
            this.d_referenceEnthalpy = ValueFields.udFld(UnitSystem.getSource(65));
            this.d_refEnthalpySet = new guiCheckBox(Intl.intl("Reference Enthalpy:"));
            this.d_refEnthalpySet.setToolTipText("REFERENCE_ENTHALPY");
            LinkStatus.link((AbstractButton)this.d_refEnthalpySet, this.d_referenceEnthalpy);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_specHeat.getVisLabel(), this.d_specHeat.getCombo(), this.d_specHeat.getEditor());
            gridBagHelper.addRow(this.d_refTempSet, null, this.d_referenceTemperature);
            gridBagHelper.addRow(this.d_refEnthalpySet, null, this.d_referenceEnthalpy);
            gridBagHelper.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            this.d_specHeat.init(primitiveParams.getSpecHeat());
            this.d_referenceTemperature.setValue(primitiveParams.getRefTemp());
            this.d_refTempSet.setSelected(primitiveParams.isRefTempSet());
            if (primitiveParams.getRefEnthalpy().isConstant()) {
                this.d_referenceEnthalpy.setValue((UnitDouble)primitiveParams.getRefEnthalpy().val);
            }
            this.d_refEnthalpySet.setSelected(primitiveParams.isRefEnthalpySet());
            this.setModified(false);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_specHeat.validateData(bl, bl2);
        }

        public void saveData(ExSpec.PrimitiveParams primitiveParams) {
            primitiveParams.setSpecHeat(this.d_specHeat.getValue());
            primitiveParams.setRefTemp((UnitDouble)this.d_referenceTemperature.getValue(), this.d_refTempSet.isSelected());
            if (this.d_refEnthalpySet.isSelected()) {
                primitiveParams.setRefEnthalpy((UnitDouble)this.d_referenceEnthalpy.getValue());
            } else {
                primitiveParams.setRefEnthalpy(null);
            }
        }
    }

    private class DepositionPanel
    extends guiPanel {
        private static final long serialVersionUID = 3948098942033021371L;
        private guiCheckBox d_cbAerosol;
        private ValueField<UnitDouble> d_density;
        private ValueField<UnitDouble> d_conductivity;
        private ValueField<UnitDouble> d_diameter;

        public DepositionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cbAerosol = new guiCheckBox(Intl.intl("Aerosol"));
            this.d_cbAerosol.setToolTipText("AEROSOL");
            HTMLLabel hTMLLabel = new HTMLLabel(Intl.intl("Density (Solid):"));
            hTMLLabel.setToolTipText("DENSITY_SOLID");
            HTMLLabel hTMLLabel2 = new HTMLLabel(Intl.intl("Conductivity (Solid):"));
            hTMLLabel2.setToolTipText("CONDUCTIVITY_SOLID");
            HTMLLabel hTMLLabel3 = new HTMLLabel(Intl.intl("Mean Diameter:"));
            hTMLLabel3.setToolTipText("MEAN_DIAMETER");
            this.d_density = ValueFields.udFld(UnitSystem.getSource(4));
            this.d_conductivity = ValueFields.udFld(UnitSystem.getSource(19));
            this.d_diameter = ValueFields.udFld(UnitSystem.getSource(0));
            LinkStatus.link((AbstractButton)this.d_cbAerosol, this.d_density, this.d_conductivity, this.d_diameter);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_cbAerosol);
            gridBagHelper.addIdentRow(hTMLLabel, this.d_density);
            gridBagHelper.addIdentRow(hTMLLabel2, this.d_conductivity);
            gridBagHelper.addIdentRow(hTMLLabel3, this.d_diameter);
            gridBagHelper.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            if (primitiveParams.isAerosol()) {
                this.d_cbAerosol.setSelected(true);
            }
            this.d_density.setValue(primitiveParams.getDensitySolid());
            this.d_conductivity.setValue(primitiveParams.getConductivitySolid());
            this.d_diameter.setValue(primitiveParams.getMeanDiameter());
            this.setModified(false);
        }

        public void saveData(ExSpec.PrimitiveParams primitiveParams) {
            primitiveParams.setAerosol(this.d_cbAerosol.isSelected());
            if (primitiveParams.isAerosol()) {
                primitiveParams.setDensitySolid((UnitDouble)this.d_density.getValue());
                primitiveParams.setConductivitySolid((UnitDouble)this.d_conductivity.getValue());
                primitiveParams.setMeanDiameter((UnitDouble)this.d_diameter.getValue());
            }
        }
    }

    private class RadiationPanel
    extends guiPanel {
        private static final long serialVersionUID = -7784499667585708166L;
        private guiCheckBox d_cbRadCal;
        private guiComboBox d_surrogateCombo;

        public RadiationPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cbRadCal = new guiCheckBox(Intl.intl("RadCal Surrogate:"));
            this.d_surrogateCombo = new guiComboBox<String>((T[])ExSpecList.getRadCalSurrogates());
            this.d_surrogateCombo.setToolTipText("RADCAL_ID");
            LinkStatus.link((AbstractButton)this.d_cbRadCal, this.d_surrogateCombo);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_cbRadCal, this.d_surrogateCombo);
            gridBagHelper.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            if (primitiveParams.getRadCalSurrogate().length() > 0) {
                this.d_surrogateCombo.setSelectedItem(primitiveParams.getRadCalSurrogate());
                this.d_cbRadCal.setSelected(true);
            } else {
                this.d_cbRadCal.setSelected(false);
                this.d_surrogateCombo.setSelectedItem("METHANE");
            }
            this.setModified(false);
        }

        public void saveData(ExSpec.PrimitiveParams primitiveParams) {
            if (this.d_cbRadCal.isSelected()) {
                primitiveParams.setRadCalSurrogate((String)this.d_surrogateCombo.getSelectedItem());
            } else {
                primitiveParams.setRadCalSurrogate("");
            }
        }
    }

    private class VisDifPanel
    extends guiPanel {
        private static final long serialVersionUID = -2292736655909204022L;
        private VariantEditor d_diffEditor;
        private VariantEditor d_viscEditor;
        private ValueField<Double> d_sigma;
        private ValueField<Double> d_epsilonK;
        private guiCheckBox d_sigmaSet;
        private guiCheckBox d_epsilonSet;

        public VisDifPanel() {
            this.setLayout(new GridBagLayout());
            this.d_diffEditor = new VariantEditor(Intl.intl("Diffusivity"), ExSpec.DIFFUSIVITY_PROFILE, false);
            this.d_viscEditor = new VariantEditor(Intl.intl("Viscosity"), ExSpec.VISCOSITY_PROFILE, false);
            this.d_sigmaSet = new guiCheckBox(Intl.intl("<html>&#963;:"));
            this.d_sigmaSet.setToolTipText("SIGMALJ");
            this.d_sigma = ValueFields.doubleFld();
            LinkStatus.link((AbstractButton)this.d_sigmaSet, this.d_sigma);
            this.d_epsilonSet = new guiCheckBox(Intl.intl("<html>&#949;/&#954;:"));
            this.d_epsilonSet.setToolTipText("EPSILONKLJ");
            this.d_epsilonK = ValueFields.doubleFld();
            LinkStatus.link((AbstractButton)this.d_epsilonSet, this.d_epsilonK);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_diffEditor.getVisLabel(), this.d_diffEditor.getCombo(), this.d_diffEditor.getEditor());
            gridBagHelper.addRow(this.d_viscEditor.getVisLabel(), this.d_viscEditor.getCombo(), this.d_viscEditor.getEditor());
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Leonard-Jones Parameters")));
            gridBagHelper.addRow(this.d_sigmaSet, this.d_sigma);
            gridBagHelper.addRow(this.d_epsilonSet, this.d_epsilonK);
            gridBagHelper.finalizeRows();
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            this.d_diffEditor.init(primitiveParams.getDiffusivity());
            this.d_viscEditor.init(primitiveParams.getViscosity());
            this.d_sigma.setValue(primitiveParams.getSigmaLJ());
            this.d_sigmaSet.setSelected(primitiveParams.isSigmaLJSet());
            this.d_epsilonK.setValue(primitiveParams.getEpsilonKLJ());
            this.d_epsilonSet.setSelected(primitiveParams.isEpsilonKLJSet());
            this.setModified(false);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            return super.validateData(bl, bl2) && this.d_diffEditor.validateData(bl, bl2) && this.d_viscEditor.validateData(bl, bl2);
        }

        public void saveData(ExSpec.PrimitiveParams primitiveParams) {
            primitiveParams.setDiffusivity(this.d_diffEditor.getValue());
            primitiveParams.setViscosity(this.d_viscEditor.getValue());
            primitiveParams.setSigmaLJ((Double)this.d_sigma.getValue(), this.d_sigmaSet.isSelected());
            primitiveParams.setEpsilonKLJ((Double)this.d_epsilonK.getValue(), this.d_epsilonSet.isSelected());
        }
    }

    private class PrimitivePanel
    extends guiPanel {
        private static final long serialVersionUID = -5637863651944340892L;
        private final ValueField<UnitDouble> d_molecularWeight;
        private final guiTextField d_formula;
        private final guiRadioButton d_rbMolecularWeight;
        private final guiRadioButton d_rbFormula;
        private final guiComboBox<ExSpec.LUMPED_RULE> d_lumpedOnlyCB;

        public PrimitivePanel() {
            this.setLayout(new GridBagLayout());
            this.d_rbMolecularWeight = new guiRadioButton(Intl.intl("Molecular Weight:"));
            this.d_rbMolecularWeight.setToolTipText("MW");
            this.d_rbFormula = new guiRadioButton(Intl.intl("Chemical Formula:"));
            this.d_rbFormula.setToolTipText("FORMULA");
            this.d_molecularWeight = ValueFields.udFld(UnitSystem.getSource(17));
            this.d_formula = new guiTextField("");
            this.d_lumpedOnlyCB = new guiComboBox<ExSpec.LUMPED_RULE>((Collection<ExSpec.LUMPED_RULE>)Arrays.asList(ExSpec.LUMPED_RULE.values()));
            this.d_lumpedOnlyCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof ExSpec.LUMPED_RULE) {
                        this.setText(((ExSpec.LUMPED_RULE)((Object)object)).id);
                    }
                    return this;
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_rbMolecularWeight);
            buttonGroup.add(this.d_rbFormula);
            LinkStatus.link((AbstractButton)this.d_rbMolecularWeight, this.d_molecularWeight);
            LinkStatus.link((AbstractButton)this.d_rbFormula, this.d_formula);
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(this.d_rbMolecularWeight, this.d_molecularWeight);
            gridBagHelper.addRow(this.d_rbFormula, this.d_formula);
            gridBagHelper.addRow(Intl.intl("Lumped Component Only:"), this.d_lumpedOnlyCB);
            gridBagHelper.indent();
            gridBagHelper.finalizeRows();
        }

        public void saveData(ExSpec exSpec) {
            if (this.d_rbMolecularWeight.isSelected()) {
                exSpec.setMolecularWeight((UnitDouble)this.d_molecularWeight.getValue());
            } else if (this.d_rbFormula.isSelected()) {
                exSpec.setChemFormula(this.d_formula.getText());
            }
            exSpec.setLumpedComponentOnlyRule(this.d_lumpedOnlyCB.getSelectedItem());
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                return;
            }
            this.d_molecularWeight.setValue(exSpec.getMolecularWeight());
            this.d_formula.setValue(exSpec.getChemFormula());
            if (exSpec.getWtType() == 2) {
                this.d_rbFormula.setSelected(true);
            } else {
                this.d_rbMolecularWeight.setSelected(true);
            }
            this.d_lumpedOnlyCB.setSelectedItem((Object)exSpec.getLumpedComponentOnlyRule());
            if (exSpec.getType() == 0) {
                ExSpecEditor.setEnabled(false, new JComponent[]{this.d_rbMolecularWeight, this.d_rbFormula, this.d_formula, this.d_molecularWeight});
            } else {
                ExSpecEditor.setEnabled(true, new JComponent[]{this.d_rbMolecularWeight, this.d_rbFormula, this.d_formula, this.d_molecularWeight});
            }
            this.setModified(false);
        }
    }

    private class LumpedPanel
    extends guiPanel {
        private static final long serialVersionUID = 459896813178766128L;
        private ExSpecList d_exSpecs;
        private guiRadioButton d_rbMass;
        private guiRadioButton d_rbVolume;
        private guiTable d_table;

        public LumpedPanel(ExSpecList exSpecList) {
            this.d_exSpecs = exSpecList;
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Composition:"));
            this.d_rbMass = new guiRadioButton(Intl.intl("by Mass"));
            this.d_rbMass.setToolTipText("MASS_FRACTION(:)");
            this.d_rbVolume = new guiRadioButton(Intl.intl("by Volume"));
            this.d_rbVolume.setToolTipText("VOLUME_FRACTION(:)");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_rbMass);
            buttonGroup.add(this.d_rbVolume);
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Primitive Species"), ""}, new Class[]{ExSpec.class, Double.class});
            this.d_table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 8427323169820811293L;

                @Override
                public void setValue(Object object) {
                    this.setText(object == null ? "" : ((ExSpec)object).getName());
                }
            });
            this.d_table.setColumnEditable(0, false);
            this.d_rbMass.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (LumpedPanel.this.d_rbMass.isSelected()) {
                        LumpedPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(Intl.intl("Mass Fraction"));
                    } else {
                        LumpedPanel.this.d_table.getColumnModel().getColumn(1).setHeaderValue(Intl.intl("Volume Fraction"));
                    }
                    LumpedPanel.this.d_table.updateUI();
                }
            });
            this.d_table.setPreferredScrollableViewportSize(new Dimension(150, 200));
            GridBagHelper gridBagHelper = new GridBagHelper(this, true);
            gridBagHelper.addRow(guiLabel2, this.d_rbMass, this.d_rbVolume);
            gridBagHelper.addRow(new JScrollPane(this.d_table), new double[]{1.0, 1.0}, new int[]{0, 0});
            gridBagHelper.indent();
            gridBagHelper.finalizeRows();
        }

        public void saveData(ExSpec exSpec) {
            int n;
            if (!this.isModified()) {
                return;
            }
            LinkedHashMap<ExSpec, Double> linkedHashMap = new LinkedHashMap<ExSpec, Double>();
            int n2 = this.d_table.getRowCount();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    double d = (Double)this.d_table.getValueAt(n, 1);
                    if (!(d > 0.0)) continue;
                    linkedHashMap.put((ExSpec)this.d_table.getValueAt(n, 0), d);
                }
            }
            n = this.d_rbMass.isSelected() ? 2 : 3;
            exSpec.setComposition(n, linkedHashMap);
        }

        public void init(ExSpec exSpec) {
            if (exSpec == null) {
                ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(0);
                this.setModified(false);
                return;
            }
            ArrayList arrayList = new ArrayList(this.d_exSpecs.flatten());
            Collections.sort(arrayList, new Comparator<ExSpec>(){

                @Override
                public int compare(ExSpec exSpec, ExSpec exSpec2) {
                    return exSpec.getName().compareTo(exSpec2.getName());
                }
            });
            int n = 0;
            for (ExSpec exSpec2 : arrayList) {
                if (exSpec2.getType() == 2 || exSpec2.getType() == 3 || exSpec2.getType() == 5) continue;
                this.d_table.getModel().setValueAt(exSpec2, n, 0);
                if (exSpec.getComposition().containsKey(exSpec2)) {
                    this.d_table.getModel().setValueAt(exSpec.getComposition().get(exSpec2), n, 1);
                } else {
                    this.d_table.getModel().setValueAt(0.0, n, 1);
                }
                ++n;
            }
            if (n > 0) {
                this.d_table.setRowLimit(n);
            } else {
                this.d_table.setRowLimit(1);
            }
            if (exSpec.getType() == 2) {
                this.d_rbMass.setSelected(true);
            } else {
                this.d_rbVolume.setSelected(true);
            }
            this.setModified(false);
        }
    }

    private static class HTMLLabel
    extends guiLabel {
        private static final long serialVersionUID = 2811808823405044338L;

        public HTMLLabel() {
            this("");
        }

        public HTMLLabel(String string) {
            super(string);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.setForeground(bl ? (Color)UIManager.get("Label.foreground") : (Color)UIManager.get("Label.disabledForeground"));
        }
    }
}

