/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import pyrosim.Intl;
import pyrosim.domain.AWriteablePyroObject;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.BitOptions;

public class CustomFDSPanel
extends guiPanel
implements Modifiable {
    private static final long serialVersionUID = 967771464268406086L;
    public static final int FORCE_WRITE = 1;
    public static final int DISPLAY_TITLE = 2;
    public static final int INSET_BORDER = 4;
    private final String MULTIPLE = Intl.intl("<multiple>");
    private final BitOptions d_options;
    private guiTable d_table;
    private guiCheckBox d_forceWrite;
    private String d_implicitRecordType;
    private Map<Integer, AAdvancedObjPanel> d_advancedProps;
    private Set<String> d_loadedTypes = Collections.emptySet();

    public CustomFDSPanel(int n) {
        this.d_advancedProps = new LinkedHashMap<Integer, AAdvancedObjPanel>();
        this.d_options = new BitOptions(n);
        this.initGui(Collections.EMPTY_SET, this.d_options);
    }

    public void clear() {
        if (this.d_table != null) {
            ((guiDefaultTableModel)this.d_table.getModel()).setRowCount(0);
        }
        this.setModified(false);
    }

    protected void initGui(Set<String> set, BitOptions bitOptions) {
        this.removeAll();
        if (set.size() > 1) {
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Record"), Intl.intl("Name"), Intl.intl("Value")}, new Class[]{String.class, String.class, String.class});
            this.d_table.setColumnOptions(0, set);
            this.d_implicitRecordType = null;
        } else {
            this.d_implicitRecordType = !set.isEmpty() ? set.iterator().next() : null;
            this.d_table = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Name"), Intl.intl("Value")}, new Class[]{String.class, String.class});
        }
        guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 22);
        this.d_table.getParent().setPreferredSize(new Dimension(150, 1));
        this.d_table.setPreferredScrollableViewportSize(new Dimension(150, guiTableEditor2.getPreferredSize().height));
        GridBagHelper gridBagHelper = new GridBagHelper(this, bitOptions.get(4L));
        if (bitOptions.get(2L)) {
            String string = "";
            for (String string2 : set) {
                if (!string.isEmpty()) {
                    string = string + ",";
                }
                string = string + string2;
            }
            String string3 = String.format(Intl.intl("Additional Fields (%s)"), string);
            gridBagHelper.addFilledRow(new TitleSeparator(string3));
            gridBagHelper.indent();
        }
        this.d_advancedProps.clear();
        this.populateAdvancedObjPanels(bitOptions);
        if (bitOptions.get(1L)) {
            gridBagHelper.addRow(this.d_advancedProps.get(1));
        }
        gridBagHelper.addRow(guiTableEditor2, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
    }

    public Set<String> getLoadedTypes() {
        return this.d_loadedTypes;
    }

    public void load(ICustomFDSPropsContainer ... iCustomFDSPropsContainerArray) {
        this.load(Arrays.asList(iCustomFDSPropsContainerArray));
    }

    public void load(Collection<? extends ICustomFDSPropsContainer> collection) {
        this.load(collection, new AdvPropWrapper[0]);
    }

    public void load(Collection<? extends ICustomFDSPropsContainer> collection, AdvPropWrapper ... advPropWrapperArray) {
        Map<String, Map<String, String>> map = this.mergeProps(collection);
        this.d_loadedTypes = new HashSet<String>(map.keySet());
        this.initGui(this.d_loadedTypes, new BitOptions(this.d_options.getRaw() | (long)this.getAdvOptions(advPropWrapperArray)));
        map.entrySet().stream().forEachOrdered(entry -> this.load((String)entry.getKey(), (Map)entry.getValue()));
        this.loadAdvancedObjPanels(advPropWrapperArray);
    }

    public boolean setTypes(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        if (hashSet.equals(this.d_loadedTypes)) {
            return false;
        }
        Map<String, Map<String, String>> map2 = this.save();
        boolean bl = map2.values().stream().anyMatch(map -> !map.isEmpty());
        map2.keySet().retainAll(hashSet);
        boolean bl2 = this.isModified();
        this.initGui(hashSet, this.d_options);
        map2.entrySet().stream().forEachOrdered(entry -> this.load((String)entry.getKey(), (Map)entry.getValue()));
        this.d_loadedTypes = hashSet;
        if (bl2) {
            this.setModified(true);
        }
        return bl;
    }

    private Map<String, Map<String, String>> mergeProps(Collection<? extends ICustomFDSPropsContainer> collection) {
        Object object;
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        Function<String, Map> function = string -> new LinkedHashMap(1);
        for (ICustomFDSPropsContainer object4 : collection) {
            Collection<String> collection2 = object4.getCustomFDSTypes();
            for (Object object2 : collection2) {
                object = linkedHashMap.computeIfAbsent((String)object2, function);
                CustomFDSProps customFDSProps = object4.getCustomFDSProps((String)object2);
                for (Map.Entry<String, String> entry : customFDSProps.getProps().entrySet()) {
                    object.put(entry.getKey(), "");
                }
            }
        }
        HashSet hashSet = new HashSet(linkedHashMap.keySet());
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : collection) {
            Object object2;
            Collection<String> collection3 = iCustomFDSPropsContainer.getCustomFDSTypes();
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!collection3.contains(object)) continue;
                int n = 0;
                Map map = (Map)linkedHashMap.get(object);
                Map<String, String> map2 = iCustomFDSPropsContainer.getCustomFDSProps((String)object).getProps();
                for (Map.Entry entry : map.entrySet()) {
                    String string2 = (String)entry.getValue();
                    if (string2 == this.MULTIPLE) {
                        ++n;
                        continue;
                    }
                    String string3 = map2.get(entry.getKey());
                    if (string3 != null && string2 == "") {
                        entry.setValue(string3);
                        continue;
                    }
                    if (string3 != null && string3.equals(string2)) continue;
                    entry.setValue(this.MULTIPLE);
                    ++n;
                }
                if (n != map.size()) continue;
                object2.remove();
            }
            if (!hashSet.isEmpty()) continue;
            return linkedHashMap;
        }
        return linkedHashMap;
    }

    protected void load(String string, Map<String, String> map) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
        int n = guiDefaultTableModel2.getRowCount();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            int n2 = 0;
            if (this.d_table.getColumnCount() == 3) {
                guiDefaultTableModel2.setValueAt(string, n, n2++);
            }
            guiDefaultTableModel2.setValueAt(entry.getKey(), n, n2++);
            guiDefaultTableModel2.setValueAt(entry.getValue(), n, n2++);
            ++n;
        }
        this.setModified(false);
    }

    public void save(ICustomFDSPropsContainer ... iCustomFDSPropsContainerArray) {
        this.save(Arrays.asList(iCustomFDSPropsContainerArray));
    }

    public void save(Collection<? extends ICustomFDSPropsContainer> collection) {
        if (!this.isModified()) {
            return;
        }
        Map<String, Map<String, String>> map2 = this.save();
        HashSet hashSet = new HashSet();
        map2.forEach((string2, map) -> {
            if (map.values().stream().allMatch(string -> string != this.MULTIPLE)) {
                hashSet.add(string2);
            }
        });
        for (ICustomFDSPropsContainer iCustomFDSPropsContainer : collection) {
            Collection<String> collection2 = iCustomFDSPropsContainer.getCustomFDSTypes();
            for (String string : collection2) {
                LinkedHashMap<String, String> linkedHashMap;
                LinkedHashMap<String, String> linkedHashMap2 = map2.get(string);
                if (hashSet.contains(string)) {
                    linkedHashMap = linkedHashMap2;
                } else if (linkedHashMap2 == null) {
                    linkedHashMap = Collections.EMPTY_MAP;
                } else {
                    linkedHashMap = new LinkedHashMap<String, String>(iCustomFDSPropsContainer.getCustomFDSProps(string).getProps());
                    for (Map.Entry entry : linkedHashMap2.entrySet()) {
                        if (entry.getValue() == this.MULTIPLE) continue;
                        linkedHashMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    linkedHashMap.keySet().retainAll(linkedHashMap2.keySet());
                }
                iCustomFDSPropsContainer.setCustomFDSProps(string, CustomFDSProps.get((Map<String, String>)linkedHashMap));
            }
        }
        this.saveAdvanced(collection);
    }

    protected void saveAdvanced(Collection<? extends ICustomFDSPropsContainer> collection) {
        if (this.d_advancedProps.containsKey(1)) {
            for (ICustomFDSPropsContainer iCustomFDSPropsContainer : collection) {
                if (!(iCustomFDSPropsContainer instanceof AWriteablePyroObject)) continue;
                ((AWriteablePyroObject)((Object)iCustomFDSPropsContainer)).setForceWrite((Boolean)this.getAdvancedObjValue(1));
            }
        }
    }

    protected Map<String, Map<String, String>> save() {
        LinkedHashMap<String, Map<String, String>> linkedHashMap = new LinkedHashMap<String, Map<String, String>>();
        Function<String, Map> function = string -> new LinkedHashMap();
        int n = this.d_table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            int n2 = 0;
            String string4 = this.d_implicitRecordType;
            if (this.d_table.getColumnCount() == 3) {
                string4 = (String)this.d_table.getValueAt(i, n2++);
            }
            if (string4 == null) continue;
            Map map = linkedHashMap.computeIfAbsent(string4, function);
            if ((string3 = (String)this.d_table.getValueAt(i, n2++)) == null || string3.trim().isEmpty()) continue;
            if ((string2 = (String)this.d_table.getValueAt(i, n2++)) == null || string2.trim().isEmpty()) {
                string2 = this.MULTIPLE;
            }
            map.put(string3, string2);
        }
        return linkedHashMap;
    }

    public Object getAdvancedObjValue(int n) {
        if (this.d_advancedProps.get(n) != null) {
            AAdvancedObjPanel aAdvancedObjPanel = this.d_advancedProps.get(n);
            return aAdvancedObjPanel.getValue();
        }
        return null;
    }

    private void populateAdvancedObjPanels(BitOptions bitOptions) {
        if (bitOptions.get(1L)) {
            AdvancedCheckBoxPanel advancedCheckBoxPanel = new AdvancedCheckBoxPanel(Intl.intl("Always Write FDS Record"));
            this.d_advancedProps.put(1, advancedCheckBoxPanel);
        }
    }

    private void loadAdvancedObjPanels(AdvPropWrapper ... advPropWrapperArray) {
        for (AdvPropWrapper advPropWrapper : advPropWrapperArray) {
            this.d_advancedProps.get(advPropWrapper.getOption()).load(advPropWrapper.getObj());
        }
    }

    private int getAdvOptions(AdvPropWrapper ... advPropWrapperArray) {
        int n = 0;
        for (AdvPropWrapper advPropWrapper : advPropWrapperArray) {
            n |= advPropWrapper.getOption();
        }
        return n;
    }

    public static class AdvPropWrapper<T> {
        private int option;
        private T obj;

        public AdvPropWrapper(T t, int n) {
            this.obj = t;
            this.option = n;
        }

        public int getOption() {
            return this.option;
        }

        public T getObj() {
            return this.obj;
        }
    }

    private class AdvancedCheckBoxPanel
    extends AAdvancedObjPanel<Boolean> {
        private static final long serialVersionUID = -201726824989459104L;
        private guiCheckBox d_optCB;

        public AdvancedCheckBoxPanel(String string) {
            this.setLayout(new GridBagLayout());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            this.d_optCB = new guiCheckBox(string);
            gridBagHelper.addRow(this.d_optCB);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void load(Boolean bl) {
            this.d_optCB.setSelected(bl);
            this.setModified(false);
        }

        @Override
        public Boolean getValue() {
            return this.d_optCB.isSelected();
        }
    }

    private abstract class AAdvancedObjPanel<T>
    extends guiPanel {
        private static final long serialVersionUID = -6764100768120926352L;

        private AAdvancedObjPanel() {
        }

        public abstract T getValue();

        public abstract void load(T var1);
    }
}

