/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.Grid;
import pyrosim.gui.PyroGuiUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.Pair;
import thunderheadeng.util.UncUtil;

public class ClusterFDSDlg
extends guiDialog {
    private static final long serialVersionUID = 2262726238112569914L;
    private final List<Grid> d_grids;
    private final guiTextField d_locationTF;
    private final JButton d_locationBtn;
    private final guiTableEditor d_tableEditor;
    private final guiTable d_table;
    private static Map<String, String> d_shared;
    private File d_outFile;

    public ClusterFDSDlg(JFrame jFrame, List<Grid> list, PyroMod pyroMod) {
        super((Window)jFrame, Intl.intl("Cluster FDS Parameters"), 9);
        Object object;
        this.d_grids = list;
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane(), true);
        this.d_locationTF = new guiTextField();
        this.d_locationTF.setEditable(false);
        this.d_locationTF.setColumns(30);
        this.d_locationBtn = new JButton(PyroGuiUtil.loadTeciIcon("Open16.gif"));
        this.d_locationBtn.setToolTipText(Intl.intl("Click to save FDS file."));
        this.d_locationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                guiFileChooser guiFileChooser2 = PyroSim.getFilenames().getFileChooser("FDS", "FDS 6 Input Files");
                guiFileChooser2.setSelectedFile(ClusterFDSDlg.this.d_outFile);
                if (guiFileChooser2.showSaveDialog(null) == 0) {
                    File file = guiFileChooser2.getSelectedFile();
                    ClusterFDSDlg.this.d_outFile = file;
                    if (System.getProperty("unc_disable") == null) {
                        try {
                            ClusterFDSDlg.this.d_outFile = new File(UncUtil.convertToUnc(file.getAbsolutePath()));
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    ClusterFDSDlg.this.d_locationTF.setText(ClusterFDSDlg.this.d_outFile.getAbsolutePath());
                    System.out.println(ClusterFDSDlg.this.d_outFile.getPath());
                }
            }
        });
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Note: FDS file should be saved in a shared location"));
        String[] stringArray = new String[]{Intl.intl("Host"), Intl.intl("Number of Processes"), Intl.intl("Assigned Meshes")};
        this.d_tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, new Class[]{String.class, Integer.class, String.class}), 0);
        this.d_table = this.d_tableEditor.getTable();
        this.d_table.setColumnEditable(2, false);
        this.d_table.setNullValuesAllowed(false);
        guiTextField guiTextField2 = new guiTextField();
        guiTextField2.setEditable(false);
        guiTextField2.setText(Integer.toString(this.d_grids.size()));
        guiTextField guiTextField3 = new guiTextField();
        guiTextField3.setEditable(false);
        guiLabel guiLabel3 = null;
        try {
            object = this.getHostname();
            guiTextField3.setText((String)object);
            guiLabel3 = new guiLabel(Intl.intl("Local Host:"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        gridBagHelper.addRow(Intl.intl("FDS File Location:"), this.d_locationTF, 1.0, 2, this.d_locationBtn);
        gridBagHelper.addRow(guiLabel2, 0);
        gridBagHelper.addRow(this.d_tableEditor, new double[]{1.0, 1.0}, 0);
        if (guiLabel3 != null) {
            gridBagHelper.addRow(guiLabel3, 2, guiTextField3);
        }
        gridBagHelper.addRow(Intl.intl("Number of meshes: "), 2, guiTextField2);
        gridBagHelper.finalizeRows();
        this.d_table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() < 2) {
                    ClusterFDSDlg.this.updateAssignedMeshes();
                }
            }
        });
        this.setResizable(true);
        this.setHostsToTable(this.getHostsFromPrefs());
        this.d_table.autoSizeColumns(100);
        this.updateAssignedMeshes();
        object = pyroMod.getClusterOptions();
        if (object != null && ((FDSClusterOptions)object).hasFileChanged) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = JOptionPane.showConfirmDialog(ClusterFDSDlg.this, Intl.intl("Update FDS file location to match new save location?"), Intl.intl("PSM File Moved"), 0);
                    if (n == 0) {
                        PyroSim pyroSim = (PyroSim)Application.getApp();
                        String string = pyroSim.getFilename();
                        string = FilenameManager.splitFilename(string)[0];
                        ClusterFDSDlg.this.d_outFile = new File(string + ".fds");
                        if (System.getProperty("unc_disable") == null) {
                            try {
                                ClusterFDSDlg.this.d_outFile = new File(UncUtil.convertToUnc(ClusterFDSDlg.this.d_outFile.getAbsolutePath()));
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        ClusterFDSDlg.this.d_locationTF.setText(ClusterFDSDlg.this.d_outFile.toString());
                    }
                }
            });
        }
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        if (n == 1) {
            this.saveHostsToPrefs(this.getHostsFromTable());
        }
        return n;
    }

    private List<Pair<String, Integer>> getHostsFromPrefs() {
        int n = PyroPrefs.getInt(PyroPrefs.PREF_CLUSTER_NUMHOSTS);
        ArrayList<Pair<String, Integer>> arrayList = new ArrayList<Pair<String, Integer>>(n);
        for (int i = 0; i < n; ++i) {
            String string = "mpi_host_" + i;
            String string2 = "mpi_proc_" + i;
            String string3 = PyroPrefs.instance().getString(string, null);
            int n2 = PyroPrefs.instance().getInt(string2, -1);
            if (string3 == null || n2 < 0) continue;
            arrayList.add(new Pair<String, Integer>(string3, n2));
        }
        return arrayList;
    }

    private void saveHostsToPrefs(List<Pair<String, Integer>> list) {
        PyroPrefs.set(PyroPrefs.PREF_CLUSTER_NUMHOSTS, list.size(), true);
        int n = 0;
        for (Pair<String, Integer> pair : list) {
            String string = "mpi_host_" + n;
            String string2 = "mpi_proc_" + n;
            PyroPrefs.instance().set(string, pair.v1);
            PyroPrefs.instance().set(string2, pair.v2);
            ++n;
        }
    }

    private List<Pair<String, Integer>> getHostsFromTable() {
        ArrayList<Pair<String, Integer>> arrayList = new ArrayList<Pair<String, Integer>>();
        TableModel tableModel = this.d_table.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Integer n = (Integer)this.d_table.getValueAt(i, 1);
            String string = (String)this.d_table.getValueAt(i, 0);
            if (string != null) {
                string = string.toLowerCase();
            }
            arrayList.add(new Pair<String, Integer>(string, n));
        }
        return arrayList;
    }

    private void setHostsToTable(List<Pair<String, Integer>> list) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
        guiDefaultTableModel2.setRowCount(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Pair<String, Integer> pair = list.get(i);
            guiDefaultTableModel2.setValueAt(pair.v1, i, 0);
            guiDefaultTableModel2.setValueAt(pair.v2, i, 1);
        }
    }

    private Map<String, List<Grid>> getMeshAssignments() {
        if (this.d_grids.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        List<Pair<String, Integer>> list = this.getHostsFromTable();
        ArrayList<Pair<String, ArrayList<Object>>> arrayList = new ArrayList<Pair<String, ArrayList<Object>>>();
        String string = null;
        ArrayDeque<Grid> arrayDeque = new ArrayDeque<Grid>(this.d_grids);
        for (Pair<String, Integer> object : list) {
            String string2 = (String)object.v1;
            if (string == null) {
                string = string2;
            }
            Integer n = (Integer)object.v2;
            if (string2 == null || n == null || n <= 0) continue;
            ArrayList<Grid> arrayList2 = new ArrayList<Grid>();
            for (int i = 0; i < n && !arrayDeque.isEmpty(); ++i) {
                Grid grid = (Grid)arrayDeque.removeFirst();
                arrayList2.add(grid);
            }
            if (arrayList2.isEmpty()) continue;
            arrayList.add(new Pair(string2, arrayList2));
        }
        if (!arrayDeque.isEmpty()) {
            if (!arrayList.isEmpty()) {
                ((List)((Pair)arrayList.get((int)(arrayList.size() - 1))).v2).addAll(arrayDeque);
            } else if (string != null) {
                arrayList.add(new Pair<String, ArrayList<Grid>>(string, new ArrayList<Grid>(this.d_grids)));
            }
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Pair pair : arrayList) {
            linkedHashMap.put(pair.v1, pair.v2);
        }
        return linkedHashMap;
    }

    private void updateAssignedMeshes() {
        Map<String, List<Grid>> map = this.getMeshAssignments();
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_table.getModel();
        for (int i = 0; i < guiDefaultTableModel2.getRowCount(); ++i) {
            String string = (String)guiDefaultTableModel2.getValueAt(i, 0);
            String string2 = "";
            if (string != null && map.containsKey(string)) {
                List<Grid> list = map.get(string);
                for (Grid grid : list) {
                    if (!string2.isEmpty()) {
                        string2 = string2 + "; ";
                    }
                    string2 = string2 + grid.getName();
                }
            }
            guiDefaultTableModel2.setValueAt(string2, i, 2);
        }
    }

    public void setFDSFile(File file) {
        this.d_outFile = file;
        if (System.getProperty("unc_disable") == null) {
            try {
                this.d_outFile = new File(UncUtil.convertToUnc(this.d_outFile.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.d_locationTF.setText(this.d_outFile.getAbsolutePath());
    }

    public File getOutFile() {
        return this.d_outFile;
    }

    public Map<String, Integer> getHosts() {
        List<Pair<String, Integer>> list = this.getHostsFromTable();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(list.size());
        for (Pair<String, Integer> pair : list) {
            linkedHashMap.put((String)pair.v1, (Integer)pair.v2);
        }
        return linkedHashMap;
    }

    public void setHosts(Map<String, Integer> map) {
        Map<String, Integer> map2 = this.getHosts();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        for (String object : map2.keySet()) {
            linkedHashMap.put(object, 0);
        }
        linkedHashMap.putAll(map);
        ArrayList arrayList = new ArrayList(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList.add(new Pair(entry.getKey(), entry.getValue()));
        }
        this.setHostsToTable(arrayList);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        List<Pair<String, Integer>> list = this.getHostsFromTable();
        if (list.isEmpty()) {
            if (bl) {
                JOptionPane.showMessageDialog(this, Intl.intl("Enter at least one host."));
            }
            return false;
        }
        for (Pair<String, Integer> object2 : list) {
            if ((Integer)object2.v2 >= 0) continue;
            if (bl) {
                JOptionPane.showMessageDialog(this, Intl.intl("The number of processes must be positive."));
            }
            return false;
        }
        HashSet hashSet = new HashSet();
        for (Pair<String, Integer> pair : list) {
            if (hashSet.add(pair.v1)) continue;
            if (bl) {
                JOptionPane.showMessageDialog(this, Intl.intl("Duplicate host names"));
            }
            return false;
        }
        try {
            String string = this.getHostname();
            String string2 = this.d_outFile.getAbsolutePath();
            if (!string2.startsWith("\\\\") && (list.size() > 1 || list.size() == 1 && !((String)list.get((int)0).v1).equalsIgnoreCase(string))) {
                int n;
                String string3 = null;
                if (!UncUtil.isShared(string2)) {
                    string3 = Intl.intl("FDS file may not be visible to other hosts.\nWould you like to continue with the chosen path?");
                }
                if (string3 != null && bl && (n = JOptionPane.showConfirmDialog(this, string3, Intl.intl("Warning"), 0, 2)) != 0) {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println(Intl.intl("Error validating FDS output folder."));
            throwable.printStackTrace();
        }
        return true;
    }

    private String getHostname() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        return string;
    }

    private int getNumProcess() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.availableProcessors();
    }
}

