/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.geom;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;

public class TexCoordGenerator {
    static final long serialVersionUID = 1L;
    public static final IElemSource<Point2d> DEFAULT_OBJ = DefaultGenerator.INSTANCE;
    public static final Function<IMaterial, Point2d> MAT_SIZE = MatSize.INSTANCE;

    public static PlanarCoordMapper newGenerator(IGeomNode iGeomNode, TexOrigin texOrigin) {
        return new PlanarCoordMapper(MAT_SIZE, texOrigin != null ? texOrigin.getWorld(iGeomNode).getValue(Geometry.LU) : GeomConstants.PNT3D_ORIGIN);
    }

    public static PlanarCoordMapper newGenerator(Point3d point3d) {
        return new PlanarCoordMapper(MAT_SIZE, point3d);
    }

    private static class DefaultGenerator
    extends PlanarCoordMapper {
        static final long serialVersionUID = 1L;
        public static final DefaultGenerator INSTANCE = new DefaultGenerator();

        public DefaultGenerator() {
            super(MAT_SIZE, GeomConstants.PNT3D_ORIGIN);
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static class MatSize
    implements Function<IMaterial, Point2d>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final MatSize INSTANCE = new MatSize();
        private static final Point2d ONE = new Point2d(1.0, 1.0);

        private MatSize() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        @Override
        public Point2d apply(IMaterial iMaterial) {
            if (!(iMaterial instanceof Surface)) {
                return ONE;
            }
            Surface surface = (Surface)iMaterial;
            Material material = surface.getAppearance();
            return new Point2d(material.getWidth().get(Geometry.LU), material.getHeight().get(Geometry.LU));
        }
    }
}

