/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.zones;

import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;

public class LeakUtil {
    public static Collection<Leak> getLeaks(PyroMod pyroMod, Zone zone) {
        return LeakUtil.getLeaks(pyroMod.getBridges(), zone);
    }

    public static Collection<Leak> getLeaks(BridgeList bridgeList, Zone zone) {
        return bridgeList.flatten(Leak.class, new ZoneFilter(zone));
    }

    public static Leak getLeak(PyroMod pyroMod, Zone zone, Zone zone2) {
        ZoneFilter zoneFilter = new ZoneFilter(zone);
        Predicate<Leak> predicate = zoneFilter.and(new ZoneFilter(zone2));
        Collection<Leak> collection = pyroMod.getBridges().flatten(Leak.class, predicate);
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static class ZoneFilter
    implements Predicate<Leak> {
        public final Zone zone;

        public ZoneFilter(Zone zone) {
            this.zone = zone;
        }

        @Override
        public boolean test(Leak leak) {
            return leak.zone1 == this.zone || leak.zone2 == this.zone;
        }
    }
}

