/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PropertyObject;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.view.ViewMode;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Sets;

public class View
extends PropertyObject {
    static final long serialVersionUID = 1L;
    public static final int MAX_CLIP_PLANES = 4;
    public static final List<ChildProp<? extends IPyroObject>> CHILD_PROPS = new ArrayList<ChildProp<? extends IPyroObject>>();
    private static final IPropertySet.Prop<Set<ClipPlane>> PROP_CLIP_PLANES = new IPropertySet.Prop<Set>(5002, Collections.EMPTY_SET);
    public static final IPropertySet.Prop<CameraState> PROP_CAMERA = new ChildProp<Object>(5004, null);
    public static final IPropertySet.Prop<SectionBox> PROP_SECTION_BOX = new ChildProp<Object>(5003, null);
    public static final IPropertySet.Prop<NavTool> PROP_NAV_TOOL = new IPropertySet.Prop<NavTool>(5005, NavTool.SELECT);
    public static final Set<IPropertySet.Prop<?>> ALL_PROPS = Sets.fromArrayHS(PROP_SECTION_BOX, PROP_CAMERA, PROP_NAV_TOOL);

    public View(String string) {
        super(string);
    }

    @Override
    public View clone() {
        View view = (View)super.clone();
        for (ChildProp<? extends IPyroObject> childProp : CHILD_PROPS) {
            IPyroObject iPyroObject = this.get(childProp);
            if (iPyroObject == null) continue;
            IPyroObject iPyroObject2 = (IPyroObject)iPyroObject.clone();
            view.removeFromProps(childProp);
            view.setToProps(childProp, iPyroObject2);
        }
        return view;
    }

    private <T> void removeFromProps(IPropertySet.Prop<T> prop) {
        super.remove(prop);
    }

    private <T> void setToProps(IPropertySet.Prop<T> prop, T t) {
        super.set(prop, t);
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof View && super.equals(object);
    }

    @Override
    public <T> T set(IPropertySet.Prop<T> prop, T t) {
        this.pauseUpdates();
        T t2 = super.set(prop, t);
        if (prop instanceof ChildProp && t2 != t) {
            if (t2 != null) {
                this.removeChild((IPyroObject)t2);
            }
            if (t != null) {
                this.addChild((IPyroObject)t);
            }
        }
        this.resumeUpdates();
        return t2;
    }

    @Override
    public <T> T remove(IPropertySet.Prop<T> prop) {
        this.pauseUpdates();
        T t = super.remove(prop);
        if (prop instanceof ChildProp && t != null) {
            this.removeChild((IPyroObject)t);
        }
        this.resumeUpdates();
        return t;
    }

    protected void addChild(IPyroObject iPyroObject) {
        iPyroObject.setDomain((PyroMod)this.getDomain(), this);
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
    }

    protected void removeChild(IPyroObject iPyroObject) {
        iPyroObject.setDomain(null, this);
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
    }

    public boolean isDefinedClipPlanes() {
        return this.isDefined(PROP_CLIP_PLANES);
    }

    public void addClipPlane(ClipPlane clipPlane) {
        Set<ClipPlane> set = this.get(PROP_CLIP_PLANES);
        if (set.contains(clipPlane)) {
            return;
        }
        if (set.isEmpty()) {
            set = new LinkedIdentityHashSet<ClipPlane>();
            set.add(clipPlane);
            this.set(PROP_CLIP_PLANES, set);
        } else {
            set.add(clipPlane);
        }
        this.addChild(clipPlane);
    }

    public void removeClipPlane(ClipPlane clipPlane) {
        Set<ClipPlane> set = this.get(PROP_CLIP_PLANES);
        if (!set.remove(clipPlane)) {
            return;
        }
        if (set.isEmpty()) {
            this.remove(PROP_CLIP_PLANES);
        }
        this.removeChild(clipPlane);
    }

    public Set<ClipPlane> getClipPlanes() {
        return this.get(PROP_CLIP_PLANES);
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        Set<ClipPlane> set = this.getClipPlanes();
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(set.size());
        arrayList.addAll(set);
        for (ChildProp<? extends IPyroObject> childProp : CHILD_PROPS) {
            IPyroObject iPyroObject = this.get(childProp);
            if (iPyroObject == null) continue;
            arrayList.add(iPyroObject);
        }
        return arrayList;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public Optional<ViewMode> getViewMode() {
        CameraState cameraState = this.get(PROP_CAMERA);
        if (cameraState == null) {
            return Optional.empty();
        }
        return Optional.of(cameraState.getViewMode());
    }

    public static boolean isCamChanged(PyroMod pyroMod, Events events) {
        if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED) || events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW)) {
            return true;
        }
        View view = pyroMod.getViews().getActiveView();
        if (events.getEvents(View.class, new Class[0]).getChangedObjs(PROP_CAMERA).contains(view)) {
            return true;
        }
        IEventRecord<CameraState> iEventRecord = events.getEvents(CameraState.class, new Class[0]).filter(cameraState -> cameraState.getParent() == view);
        return iEventRecord.hasChangedObjs(EventChannel.EVT_GENERAL, PyroMod.EVT_PARENT_CHANGED) || iEventRecord.hasAddedObjs();
    }

    public static enum NavTool {
        SELECT,
        PAN,
        ZOOM,
        ZOOM_BOX,
        ORBIT,
        ROAM;

    }

    public static class ChildProp<T extends IPyroObject>
    extends IPropertySet.Prop<T> {
        public ChildProp(Object object, T t) {
            super(object, t);
            CHILD_PROPS.add(this);
        }
    }
}

