/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.view.AViewGeomProp;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class SectionBox
extends AViewGeomProp<IGeom>
implements INamed {
    static final long serialVersionUID = 1L;
    private Color d_color;

    public SectionBox(IGeom iGeom) {
        super(iGeom);
        assert (iGeom.getNumPrims(1) <= 6);
        this.d_color = Color.GREEN;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_color == null) {
            this.d_color = Color.GREEN;
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getName() {
        return Intl.intl("Section Box");
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPrimProps.Edge edge = new IPrimProps.Edge(this.d_color, 2.0, 61680, 0);
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Pair<ICurve, Integer> pair : GeomUtil.getFaceOutlines((IGeom)this.get())) {
            Mesh mesh = ((ICurve)pair.v1).getSegments(iDisplayProps.getCurveError());
            int n = arrayList.size();
            arrayList.addAll(Arrays.asList(mesh.vertices));
            for (int n2 : mesh.indices) {
                arrayList2.add(n2 + n);
            }
        }
        Mesh mesh = new Mesh(theUtil.toArray(arrayList, Point3d.class), theUtil.toIntArray(arrayList2), 1);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(mesh), (IPrimProps)edge);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        this.set(iGeom);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public IGeom getBoxGeom() {
        return (IGeom)this.get();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this == object;
    }
}

