/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.awt.Color;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.view.AViewGeomProp;
import pyrosim.domain.view.ViewMode;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;

public class CameraState
extends AViewGeomProp<CameraRecord> {
    static final long serialVersionUID = 1L;

    public CameraState(CameraRecord cameraRecord) {
        super(cameraRecord);
    }

    @Override
    public CameraState clone() {
        return (CameraState)super.clone();
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof CameraGeom) {
            this.set(((CameraGeom)iGeom).record);
        } else if (iGeom instanceof Point) {
            Point point = (Point)iGeom;
            Vector3d vector3d = Util3D.vector(((CameraRecord)this.get()).loc, point.loc);
            ITransform iTransform = TransformUtil.translate(vector3d.x, vector3d.y, vector3d.z);
            CameraGeom cameraGeom = this.getCameraGeom().transform(iTransform.getInfo(), 1);
            this.setGeom(cameraGeom);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getCameraGeom());
    }

    private CameraGeom getCameraGeom() {
        return new CameraGeom((CameraRecord)this.get());
    }

    public CameraRecord getCameraRecord() {
        return this.getCameraGeom().record;
    }

    public ViewMode getViewMode() {
        return ((CameraRecord)this.get()).frustum instanceof OrthoCamera.FrustumRecord ? ViewMode.MV_2D : ViewMode.MV_3D;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Vertex(Color.GREEN, 10.0));
    }

    @Override
    public boolean isEquiv(Object object) {
        return this == object;
    }

    private static class CameraGeom
    extends Point {
        private static final long serialVersionUID = -2076150722662797833L;
        public final CameraRecord record;

        public CameraGeom(CameraRecord cameraRecord) {
            super(cameraRecord.loc);
            this.record = cameraRecord;
        }

        @Override
        public CameraGeom optimize(IPointOptimizer iPointOptimizer) {
            Point3d point3d = iPointOptimizer.getExisting(this.record.loc);
            Point3d point3d2 = iPointOptimizer.getExisting(this.record.ref);
            if (point3d == this.record.loc && point3d2 == this.record.ref) {
                return this;
            }
            CameraRecord cameraRecord = new CameraRecord(point3d, point3d2, this.record.up, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum);
            return new CameraGeom(cameraRecord);
        }

        @Override
        public CameraGeom transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = transformInfo.getMatrix();
            Point3d point3d = Util3D.xform(matrix4d, this.record.loc);
            Point3d point3d2 = Util3D.xform(matrix4d, this.record.ref);
            Vector3d vector3d = Util3D.xform(matrix4d, this.record.up);
            Vector3d vector3d2 = Util3D.vector(point3d, point3d2);
            Vector3d vector3d3 = Util3D.cross(vector3d2, vector3d);
            vector3d.cross(vector3d3, vector3d2);
            double d = Util3D.safeNormalize(vector3d, 1.0E-6);
            if (d == 0.0) {
                return this;
            }
            return new CameraGeom(new CameraRecord(point3d, point3d2, vector3d, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum));
        }
    }
}

