/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.variant;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ramp.Ramp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Variant
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final Variant DEFAULT = new Variant(DefObj.INSTANCE);
    public final Object val;

    private Variant(Object object) {
        this.val = object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        return theUtil.equal(this.val, variant.val);
    }

    public int hashCode() {
        return 2508582 + theUtil.hashCode(this.val.hashCode());
    }

    private Object readResolve() throws ObjectStreamException {
        return this.val == null ? DEFAULT : this;
    }

    public Variant clone() {
        if (this.val instanceof Ramp) {
            return new Variant(((Ramp)this.val).clone());
        }
        if (this.val instanceof FractionalRamp) {
            FractionalRamp fractionalRamp = (FractionalRamp)this.val;
            return new Variant(new FractionalRamp(fractionalRamp.constInput, (Ramp)fractionalRamp.fractionalRamp.clone()));
        }
        return this;
    }

    public boolean isConstant() {
        return this.val instanceof UnitDouble;
    }

    public boolean isRamp() {
        return this.val instanceof Ramp;
    }

    public boolean isFractionalRamp() {
        return this.val instanceof FractionalRamp;
    }

    public boolean isDefault() {
        return this.val == DefObj.INSTANCE;
    }

    public Type getType() {
        if (this.isConstant()) {
            return Type.CONSTANT;
        }
        if (this.isRamp()) {
            return Type.RAMP;
        }
        if (this.isFractionalRamp()) {
            return Type.FRACTIONAL_RAMP;
        }
        return Type.DEFAULT;
    }

    public static Variant constant(UnitDouble unitDouble) {
        return new Variant(unitDouble);
    }

    public static Variant constant(double d, Unit unit) {
        return Variant.constant(new UnitDouble(d, unit));
    }

    public static Variant ramp(Ramp ramp) {
        return new Variant(ramp);
    }

    public static Variant def() {
        return DEFAULT;
    }

    public static Variant fracRamp(double d, Unit unit, Ramp ramp) {
        return Variant.fracRamp(new UnitDouble(d, unit), ramp);
    }

    public static Variant fracRamp(UnitDouble unitDouble, Ramp ramp) {
        return new Variant(new FractionalRamp(unitDouble, ramp));
    }

    public static class FractionalRamp
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble constInput;
        public final Ramp fractionalRamp;

        private FractionalRamp(UnitDouble unitDouble, Ramp ramp) {
            this.constInput = unitDouble;
            this.fractionalRamp = ramp;
        }
    }

    private static class DefObj
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DefObj INSTANCE = new DefObj();

        private DefObj() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    public static enum Type {
        DEFAULT,
        CONSTANT,
        RAMP,
        FRACTIONAL_RAMP;

    }
}

