/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.variant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.variant.IRampProfile;
import pyrosim.domain.variant.Variant;

public class DefRampProfile
implements IRampProfile {
    public final String dispName;
    public final Input[] inputs;
    public final Variant defValue;

    public DefRampProfile(String string, int n, Input ... inputArray) {
        this(string, DefRampProfile.newRamp(n, inputArray), inputArray);
    }

    protected static Ramp newRamp(int n, Input ... inputArray) {
        assert (inputArray.length > 0 && inputArray[0].val != null);
        return new Ramp(Collections.EMPTY_LIST, inputArray[0].val, n);
    }

    public DefRampProfile(String string, Ramp ramp, Input ... inputArray) {
        this(string, Variant.ramp(ramp), inputArray);
    }

    protected DefRampProfile(String string, Variant variant, Input ... inputArray) {
        assert (inputArray.length > 0 && inputArray[0].val != null);
        this.dispName = string;
        this.inputs = inputArray;
        this.defValue = variant;
    }

    @Override
    public Variant.Type getType() {
        return Variant.Type.RAMP;
    }

    @Override
    public String getDisplayName() {
        return this.dispName;
    }

    @Override
    public Variant getDefaultValue() {
        return this.defValue;
    }

    @Override
    public Collection<IRampInput> getRampInputs(PyroMod pyroMod) {
        ArrayList<IRampInput> arrayList = new ArrayList<IRampInput>();
        for (Input input : this.inputs) {
            if (input.val == null) continue;
            arrayList.add(input.val);
        }
        if (this.test(Input.SIGNALS) && !this.test(Input.TIME)) {
            IDoubleOutPin iDoubleOutPin = (IDoubleOutPin)Clock.INSTANCE.getOutputPins().get(0);
            arrayList.add(new SignalInput(iDoubleOutPin));
        }
        final IRampInput iRampInput = (IRampInput)arrayList.get(0);
        Comparator<IRampInput> comparator = new Comparator<IRampInput>(){

            @Override
            public int compare(IRampInput iRampInput3, IRampInput iRampInput2) {
                if (iRampInput3 == iRampInput) {
                    return -1;
                }
                if (iRampInput2 == iRampInput) {
                    return 1;
                }
                return iRampInput3.getName().compareToIgnoreCase(iRampInput2.getName());
            }
        };
        Collections.sort(arrayList, comparator);
        if (this.test(Input.SIGNALS)) {
            ArrayList<SignalInput> arrayList2 = new ArrayList<SignalInput>();
            for (IDevice iDevice : pyroMod.getDevices().flatten()) {
                if (!(iDevice instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)iDevice)).getOutputPins()) {
                    if (!(iOutPin instanceof IDoubleOutPin)) continue;
                    SignalInput signalInput = new SignalInput((IDoubleOutPin)iOutPin);
                    arrayList2.add(signalInput);
                }
            }
            Collections.sort(arrayList2, comparator);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private boolean test(Input input) {
        for (Input input2 : this.inputs) {
            if (input2 != input) continue;
            return true;
        }
        return false;
    }

    public static enum Input {
        TIME(RampInputs.TIME),
        HEAT(RampInputs.HEAT),
        PRESSURE(RampInputs.PRESSURE),
        XPOS(RampInputs.XPOS),
        ZPOS(RampInputs.ZPOS),
        MASS(RampInputs.MASS),
        FLOW(RampInputs.FLOW),
        SIGNALS(null);

        public final IRampInput val;

        private Input(IRampInput iRampInput) {
            this.val = iRampInput;
        }
    }
}

