/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import pyrosim.domain.view.View;
import pyrosim.util.Nullable;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IPropertySet;

public class ViewPropTask<T>
extends AUndoableTask {
    private final List<View> d_views;
    private final IPropertySet.Prop<T> d_prop;
    private final BiFunction<View, Integer, Optional<Nullable<T>>> d_newVals;
    private List<Nullable<T>> d_oldVals;

    public static <T> ViewPropTask<T> set(List<View> list, IPropertySet.Prop<T> prop, BiFunction<View, Integer, T> biFunction) {
        return new ViewPropTask<T>(list, prop, (view, n) -> Optional.of(new Nullable(biFunction.apply((View)view, (Integer)n))));
    }

    public static <T> ViewPropTask<T> remove(List<View> list, IPropertySet.Prop<T> prop) {
        return new ViewPropTask<T>(list, prop, (view, n) -> Optional.empty());
    }

    public ViewPropTask(List<View> list, IPropertySet.Prop<T> prop, BiFunction<View, Integer, Optional<Nullable<T>>> biFunction) {
        this.d_views = list;
        this.d_prop = prop;
        this.d_newVals = biFunction;
        this.d_oldVals = null;
    }

    @Override
    public void run() {
        if (this.d_oldVals == null) {
            this.d_oldVals = new ArrayList<Nullable<T>>(this.d_views.size());
            for (View view : this.d_views) {
                boolean bl = view.isDefined(this.d_prop);
                Nullable<T> nullable = bl ? new Nullable<T>(view.get(this.d_prop)) : null;
                this.d_oldVals.add(nullable);
            }
        }
        for (int i = 0; i < this.d_views.size(); ++i) {
            View view;
            view = this.d_views.get(i);
            Optional<Nullable<T>> optional = this.d_newVals.apply(view, i);
            if (optional.isPresent()) {
                view.set(this.d_prop, optional.get().val);
                continue;
            }
            view.remove(this.d_prop);
        }
    }

    @Override
    public void undo() {
        for (int i = this.d_views.size() - 1; i >= 0; --i) {
            View view = this.d_views.get(i);
            Nullable<T> nullable = this.d_oldVals.get(i);
            if (nullable == null) {
                view.remove(this.d_prop);
                continue;
            }
            view.set(this.d_prop, nullable.val);
        }
    }
}

