/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitPoint3D;

public class TranslateTask
extends TransformTask {
    private final Point3d d_offset;

    public TranslateTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitPoint3D unitPoint3D) {
        super(pyroMod, collection, n);
        this.d_offset = unitPoint3D.getPoint3dValue(Geometry.LU);
    }

    @Override
    public ITransform getXFormForIteration(int n) {
        Point3d point3d = new Point3d(this.d_offset);
        point3d.scale(n);
        return TransformUtil.translate(point3d.x, point3d.y, point3d.z);
    }
}

