/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroDataContainer;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.io.ObjectSelection;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theTimer;

public abstract class TransformTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private List<IGeomNode> d_oldGeom = null;
    private Task d_copyTask = null;
    private final int d_n;

    public abstract ITransform getXFormForIteration(int var1);

    public TransformTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n) {
        this.d_mediator = pyroMod;
        this.d_objs = new ArrayList<IPyroObject>(collection);
        this.d_n = n;
    }

    @Override
    public int getEst() {
        return 1;
    }

    private static String generateName(INamed iNamed, int n) {
        return iNamed.getName() + "[" + (n + 1) + "]";
    }

    private void runCopyTask() {
        Object object;
        if (this.d_copyTask != null) {
            this.d_copyTask.run();
            return;
        }
        theTimer theTimer2 = new theTimer();
        System.out.print("Transforming/Copying...");
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        arrayList.addAll(this.d_objs);
        for (int i = 0; i < this.d_n; ++i) {
            TransformInfo transformInfo = this.getXFormForIteration(i + 1).getInfo();
            try {
                object = Actions.copyObjects(this.d_mediator, this.d_objs, true, Actions.PYRO_DATA_FLAVOR);
                PyroDataContainer pyroDataContainer = (PyroDataContainer)((ObjectSelection)object).getTransferData(Actions.PYRO_DATA_FLAVOR);
                Collection<? extends IPyroObject> collection = pyroDataContainer.getObjects();
                Map<IPyroObject, IPyroObject> map = TransformTask.getCopyMap(this.d_objs, collection);
                for (IPyroGeomSrc iPyroGeomSrc : Hierarchy.flatten(collection, IPyroGeomSrc.class)) {
                    IGeomNode iGeomNode = iPyroGeomSrc.getGeom();
                    iPyroGeomSrc.setGeom(iGeomNode.transform(transformInfo));
                }
                Task task = Actions.taskPasteObjects((PyroMod)this.d_mediator, pyroDataContainer.getObjects(), (String)"", (int)0, (Actions.IPasteCallback)new PasteCallback(map)).task;
                compositeTask.addTask(task);
                arrayList.addAll(pyroDataContainer.getObjects());
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        double d = theTimer2.curr();
        System.out.printf("done (%g s)%n", d);
        object = new SelectTask(this.d_mediator, arrayList);
        ((CompositeTask)object).addTask(compositeTask);
        this.d_copyTask = object;
        this.d_copyTask.run();
    }

    private static Map<IPyroObject, IPyroObject> getCopyMap(Collection<? extends IPyroObject> collection, Collection<? extends IPyroObject> collection2) {
        assert (collection2.size() >= collection.size());
        IdentityHashMap<IPyroObject, IPyroObject> identityHashMap = new IdentityHashMap<IPyroObject, IPyroObject>();
        Iterator<? extends IPyroObject> iterator = collection2.iterator();
        Iterator<? extends IPyroObject> iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            identityHashMap.put(iterator.next(), iterator2.next());
        }
        return identityHashMap;
    }

    private boolean isKeyedByName(Object object) {
        return Util.isKeyedByName(this.d_mediator, object);
    }

    private void undoCopyTask() {
        assert (this.d_copyTask != null);
        this.d_copyTask.undo();
    }

    private void runMoveTask() {
        Collection<IPyroGeomSrc> collection = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        if (this.d_oldGeom == null) {
            this.d_oldGeom = new ArrayList<IGeomNode>(collection.size());
            for (IPyroGeomSrc object : collection) {
                this.d_oldGeom.add(object.getGeom());
            }
        }
        TransformInfo transformInfo = this.getXFormForIteration(1).getInfo();
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            IGeomNode iGeomNode = iPyroGeomSrc.getGeom().transform(transformInfo);
            iPyroGeomSrc.setGeom(iGeomNode);
        }
    }

    private void undoMoveTask() {
        assert (this.d_oldGeom != null);
        int n = 0;
        Collection<IPyroGeomSrc> collection = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            iPyroGeomSrc.setGeom(this.d_oldGeom.get(n++));
        }
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.runMoveTask();
        } else {
            this.runCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.undoMoveTask();
        } else {
            this.undoCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    private static class PasteCallback
    extends Actions.APasteCallback {
        private final Map<IPyroObject, IPyroObject> d_copyMap;

        public PasteCallback(Map<IPyroObject, IPyroObject> map) {
            super(new Object[0]);
            this.d_copyMap = map;
        }

        @Override
        public Actions.PasteOverwrite getReplaceModelObject(IPyroObject iPyroObject, IPyroObject iPyroObject2) throws CancellationException {
            return Actions.PasteOverwrite.KEEP_EXISTING;
        }

        @Override
        public Object getPasteLocation(PyroMod pyroMod, Object object) {
            IPyroObject iPyroObject;
            IPyroObject iPyroObject2 = this.d_copyMap.get(object);
            if (iPyroObject2 != null && TVEntryPoints.ep(iPyroObject = iPyroObject2.getParent()).canPaste(pyroMod, iPyroObject, object)) {
                return iPyroObject;
            }
            return super.getPasteLocation(pyroMod, object);
        }

        @Override
        public List<Reaction> getActiveReactions(Collection<Reaction> collection, Map<Reaction, Actions.PasteCommand> map, List<Reaction> list) throws CancellationException {
            return list;
        }
    }
}

