/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.DeletePreserveTask;
import pyrosim.domain.tasks.DeleteTask;
import pyrosim.domain.tasks.ReplacePreserveTask;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Tasks {
    public static Task replace(List<? extends IPyroObject> list, List<? extends IPyroObject> list2, boolean bl) {
        if (list.isEmpty()) {
            return EmptyTask.INSTANCE;
        }
        assert (list.size() == list2.size());
        if (!bl) {
            CompositeTask compositeTask = new CompositeTask(list.get(0).getDomain());
            compositeTask.addTask(Tasks.delete(list));
            for (int i = 0; i < list.size(); ++i) {
                IPyroObject iPyroObject = list.get(i).getParent();
                compositeTask.addTask(new AddTask(iPyroObject, new IPyroObject[]{list2.get(i)}));
            }
            return compositeTask;
        }
        return new ReplacePreserveTask(list, list2);
    }

    public static Task replace(IPyroObject iPyroObject, IPyroObject iPyroObject2, boolean bl) {
        return Tasks.replace(Arrays.asList(iPyroObject), Arrays.asList(iPyroObject2), bl);
    }

    public static Task delete(IPyroObject ... iPyroObjectArray) {
        return Tasks.delete(Arrays.asList(iPyroObjectArray));
    }

    public static Task delete(Collection<? extends IPyroObject> collection) {
        boolean bl;
        assert (!collection.contains(null)) : "Attempting to delete null object. See case 28897.";
        collection = theUtil.filter(collection, iPyroObject -> iPyroObject != null);
        IFilteredCollection<? extends IPyroObject> iFilteredCollection = theUtil.filter(collection, new PreserveIxFilter(true));
        IFilteredCollection<? extends IPyroObject> iFilteredCollection2 = theUtil.filter(collection, new PreserveIxFilter(false));
        boolean bl2 = !iFilteredCollection.isEmpty();
        boolean bl3 = bl = !iFilteredCollection2.isEmpty();
        if (bl2 && bl) {
            CompositeTask compositeTask = new CompositeTask(collection.iterator().next().getDomain());
            compositeTask.addTask(new DeletePreserveTask(iFilteredCollection));
            compositeTask.addTask(new DeleteTask(iFilteredCollection2));
            return compositeTask;
        }
        if (bl2) {
            return new DeletePreserveTask(collection);
        }
        if (bl) {
            return new DeleteTask(collection);
        }
        return EmptyTask.INSTANCE;
    }

    private static class PreserveIxFilter<T extends IPyroObject>
    implements Predicate<T> {
        private final boolean d_preserve;

        public PreserveIxFilter(boolean bl) {
            this.d_preserve = bl;
        }

        @Override
        public boolean test(T t) {
            IPyroObject iPyroObject = t.getParent();
            assert (iPyroObject != null);
            return this.d_preserve == TVEntryPoints.ep(iPyroObject).preserveIndexOnDelete((PyroMod)t.getDomain(), iPyroObject, t);
        }
    }
}

