/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import thunderheadeng.util.Task;

public class SetEnabledSomeObjsTask
implements Task {
    private final PyroMod d_mediator;
    private boolean[] d_oldEnabled;
    private final boolean d_newEnabled;
    private final List<? extends IPyroObject> d_selectedObjs;

    public SetEnabledSomeObjsTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, boolean bl) {
        this.d_mediator = pyroMod;
        this.d_newEnabled = bl;
        this.d_selectedObjs = new ArrayList<IPyroObject>(collection);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int n = 0;
        for (IPyroObject iPyroObject : this.d_selectedObjs) {
            iPyroObject.setEnabled(this.d_oldEnabled[n++]);
        }
        this.d_oldEnabled = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        this.d_oldEnabled = new boolean[this.d_selectedObjs.size()];
        int n = 0;
        for (IPyroObject iPyroObject : this.d_selectedObjs) {
            this.d_oldEnabled[n++] = iPyroObject.isEnabled();
            iPyroObject.setEnabled(this.d_newEnabled);
        }
        this.d_mediator.resumeUpdates();
    }
}

