/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectReferencingObjTask
extends AOneTimeTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_selObjs;

    public SelectReferencingObjTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection) {
        this.d_mediator = pyroMod;
        this.d_selObjs = new ArrayList<IPyroObject>(collection);
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        DepSnapshot depSnapshot = this.d_mediator.getDependencies(this.d_selObjs);
        Predicate<Object> predicate = new Predicate<Object>(){

            @Override
            public boolean test(Object object) {
                if (!(object instanceof IPyroObject)) {
                    return false;
                }
                TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
                if (tVEntryPoint == null) {
                    return false;
                }
                return tVEntryPoint.showInTree(SelectReferencingObjTask.this.d_mediator, object);
            }
        };
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (IPyroObject iPyroObject : this.d_selObjs) {
            depSnapshot.findAllDependents(predicate, iPyroObject, linkedIdentityHashSet);
        }
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(linkedIdentityHashSet);
        this.d_mediator.resumeUpdates();
    }
}

