/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitPoint3D;

public class ScaleTask
extends TransformTask {
    private final Point3d d_base;
    private final Tuple3d d_scale;

    public ScaleTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        super(pyroMod, collection, n);
        this.d_base = unitPoint3D.getPoint3dValue(Geometry.LU);
        this.d_scale = new Vector3d(tuple3d);
    }

    @Override
    public ITransform getXFormForIteration(int n) {
        double d = Math.pow(this.d_scale.x, n);
        double d2 = Math.pow(this.d_scale.y, n);
        double d3 = Math.pow(this.d_scale.z, n);
        ITransform iTransform = TransformUtil.translate(this.d_base.x, this.d_base.y, this.d_base.z);
        iTransform = iTransform.concatenate(TransformUtil.scale(d, d2, d3));
        iTransform = iTransform.concatenate(TransformUtil.translate(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return iTransform;
    }

    private static class Transform {
        private Tuple3d d_scale;
        private Matrix4d d_matrix;

        private Transform() {
        }
    }
}

