/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class RotateTask
extends TransformTask {
    private final Point3d d_base;
    private final Vector3d d_rotateAxis;
    private final double d_angle;

    public RotateTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        super(pyroMod, collection, n);
        this.d_base = unitPoint3D.getPoint3dValue(Geometry.LU);
        this.d_rotateAxis = new Vector3d(vector3d);
        this.d_angle = unitDouble.getValue(SI.RADIAN);
    }

    @Override
    public ITransform getXFormForIteration(int n) {
        double d = this.d_angle * (double)n;
        ITransform iTransform = TransformUtil.translate(this.d_base.x, this.d_base.y, this.d_base.z);
        iTransform = iTransform.concatenate(TransformUtil.rotate(this.d_rotateAxis.x, this.d_rotateAxis.y, this.d_rotateAxis.z, d));
        iTransform = iTransform.concatenate(TransformUtil.translate(-this.d_base.x, -this.d_base.y, -this.d_base.z));
        return iTransform;
    }
}

