/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ReplacePreserveTask
extends AUndoableTask {
    private final ReplaceRecord[] d_replacements;

    public ReplacePreserveTask(List<? extends IPyroObject> list, List<? extends IPyroObject> list2) {
        this.d_replacements = new ReplaceRecord[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.d_replacements[i] = new ReplaceRecord(list.get(i), list2.get(i));
        }
    }

    @Override
    public void run() {
        if (this.d_replacements.length > 0 && this.d_replacements[0].index == -1) {
            IdentityHashMap<IPyroObject, ReplaceRecord> identityHashMap = new IdentityHashMap<IPyroObject, ReplaceRecord>();
            LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
            for (ReplaceRecord replaceRecord : this.d_replacements) {
                identityHashMap.put(replaceRecord.original, replaceRecord);
                linkedIdentityHashSet.add(replaceRecord.original.getParent());
            }
            for (IPyroObject iPyroObject : linkedIdentityHashSet) {
                int n = 0;
                for (IPyroObject iPyroObject2 : iPyroObject.getMembers()) {
                    ReplaceRecord replaceRecord = (ReplaceRecord)identityHashMap.get(iPyroObject2);
                    if (replaceRecord != null) {
                        replaceRecord.index = n;
                    }
                    ++n;
                }
            }
        }
        this.runReplacements();
    }

    @Override
    public void undo() {
        this.runReplacements();
    }

    private void runReplacements() {
        Cloneable cloneable;
        LinkedIdentityHashMap<IPyroObject, ArrayList<ReplaceRecord>> linkedIdentityHashMap = new LinkedIdentityHashMap<IPyroObject, ArrayList<ReplaceRecord>>();
        for (ReplaceRecord object : this.d_replacements) {
            cloneable = object.original.getParent();
            ArrayList<ReplaceRecord> arrayList = (ArrayList<ReplaceRecord>)linkedIdentityHashMap.get(cloneable);
            if (arrayList == null) {
                arrayList = new ArrayList<ReplaceRecord>();
                linkedIdentityHashMap.put((IPyroObject)cloneable, arrayList);
            }
            arrayList.add(object);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            IPyroObject iPyroObject = (IPyroObject)entry.getKey();
            TVEntryPoint<IPyroObject> tVEntryPoint = TVEntryPoints.ep(iPyroObject);
            cloneable = new ArrayList<IPyroObject>(iPyroObject.getMembers());
            for (ReplaceRecord replaceRecord : (List)entry.getValue()) {
                tVEntryPoint.remove(iPyroObject, replaceRecord.original);
                tVEntryPoint.add(iPyroObject, replaceRecord.replacement);
                cloneable.set(replaceRecord.index, replaceRecord.replacement);
                replaceRecord.swap();
            }
            tVEntryPoint.reorder(iPyroObject, (Collection<?>)((Object)cloneable));
        }
    }

    private static class ReplaceRecord {
        public IPyroObject original;
        public IPyroObject replacement;
        public int index;

        public ReplaceRecord(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
            this.original = iPyroObject;
            this.replacement = iPyroObject2;
            this.index = -1;
        }

        public void swap() {
            IPyroObject iPyroObject = this.original;
            this.original = this.replacement;
            this.replacement = iPyroObject;
        }
    }
}

