/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;

public class MirrorTask
extends TransformTask {
    private final ITransform d_xform;

    public MirrorTask(PyroMod pyroMod, Collection<? extends IPyroObject> collection, int n, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        super(pyroMod, collection, n);
        ITransform iTransform = TransformUtil.IDENTITY;
        if (unitDouble3 != null) {
            iTransform = iTransform.concatenate(TransformUtil.mirror(new Plane3d(0.0, 0.0, 1.0, -unitDouble3.getValue(Geometry.LU))));
        }
        if (unitDouble2 != null) {
            iTransform = iTransform.concatenate(TransformUtil.mirror(new Plane3d(0.0, 1.0, 0.0, -unitDouble2.getValue(Geometry.LU))));
        }
        if (unitDouble != null) {
            iTransform = iTransform.concatenate(TransformUtil.mirror(new Plane3d(1.0, 0.0, 0.0, -unitDouble.getValue(Geometry.LU))));
        }
        this.d_xform = iTransform;
    }

    @Override
    public ITransform getXFormForIteration(int n) {
        return this.d_xform;
    }
}

