/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import pyrosim.Intl;
import pyrosim.PyroMod;
import thunderheadeng.util.Task;

public class InsertAdditionalRecordsTask
implements Task {
    private final String d_toAdd;
    private final PyroMod d_pyroMod;

    public InsertAdditionalRecordsTask(PyroMod pyroMod, String string) {
        this.d_pyroMod = pyroMod;
        this.d_toAdd = string;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        if (this.d_toAdd.trim().length() == 0) {
            return;
        }
        String string = this.d_pyroMod.getUnprocessedRecords();
        if (string.contains(this.d_toAdd)) {
            String string2 = string.replace(this.d_toAdd, "");
            this.d_pyroMod.setUnprocessedRecords(string2);
            this.d_pyroMod.getEvents().changed(this.d_pyroMod, PyroMod.EVT_UNPROC_RECS_CHANGED);
        } else {
            System.out.println(Intl.intl("Unable to undo changes to modified additional records."));
        }
    }

    @Override
    public void run() {
        if (this.d_toAdd.trim().length() == 0) {
            return;
        }
        String string = this.d_pyroMod.getUnprocessedRecords();
        if (string.contains(this.d_toAdd)) {
            System.out.println("proposed unprocessed records already present in this model");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.length() > 0 && !string.endsWith(System.getProperty("line.separator"))) {
            stringBuilder.append(System.getProperty("line.separator"));
        }
        stringBuilder.append(this.d_toAdd);
        this.d_pyroMod.setUnprocessedRecords(stringBuilder.toString());
        this.d_pyroMod.getEvents().changed(this.d_pyroMod, PyroMod.EVT_UNPROC_RECS_CHANGED);
    }
}

