/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.tasks.InsertTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GroupGeomTask
extends CompositeTask<PyroMod> {
    public GroupGeomTask(PyroMod pyroMod, Collection<? extends IModelObj> collection, ConvertType convertType) {
        super(pyroMod);
        IModelObj iModelObj = convertType == ConvertType.GENERIC ? this.merge(theUtil.filter(collection, GenericGeomSrc.class)) : this.merge(theUtil.filter(collection, FDSObject.class), convertType);
        Pair<ModelComposite, Integer> pair = GroupGeomTask.getInsertInfo(collection);
        SelectTask selectTask = new SelectTask(pyroMod, iModelObj);
        selectTask.addTask(Tasks.delete(collection));
        selectTask.addTask(new InsertTask((IPyroObject)pair.v1, ((Integer)pair.v2).intValue(), new IPyroObject[]{iModelObj}));
        this.addTask(selectTask);
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<ModelComposite, Integer> getInsertInfo(Collection<? extends IModelObj> collection) {
        IPyroObject iPyroObject = Hierarchy.getCommonParent(collection);
        assert (iPyroObject instanceof ModelComposite);
        ModelComposite modelComposite = (ModelComposite)iPyroObject;
        IdentityHashMap<IPyroObject, Integer> identityHashMap = new IdentityHashMap<IPyroObject, Integer>();
        int n = 0;
        for (IPyroObject object : modelComposite.getMembers()) {
            identityHashMap.put(object, n++);
        }
        int n2 = modelComposite.getMembers().size();
        for (IPyroObject iPyroObject2 : collection) {
            void var7_9;
            IPyroObject iPyroObject3 = iPyroObject2.getParent();
            while (iPyroObject3 != null && iPyroObject3 != modelComposite) {
                IPyroObject iPyroObject4 = iPyroObject3;
                iPyroObject3 = iPyroObject4.getParent();
            }
            assert (iPyroObject3 == modelComposite);
            assert (identityHashMap.containsKey(var7_9));
            int n3 = (Integer)identityHashMap.get(var7_9);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return new Pair<ModelComposite, Integer>(modelComposite, n2);
    }

    private PyroMod getDomain() {
        return (PyroMod)this.getDomains().iterator().next();
    }

    private GenericGeomSrc merge(Collection<? extends GenericGeomSrc> collection) {
        assert (!collection.isEmpty());
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        NodesBuilder nodesBuilder = new NodesBuilder();
        PropsBuilder propsBuilder = new PropsBuilder();
        for (GenericGeomSrc genericGeomSrc : collection) {
            IGeomNode iGeomNode = genericGeomSrc.getGeom();
            int n = iGeomNode.getNumPrims(7);
            propsBuilder.add(genericGeomSrc.getDisplayProps(), n);
            nodesBuilder.add(iGeomNode, n);
        }
        IGeomNode iGeomNode = nodesBuilder.finish();
        return new GenericGeomSrc(collection.iterator().next().getName(), iGeomNode, propsBuilder.finalizeProps());
    }

    private FDSObject merge(Collection<? extends FDSObject> collection, ConvertType convertType) {
        IGeomNode iGeomNode;
        Surface surface = this.getDomain().getSurfaceMgr().get(PredefSurf.INERT);
        ArrayList<Surface> arrayList = new ArrayList<Surface>(collection.size());
        ArrayList<Color> arrayList2 = new ArrayList<Color>(collection.size());
        NodesBuilder nodesBuilder = new NodesBuilder();
        for (FDSObject surfaceArray2 : collection) {
            Surface[] surfaceArray;
            iGeomNode = surfaceArray2.getGeom();
            int n = iGeomNode.getNumPrims(1);
            Color[] colorArray = GroupGeomTask.flatten(Color.class, surfaceArray2.getColors(), surfaceArray2.getGeom().getNumPrims(7));
            if (surfaceArray2 instanceof IObstruction) {
                IObstruction i = (IObstruction)surfaceArray2;
                surfaceArray = GroupGeomTask.flatten(Surface.class, i.getSurfaces(), n);
            } else {
                surfaceArray = new Surface[n];
                for (int i = 0; i < surfaceArray.length; ++i) {
                    surfaceArray[i] = surface;
                }
            }
            arrayList.addAll(Arrays.asList(surfaceArray));
            arrayList2.addAll(Arrays.asList(colorArray));
            nodesBuilder.add(iGeomNode, n);
        }
        Color[] colorArray = GeomUtil.optimize(arrayList2.toArray(new Color[arrayList2.size()]));
        Surface[] surfaceArray = GeomUtil.optimize(arrayList.toArray(new Surface[arrayList.size()]));
        iGeomNode = nodesBuilder.finish().bakeIfRecommended();
        return convertType == ConvertType.OBSTRUCTION ? GroupGeomTask.convertToObst(collection, iGeomNode, colorArray, surfaceArray) : GroupGeomTask.convertToHole(collection, iGeomNode, colorArray);
    }

    private static IObstruction convertToObst(Collection<? extends FDSObject> collection, IGeomNode iGeomNode, Color[] colorArray, Surface[] surfaceArray) {
        IObstruction iObstruction;
        IFilteredCollection<IObstruction> iFilteredCollection = theUtil.filter(collection, IObstruction.class);
        if (!iFilteredCollection.isEmpty()) {
            IObstruction iObstruction2 = (IObstruction)iFilteredCollection.iterator().next();
            iObstruction = (IObstruction)iObstruction2.clone();
            iObstruction.setGeom(iGeomNode);
            iObstruction.setSurfaces(surfaceArray);
        } else {
            iObstruction = new Obstruction(Intl.intl("Obstruction"), iGeomNode, surfaceArray);
        }
        iObstruction.setColors(colorArray);
        return iObstruction;
    }

    private static IHole convertToHole(Collection<? extends FDSObject> collection, IGeomNode iGeomNode, Color[] colorArray) {
        IHole iHole;
        IFilteredCollection<IHole> iFilteredCollection = theUtil.filter(collection, IHole.class);
        if (!iFilteredCollection.isEmpty()) {
            IHole iHole2 = (IHole)iFilteredCollection.iterator().next();
            iHole = (IHole)iHole2.clone();
            iHole.setGeom(iGeomNode);
        } else {
            iHole = new Hole(Intl.intl("Hole"), iGeomNode);
        }
        iHole.setColors(colorArray);
        return iHole;
    }

    private static <T> T[] flatten(Class<T> clazz, T[] TArray, int n) {
        if (TArray.length == 1 && n != 1) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                objectArray[i] = TArray[0];
            }
            return objectArray;
        }
        assert (TArray.length == n);
        return TArray;
    }

    private static class NodesBuilder {
        private ArrayList<IGeomNode> nodes = new ArrayList();
        private NodeBuilder builder = null;

        private NodesBuilder() {
        }

        public void add(IGeomNode iGeomNode, int n) {
            if (!iGeomNode.getChildren().isEmpty()) {
                if (this.builder != null) {
                    this.nodes.add(this.builder.finish());
                }
                this.builder = null;
                this.nodes.add(iGeomNode);
                return;
            }
            if (this.builder != null && !this.builder.xform.equals(iGeomNode.getLocalTransform())) {
                this.nodes.add(this.builder.finish());
                this.builder = null;
            }
            if (this.builder == null) {
                this.builder = new NodeBuilder(iGeomNode.getLocalTransform());
            }
            this.builder.add(iGeomNode.getLocalGeom(), n, iGeomNode.getLocalElements());
        }

        public IGeomNode finish() {
            if (this.builder != null) {
                this.nodes.add(this.builder.finish());
            }
            if (this.nodes.size() == 1) {
                return this.nodes.get(0);
            }
            this.nodes.trimToSize();
            return GeomNodeUtil.newNode(this.nodes);
        }
    }

    private static class NodeBuilder {
        ITransform xform = null;
        ElementsBuilder elems = null;
        List<IGeom> geoms = null;

        public NodeBuilder(ITransform iTransform) {
            this.xform = iTransform;
            this.elems = new ElementsBuilder();
            this.geoms = new ArrayList<IGeom>();
        }

        public void add(IGeom iGeom, int n, IPropertySet iPropertySet) {
            this.geoms.add(iGeom);
            this.elems.add(iPropertySet, n);
        }

        public IGeomNode finish() {
            return GeomNodeUtil.newNode(this.xform, GeomUtil.group(this.geoms), this.elems.finish());
        }
    }

    public static enum ConvertType {
        HOLE,
        OBSTRUCTION,
        GENERIC;

    }
}

