/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IPropertySet;

public class ExplodeTask
extends CompositeTask<PyroMod> {
    public ExplodeTask(PyroMod pyroMod, Collection<? extends IModelObj> collection) {
        super(pyroMod);
        ObstDecorator obstDecorator = new ObstDecorator();
        EmptyDecorator emptyDecorator = new EmptyDecorator();
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        ArrayList<IModelObj> arrayList2 = new ArrayList<IModelObj>();
        for (IModelObj iModelObj : collection) {
            IPyroObject iPyroObject;
            List<IGeomNode> list = ExplodeTask.explodeGeom(iModelObj);
            if (list == null) continue;
            List<IModelObj> list2 = Collections.EMPTY_LIST;
            if (iModelObj instanceof IObstruction) {
                list2 = ExplodeTask.explodeFDSObject((IObstruction)iModelObj, list, obstDecorator);
            } else if (iModelObj instanceof IHole) {
                list2 = ExplodeTask.explodeFDSObject((IHole)iModelObj, list, emptyDecorator);
            } else if (iModelObj instanceof GenericGeomSrc) {
                list2 = ExplodeTask.explode((GenericGeomSrc)iModelObj, list);
            }
            if (list2.size() == 1) {
                iPyroObject = list2.get(0);
            } else {
                ModelComposite modelComposite = new ModelComposite(iModelObj.getName());
                modelComposite.addAll(list2);
                iPyroObject = modelComposite;
            }
            arrayList2.add(iModelObj);
            arrayList.add(iPyroObject);
        }
        if (!arrayList.isEmpty()) {
            SelectTask selectTask = new SelectTask(pyroMod, arrayList);
            selectTask.addTask(Tasks.replace(arrayList2, arrayList, true));
            this.addTask(selectTask);
        }
    }

    private static List<GenericGeomSrc> explode(GenericGeomSrc genericGeomSrc, List<IGeomNode> list) {
        IPropsSrc iPropsSrc = genericGeomSrc.getDisplayProps();
        ArrayList<GenericGeomSrc> arrayList = new ArrayList<GenericGeomSrc>(list.size());
        int n = 0;
        for (IGeomNode iGeomNode : list) {
            int n2 = iGeomNode.getNumPrims(7);
            PropsBuilder propsBuilder = new PropsBuilder();
            propsBuilder.add(iPropsSrc.subset(n, n2), n2);
            IPropsSrc iPropsSrc2 = propsBuilder.finalizeProps();
            GenericGeomSrc genericGeomSrc2 = (GenericGeomSrc)genericGeomSrc.clone();
            genericGeomSrc2.setGeom(iGeomNode.bakeIfRecommended());
            genericGeomSrc2.setDisplayProps(iPropsSrc2);
            arrayList.add(genericGeomSrc2);
            n += n2;
        }
        return arrayList;
    }

    private static <T extends FDSObject> List<T> explodeFDSObject(T t, List<IGeomNode> list, Decorator<T> decorator) {
        Color[] colorArray = t.getColors();
        int n = 0;
        decorator.begin(t);
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>(list.size());
        for (IGeomNode iGeomNode : list) {
            int n2 = iGeomNode.getNumPrims(7);
            Color[] colorArray2 = ExplodeTask.subArray(colorArray, n, n2);
            colorArray2 = GeomUtil.optimize(colorArray2);
            n += n2;
            FDSObject fDSObject = (FDSObject)t.clone();
            fDSObject.setGeom(iGeomNode.bakeIfRecommended());
            fDSObject.setColors(colorArray2);
            decorator.decorateNext(fDSObject);
            arrayList.add(fDSObject);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static List<IGeomNode> explodeGeom(IPyroGeomSrc iPyroGeomSrc) {
        boolean bl;
        IGeomNode iGeomNode = iPyroGeomSrc.getGeom();
        boolean bl2 = bl = iGeomNode.getLocalGeom() instanceof GeomGroup && iGeomNode.getLocalGeom().canExplode();
        if (!bl && iGeomNode.getChildren().isEmpty()) {
            return null;
        }
        ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>();
        TransformInfo transformInfo = iGeomNode.getLocalTransform().getInfo();
        IPropertySet iPropertySet = iGeomNode.getLocalElements();
        if (bl) {
            ArrayList arrayList2 = new ArrayList();
            iGeomNode.getLocalGeom().explode(arrayList2);
            boolean n = false;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                void iGeomNode2;
                IGeom iGeom = (IGeom)iterator.next();
                int n2 = iGeom.getNumPrims(7);
                ElementsBuilder elementsBuilder = new ElementsBuilder();
                elementsBuilder.addRange(iPropertySet, (int)iGeomNode2, n2);
                GeomNodeLeaf geomNodeLeaf = GeomNodeUtil.newNode(transformInfo.xform, iGeom, elementsBuilder.finish());
                arrayList.add(geomNodeLeaf);
                iGeomNode2 += n2;
            }
        }
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            arrayList.add(iGeomNode2.transform(transformInfo));
        }
        return arrayList;
    }

    private static <T> T[] subArray(T[] TArray, int n, int n2) {
        if (TArray.length == 1) {
            return TArray;
        }
        return Arrays.copyOfRange(TArray, n, n + n2);
    }

    private static class EmptyDecorator<T extends FDSObject>
    implements Decorator<T> {
        private EmptyDecorator() {
        }

        @Override
        public void begin(T t) {
        }

        @Override
        public void decorateNext(T t) {
        }
    }

    private static class ObstDecorator
    implements Decorator<IObstruction> {
        private Surface[] d_surfs;
        private int d_surfIx;

        private ObstDecorator() {
        }

        @Override
        public void begin(IObstruction iObstruction) {
            this.d_surfs = iObstruction.getSurfaces();
            this.d_surfIx = 0;
        }

        @Override
        public void decorateNext(IObstruction iObstruction) {
            int n = iObstruction.getGeom().getNumPrims(1);
            Surface[] surfaceArray = (Surface[])ExplodeTask.subArray(this.d_surfs, this.d_surfIx, n);
            surfaceArray = GeomUtil.optimize(surfaceArray);
            this.d_surfIx += n;
            iObstruction.setSurfaces(surfaceArray);
        }
    }

    private static interface Decorator<T extends FDSObject> {
        public void begin(T var1);

        public void decorateNext(T var1);
    }
}

