/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;

public class DeleteTask
extends AUndoableTask {
    private IPyroObject[] d_deletions;

    public DeleteTask(IPyroObject ... iPyroObjectArray) {
        this(Arrays.asList(iPyroObjectArray));
    }

    public DeleteTask(Collection<? extends IPyroObject> collection) {
        this.d_deletions = new IPyroObject[collection.size() * 2];
        int n = 0;
        for (IPyroObject iPyroObject : collection) {
            this.d_deletions[n++] = iPyroObject.getParent();
            this.d_deletions[n++] = iPyroObject;
        }
    }

    private PyroMod getDomain() {
        return this.d_deletions.length == 0 ? null : (PyroMod)this.d_deletions[0].getDomain();
    }

    private void pauseUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.pauseUpdates();
        }
    }

    private void resumeUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        int n = this.d_deletions.length - 1;
        while (n >= 0) {
            IPyroObject iPyroObject = this.d_deletions[n--];
            IPyroObject iPyroObject2 = this.d_deletions[n--];
            boolean bl = TVEntryPoints.ep(iPyroObject2).add(iPyroObject2, iPyroObject);
            assert (bl);
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        int n = 0;
        while (n < this.d_deletions.length) {
            IPyroObject iPyroObject = this.d_deletions[n++];
            IPyroObject iPyroObject2 = this.d_deletions[n++];
            boolean bl = TVEntryPoints.ep(iPyroObject).remove(iPyroObject, iPyroObject2);
            assert (bl);
        }
        this.resumeUpdates();
    }
}

