/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.View;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;

public class AddTask<V extends IPyroObject>
extends AUndoableTask {
    private final Object d_objs;
    private final IPyroObject d_parent;
    private View d_prevActiveView;

    public AddTask(IPyroObject iPyroObject, V ... VArray) {
        this(iPyroObject, (Collection<V>)Arrays.asList(VArray));
    }

    public AddTask(IPyroObject iPyroObject, Collection<? extends V> collection) {
        this.d_parent = iPyroObject;
        this.d_objs = collection.size() == 1 ? collection.iterator().next() : new ArrayList<V>(collection);
    }

    public List<? extends V> getObjects() {
        return this.d_objs instanceof ArrayList ? (ArrayList)this.d_objs : Arrays.asList((IPyroObject)this.d_objs);
    }

    protected PyroMod getDomain() {
        return (PyroMod)this.d_parent.getDomain();
    }

    protected IPyroObject getParent() {
        return this.d_parent;
    }

    protected void pauseUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        List<V> list = this.getObjects();
        for (int i = list.size() - 1; i >= 0; --i) {
            this.remove(this.d_parent, (IPyroObject)list.get(i));
        }
        if (this.d_prevActiveView != null) {
            this.getDomain().getViews().setActiveView(this.d_prevActiveView);
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        if (this.d_prevActiveView == null && this.getDomain() != null && !Hierarchy.flatten(this.getObjects(), View.class).isEmpty()) {
            this.d_prevActiveView = this.getDomain().getViews().getActiveView();
        }
        for (IPyroObject iPyroObject : this.getObjects()) {
            this.add(this.d_parent, iPyroObject);
        }
        this.resumeUpdates();
    }

    protected void remove(IPyroObject iPyroObject, V v) {
        TVEntryPoints.ep(this.d_parent).remove(this.d_parent, v);
    }

    protected void add(IPyroObject iPyroObject, V v) {
        boolean bl = TVEntryPoints.ep(this.d_parent).add(this.d_parent, v);
        assert (bl);
    }
}

