/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import java.util.List;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.InsertTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Pair;

public class AddGridBoundaryVentsTask
extends CompositeTask<PyroMod> {
    private static final String GRID_BOUNDARY_VENT_PARENT = Intl.intl("Mesh Boundary Vents");

    public AddGridBoundaryVentsTask(PyroMod pyroMod, List<Pair<Grid, List<Vent>>> list) {
        super(pyroMod);
        ModelComposite modelComposite = this.findComposite(pyroMod.getObstructions(), GRID_BOUNDARY_VENT_PARENT, 0);
        for (Pair<Grid, List<Vent>> pair : list) {
            String string = String.format(Intl.intl("Vents for %s"), ((Grid)pair.v1).getName());
            ModelComposite modelComposite2 = this.findComposite(modelComposite, string, null);
            this.addTask(new AddTask((IPyroObject)modelComposite2, (Collection)pair.v2));
        }
    }

    private ModelComposite findComposite(ModelComposite modelComposite, String string, Integer n) {
        ModelComposite modelComposite2 = modelComposite.find(string, ModelComposite.class, false);
        if (modelComposite2 == null) {
            modelComposite2 = new ModelComposite(string);
            if (n != null) {
                this.addTask(new InsertTask((IPyroObject)modelComposite, n.intValue(), new IPyroObject[]{modelComposite2}));
            } else {
                this.addTask(new AddTask((IPyroObject)modelComposite, new IPyroObject[]{modelComposite2}));
            }
        }
        return modelComposite2;
    }
}

