/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.signals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jscience.physics.units.Unit;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;

public class Util {
    public static IOutPin getPin(ISignalSource iSignalSource, String string) {
        for (IOutPin iOutPin : iSignalSource.getOutputPins()) {
            if (!iOutPin.getName().equals(string)) continue;
            return iOutPin;
        }
        return null;
    }

    public static boolean areCompatible(Unit unit, Unit unit2) {
        if (!unit.isCompatible(unit2)) {
            return false;
        }
        try {
            return unit.getConverterTo(unit2) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Collection<IInPin> getInputPins(Iterator<? extends ISignalSink> iterator) {
        ArrayList<IInPin> arrayList = new ArrayList<IInPin>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getInputPin());
        }
        return arrayList;
    }

    public static boolean isCycle(ISignalSink iSignalSink) {
        return Util.containsCycleImpl(iSignalSink, new ISignalSink[0]);
    }

    public static boolean containsCycle(ISignalSink iSignalSink, ISignalSink iSignalSink2) {
        return Util.containsCycleImpl(iSignalSink2, iSignalSink);
    }

    private static boolean containsCycleImpl(ISignalSink iSignalSink, ISignalSink ... iSignalSinkArray) {
        ArrayDeque<ISignalSink> arrayDeque = new ArrayDeque<ISignalSink>();
        HashSet<ISignalSink> hashSet = new HashSet<ISignalSink>(Arrays.asList(iSignalSinkArray));
        arrayDeque.push(iSignalSink);
        while (!arrayDeque.isEmpty()) {
            ISignalSink iSignalSink2 = (ISignalSink)arrayDeque.pop();
            if (!hashSet.add(iSignalSink2)) {
                return true;
            }
            IInPin iInPin = iSignalSink2.getInputPin();
            for (ISignalSource iSignalSource : iInPin.getConnectedSources()) {
                if (!(iSignalSource instanceof ISignalSink)) continue;
                arrayDeque.push((ISignalSink)((Object)iSignalSource));
            }
        }
        return false;
    }
}

