/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;

public class ReactionList
extends Composite<Reaction>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private List<Reaction> d_changes;
    @Deprecated
    private boolean d_trackChanges;
    @Deprecated
    private transient List<Reaction> d_reactionsBeforePaste;
    @Deprecated
    private transient Reaction d_activeReacBeforePaste;

    public ReactionList() {
        this(Intl.intl("Reactions"));
        this.d_trackChanges = false;
        this.d_changes = null;
    }

    public ReactionList(String string) {
        super(string, Reaction.class);
    }

    @Deprecated
    public Reaction getActiveReaction() {
        for (Reaction reaction : this.flatten()) {
            if (!reaction.isActive()) continue;
            return reaction;
        }
        return null;
    }

    public List<Reaction> getActiveReactions() {
        return this.flatten().stream().filter(reaction -> reaction.isActive()).collect(Collectors.toList());
    }

    public Task taskSetActiveReaction(final Reaction reaction) {
        final List<Reaction> list = this.getActiveReactions();
        final ArrayList arrayList = new ArrayList();
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                if (!arrayList.isEmpty()) {
                    ReactionList.this.setActiveReactionList(arrayList);
                } else {
                    ReactionList.this.setActiveReaction(reaction);
                    arrayList.addAll(ReactionList.this.getActiveReactions());
                }
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(list);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    public Task taskClearActiveReaction(final Reaction reaction) {
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                reaction.setActive(false);
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReaction(reaction);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    public Task taskSetActiveReactions(final List<Reaction> list) {
        final List<Reaction> list2 = this.getActiveReactions();
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(list);
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(list2);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    private void setActiveReactionList(Collection<Reaction> collection) {
        this.clearActiveReactionList();
        for (Reaction reaction : collection) {
            reaction.setActive(true);
        }
    }

    private void clearActiveReactionList() {
        for (Reaction reaction : this.flatten()) {
            reaction.setActive(false);
        }
    }

    public void setActiveReaction(Reaction reaction2) {
        List list;
        List<Reaction> list2 = this.getActiveReactions();
        if (reaction2.getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
            for (Reaction reaction3 : list2) {
                reaction3.setActive(false);
            }
        } else if (reaction2.getReacType().equals((Object)Reaction.ReacType.COMPLEX) && (list = list2.stream().map(reaction -> reaction.getReacType()).distinct().collect(Collectors.toList())).contains((Object)Reaction.ReacType.SIMPLE)) {
            for (Reaction reaction4 : list2) {
                reaction4.setActive(false);
            }
        }
        reaction2.setActive(true);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append(Arrays.toString(this.getMembers().toArray()));
        return stringBuffer.toString();
    }

    @Override
    public boolean add(IPyroObject iPyroObject) {
        if (!(iPyroObject instanceof Reaction) && !(iPyroObject instanceof ReactionList)) {
            throw new IllegalArgumentException(iPyroObject.getClass().getName());
        }
        if (super.add(iPyroObject)) {
            if (iPyroObject instanceof Reaction) {
                ((Reaction)iPyroObject).setActive(false);
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

