/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Reaction
extends NamedPyroObject
implements Serializable,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final VariantProfile AUTO_IGNIT_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 1, null));
    public static final VariantProfile HEAT_OF_COMB_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 48, null));
    public static final VariantProfile HRRPUA_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 22, null));
    public static final VariantProfile HRRPUV_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 25, null));
    public static final VariantProfile RADIATIVE_FRAC_PROF = new VariantProfile(new DefaultProfile(Intl.intl("Default")), new ConstProfile(Intl.intl("Constant"), 28, SIUS.newud(0.35, 28)));
    private String d_fyi;
    private boolean d_active;
    private ReacType d_type;
    private ExSpec d_fuel;
    private double d_H;
    private double d_C;
    private double d_O;
    private double d_N;
    private UnitDouble d_ambMassFracO2;
    private UnitDouble d_ambMassFracCO2;
    private boolean d_suppression;
    private Variant d_autoIgnitionTemp;
    private UnitDouble d_critFlameTemp;
    private UnitDouble d_hrrpuaSheet;
    private UnitDouble d_hrrpuvAvg;
    private double d_coYield;
    private double d_sootYield;
    private EnergyRelease d_energyType;
    private UnitDouble d_epumo2;
    private Variant d_heatOfCombustion;
    private boolean d_ideal;
    private Variant d_radiativeFraction;
    private double d_sootHFraction;
    private Map<ExSpec, Double> d_stoichiometryMap;
    private CustomFDSProps d_customFDSProps;
    private boolean d_isPredefined;

    public Reaction(String string, ReacType reacType) {
        this(string, false, reacType);
    }

    public Reaction(String string, boolean bl, ReacType reacType) {
        super(string);
        this.d_type = reacType;
        this.d_isPredefined = bl;
        this.setFuel(null);
        this.setFuelComp(0.0, 0.0, 0.0, 0.0);
        this.setSuppression(true);
        this.setCritFlameTemp(new UnitDouble(1427.0, SI.CELSIUS));
        this.d_autoIgnitionTemp = AUTO_IGNIT_PROF.getDefault();
        this.setHrrpuaSheet(new UnitDouble(200.0, SI.KILO(SI.WATT).divide(SI.METER.pow(2))));
        this.setHrrpuvAvg(new UnitDouble(2500.0, SI.KILO(SI.WATT).divide(SI.METER.pow(3))));
        this.setYields(0.0, 0.0);
        this.setEpumo2(new UnitDouble(13100.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM)));
        this.d_heatOfCombustion = HEAT_OF_COMB_PROF.getDefault();
        this.setEnergyType(EnergyRelease.EPUMO2);
        this.setIdeal(false);
        this.setSootHFraction(0.1);
        this.d_radiativeFraction = RADIATIVE_FRAC_PROF.getDefault();
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
    }

    public boolean isFirst(ReactionList reactionList) {
        return reactionList.flatten().isEmpty() || reactionList.flatten().size() == 1 && reactionList.flatten().iterator().next() == this;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("REAC");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Reaction)) {
            return false;
        }
        Reaction reaction = (Reaction)object;
        return super.equals(object) && this.d_customFDSProps.equals(reaction.d_customFDSProps);
    }

    public void imprint(Reaction reaction) {
        this.setFYI(reaction.getFYI());
        this.setReacType(reaction.getReacType());
        this.setYields(reaction.getCOYield(), reaction.getSootYield());
        this.setFuelComp(reaction.getH(), reaction.getC(), reaction.getO(), reaction.getN());
        if (reaction.getAutoIgnitionTemp().isConstant()) {
            this.setAutoIgnitionTemp((UnitDouble)reaction.getAutoIgnitionTemp().val);
        }
        this.setCritFlameTemp(reaction.getCritFlameTemp());
        this.setEpumo2(reaction.getEpumo2());
        this.setEnergyType(reaction.getEnergyType());
        this.setFuel(reaction.getFuel());
        if (reaction.getHeatOfCombustion().isConstant()) {
            this.setHeatOfCombustion((UnitDouble)reaction.getHeatOfCombustion().val);
        }
        this.setHrrpuaSheet(reaction.getHrrpuaSheet());
        this.setHrrpuvAvg(reaction.getHrrpuvAvg());
        this.setIdeal(reaction.isIdeal());
        if (reaction.getRadiativeFraction().isConstant()) {
            this.setRadiativeFraction((UnitDouble)reaction.getRadiativeFraction().val);
        }
        this.setSootHFraction(reaction.getSootHFraction());
        this.setSuppression(reaction.allowSuppression());
        this.setComplexStoichiometry(reaction.getComplexStoichiometry());
        this.setCustomFDSProps(reaction.getCustomFDSProps());
        this.changedEvt(new Object[0]);
    }

    public boolean isActive() {
        return this.d_active;
    }

    public void setActive(boolean bl) {
        this.d_active = bl;
        this.changedEvt(new Object[0]);
    }

    public boolean isPredefined() {
        return this.d_isPredefined;
    }

    public ExSpec getFuel() {
        return this.d_fuel;
    }

    public void setFuel(ExSpec exSpec) {
        this.d_fuel = exSpec;
    }

    public void setFuelComp(double d, double d2, double d3, double d4) {
        this.setH(d);
        this.setC(d2);
        this.setO(d3);
        this.setN(d4);
    }

    public double getH() {
        return this.d_H;
    }

    public void setH(double d) {
        this.d_H = d;
    }

    public double getC() {
        return this.d_C;
    }

    public void setC(double d) {
        this.d_C = d;
    }

    public double getO() {
        return this.d_O;
    }

    public void setO(double d) {
        this.d_O = d;
    }

    public double getN() {
        return this.d_N;
    }

    public void setN(double d) {
        this.d_N = d;
    }

    public boolean allowSuppression() {
        return this.d_suppression;
    }

    public void setSuppression(boolean bl) {
        this.d_suppression = bl;
    }

    public Variant getAutoIgnitionTemp() {
        return this.d_autoIgnitionTemp;
    }

    public void setAutoIgnitionTemp(UnitDouble unitDouble) {
        this.d_autoIgnitionTemp = Variant.constant(unitDouble);
    }

    public UnitDouble getCritFlameTemp() {
        return this.d_critFlameTemp;
    }

    public void setCritFlameTemp(UnitDouble unitDouble) {
        this.d_critFlameTemp = unitDouble;
    }

    public UnitDouble getHrrpuaSheet() {
        return this.d_hrrpuaSheet;
    }

    public void setHrrpuaSheet(UnitDouble unitDouble) {
        this.d_hrrpuaSheet = unitDouble;
    }

    public UnitDouble getHrrpuvAvg() {
        return this.d_hrrpuvAvg;
    }

    public void setHrrpuvAvg(UnitDouble unitDouble) {
        this.d_hrrpuvAvg = unitDouble;
    }

    public Variant getRadiativeFraction() {
        return this.d_radiativeFraction;
    }

    public void setRadiativeFraction(UnitDouble unitDouble) {
        this.d_radiativeFraction = unitDouble == null ? RADIATIVE_FRAC_PROF.getDefault() : Variant.constant(unitDouble);
    }

    public void setYields(double d, double d2) {
        this.setCOYield(d);
        this.setSootYield(d2);
    }

    public double getCOYield() {
        return this.d_coYield;
    }

    public void setCOYield(double d) {
        this.d_coYield = d;
    }

    public double getSootYield() {
        return this.d_sootYield;
    }

    public void setSootYield(double d) {
        this.d_sootYield = d;
    }

    public double getSootHFraction() {
        return this.d_sootHFraction;
    }

    public void setSootHFraction(double d) {
        this.d_sootHFraction = d;
    }

    public EnergyRelease getEnergyType() {
        return this.d_energyType;
    }

    public void setEnergyType(EnergyRelease energyRelease) {
        this.d_energyType = energyRelease;
    }

    public UnitDouble getEpumo2() {
        return this.d_epumo2;
    }

    public void setEpumo2(UnitDouble unitDouble) {
        this.d_epumo2 = unitDouble;
    }

    public Variant getHeatOfCombustion() {
        return this.d_heatOfCombustion;
    }

    public void setHeatOfCombustion(UnitDouble unitDouble) {
        if (unitDouble == null) {
            this.d_heatOfCombustion = Variant.DEFAULT;
            this.d_energyType = EnergyRelease.EPUMO2;
            this.setEpumo2(new UnitDouble(13100.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM)));
        } else {
            this.d_heatOfCombustion = Variant.constant(unitDouble);
        }
    }

    public boolean isIdeal() {
        return this.d_ideal;
    }

    public void setIdeal(boolean bl) {
        this.d_ideal = bl;
    }

    public ReacType getReacType() {
        return this.d_type;
    }

    public void setReacType(ReacType reacType) {
        this.d_type = reacType;
    }

    public Map<ExSpec, Double> getComplexStoichiometry() {
        return this.d_stoichiometryMap;
    }

    public void setComplexStoichiometry(Map<ExSpec, Double> map) {
        this.d_stoichiometryMap = map;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        if (this.getReacType().equals((Object)ReacType.SIMPLE)) {
            depList.add(DLink.REQUIRED, (IPyroObject)this.d_fuel);
        } else if (this.getReacType().equals((Object)ReacType.COMPLEX)) {
            for (ExSpec exSpec : this.d_stoichiometryMap.keySet()) {
                depList.add(DLink.WEAK, (IPyroObject)exSpec);
            }
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            if (this.getReacType().equals((Object)ReacType.SIMPLE)) {
                Util.keepIfNullOr(set, ExSpec.class);
            } else if (this.getReacType().equals((Object)ReacType.COMPLEX)) {
                Util.keepIf(set, iPyroObject -> iPyroObject instanceof ExSpec && !this.d_stoichiometryMap.containsKey(iPyroObject));
            }
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){
                private boolean isFuel;
                private boolean isChem;
                {
                    super(object, object2);
                    this.isFuel = theUtil.equal(Reaction.this.getFuel(), iPyroObject);
                    this.isChem = Reaction.this.getComplexStoichiometry().containsKey(iPyroObject);
                }

                @Override
                protected void set(ExSpec exSpec) {
                    ExSpec exSpec2;
                    ExSpec exSpec3 = exSpec2 = exSpec == null ? ExSpecList.getDefaultFuel(true) : exSpec;
                    if (this.isFuel) {
                        Reaction.this.setFuel(exSpec2);
                    }
                    if (this.isChem) {
                        ExSpec exSpec4 = theUtil.equal(iPyroObject, exSpec) ? (ExSpec)iPyroObject2 : (ExSpec)iPyroObject;
                        Double d = Reaction.this.getComplexStoichiometry().get(exSpec4);
                        if (d == null) {
                            return;
                        }
                        Reaction.this.getComplexStoichiometry().remove(exSpec4);
                        Reaction.this.getComplexStoichiometry().put(exSpec, d);
                    }
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public String toString() {
        String string = this.d_fuel != null ? this.d_fuel.getName() : "null";
        return String.format("%s[name=%s,active=%s,predefined=%s,fuel=%s]", this.getClass().getSimpleName(), this.getName(), this.isActive(), this.isPredefined(), string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_type == null) {
            this.d_type = ReacType.SIMPLE;
        }
        if (this.d_stoichiometryMap == null) {
            this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
        }
    }

    public static enum ReacType {
        SIMPLE(Intl.intl("Simple Chemistry")),
        COMPLEX(Intl.intl("Complex Stoichiometry"));

        public final String id;

        private ReacType(String string2) {
            this.id = string2;
        }
    }

    public static enum EnergyRelease {
        EPUMO2,
        HEAT_OF_COMBUSTION;

    }
}

