/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.awt.Color;
import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.theUtil;

public class ObstFragGenerator
implements IFragGenerator<IObstruction> {
    private final RasterizationOptions d_options;
    public final IObstruction src;

    public ObstFragGenerator(IObstruction iObstruction, RasterizationOptions rasterizationOptions) {
        this.src = iObstruction;
        this.d_options = rasterizationOptions;
    }

    public int hashCode() {
        return this.src.getSetOptions() + theUtil.hashCode(this.src.isVisible()) + theUtil.hashCode(this.src.isEnabled()) + System.identityHashCode(this.getSignalSource(this.src)) + this.src.getTextureOrigin().hashCode() + theUtil.hashCode(this.src.getBulkDensity()) + this.src.getEvac().hashCode() + (this.d_options.ignoreMergeNames ? 0 : this.src.getName().hashCode());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObstFragGenerator)) {
            return false;
        }
        ObstFragGenerator obstFragGenerator = (ObstFragGenerator)object;
        return this.src.getSetOptions() == obstFragGenerator.src.getSetOptions() && this.src.isVisible() == obstFragGenerator.src.isVisible() && this.src.isEnabled() == obstFragGenerator.src.isEnabled() && this.getSignalSource(this.src) == this.getSignalSource(obstFragGenerator.src) && this.src.getTextureOrigin().equals(obstFragGenerator.src.getTextureOrigin()) && theUtil.equal(this.src.getBulkDensity(), obstFragGenerator.src.getBulkDensity()) && this.src.getEvac().equals(obstFragGenerator.src.getEvac()) && (this.d_options.ignoreMergeNames || this.src.getName().equals(obstFragGenerator.src.getName()));
    }

    @Override
    public IGeom transformGeom(IGeom iGeom) {
        return iGeom;
    }

    public IObstruction getOriginatingObj() {
        return this.src;
    }

    public int getOptions() {
        return this.src.getSetOptions();
    }

    public TexOrigin getTextureOrigin() {
        return this.src.getTextureOrigin();
    }

    public IOutPin getSignalSource() {
        return this.getSignalSource(this.src);
    }

    private IOutPin getSignalSource(ISignalSink iSignalSink) {
        Set<? extends IOutPin> set = iSignalSink.getInputPin().getConnections();
        return set.isEmpty() ? null : set.iterator().next();
    }

    @Override
    public IObstruction generateFrag(IGeom iGeom, FaceProps[] facePropsArray) {
        Surface[] surfaceArray;
        Color[] colorArray;
        if (facePropsArray.length == 1) {
            colorArray = new Color[]{facePropsArray[0].color};
            surfaceArray = new Surface[]{facePropsArray[0].surface};
        } else {
            int n = iGeom.getNumPrims(1);
            assert (facePropsArray.length == n);
            colorArray = new Color[n];
            surfaceArray = new Surface[n];
            for (int i = 0; i < n; ++i) {
                FaceProps faceProps = facePropsArray[i];
                surfaceArray[i] = faceProps.surface;
                colorArray[i] = faceProps.color;
            }
            if (GeomUtil.isUniform(surfaceArray)) {
                surfaceArray = new Surface[]{surfaceArray[0]};
            }
            if (GeomUtil.isUniform(colorArray)) {
                colorArray = new Color[]{colorArray[0]};
            }
        }
        Obstruction obstruction = new Obstruction(this.src.getName(), GeomNodeUtil.newNode(iGeom), surfaceArray);
        obstruction.setColors(colorArray);
        obstruction.setVisible(this.src.isVisible());
        obstruction.setOptions(this.src.getSetOptions(), true);
        obstruction.setOptions(~this.src.getSetOptions(), false);
        obstruction.setTextureOrigin(this.src.getTextureOrigin());
        IOutPin iOutPin = this.getSignalSource();
        if (iOutPin != null) {
            obstruction.getInputPin().connect(iOutPin);
        }
        obstruction.setBulkDensity(this.src.getBulkDensity());
        obstruction.setEvac(this.src.getEvac());
        return obstruction;
    }

    @Override
    public IPrimProps generateDisplayProps(FaceProps faceProps) {
        return FDSUtil.newObstFaceProps(faceProps.color, faceProps.surface, 2);
    }
}

