/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.awt.Color;
import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.theUtil;

public class HoleFragGenerator
implements IFragGenerator<IHole> {
    private final RasterizationOptions d_options;
    public final IHole src;

    public HoleFragGenerator(IHole iHole, RasterizationOptions rasterizationOptions) {
        this.d_options = rasterizationOptions;
        this.src = iHole;
    }

    public int hashCode() {
        return theUtil.hashCode(this.src.isVisible()) + theUtil.hashCode(this.src.isEnabled()) + System.identityHashCode(this.getSignalSource(this.src)) + this.src.getEvac().hashCode() + (this.d_options.ignoreMergeNames ? 0 : this.src.getName().hashCode());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HoleFragGenerator)) {
            return false;
        }
        HoleFragGenerator holeFragGenerator = (HoleFragGenerator)object;
        return this.src.isVisible() == holeFragGenerator.src.isVisible() && this.src.isEnabled() == holeFragGenerator.src.isEnabled() && this.getSignalSource(this.src) == this.getSignalSource(holeFragGenerator.src) && this.src.getEvac().equals(holeFragGenerator.src.getEvac()) && (this.d_options.ignoreMergeNames || this.src.getName().equals(holeFragGenerator.src.getName()));
    }

    @Override
    public IGeom transformGeom(IGeom iGeom) {
        return iGeom;
    }

    @Override
    public IPrimProps generateDisplayProps(FaceProps faceProps) {
        Color color = faceProps.color;
        color = color == null ? Hole.DEF_COLOR : new Color(color.getRed(), color.getGreen(), color.getBlue(), 102);
        return new IPrimProps.Face(color, null, 2);
    }

    public IOutPin getSignalSource() {
        return this.getSignalSource(this.src);
    }

    private IOutPin getSignalSource(ISignalSink iSignalSink) {
        Set<? extends IOutPin> set = iSignalSink.getInputPin().getConnections();
        return set.isEmpty() ? null : set.iterator().next();
    }

    @Override
    public IHole generateFrag(IGeom iGeom, FaceProps[] facePropsArray) {
        Color[] colorArray;
        Hole hole = new Hole(this.src.getName(), GeomNodeUtil.newNode(iGeom));
        if (facePropsArray.length == 1) {
            colorArray = new Color[]{facePropsArray[0].color};
        } else {
            int n = iGeom.getNumPrims(1);
            colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                FaceProps faceProps = facePropsArray[i];
                colorArray[i] = faceProps.color;
            }
            if (GeomUtil.isUniform(colorArray)) {
                colorArray = new Color[]{colorArray[0]};
            }
        }
        hole.setColors(colorArray);
        hole.setVisible(this.src.isVisible());
        IOutPin iOutPin = this.getSignalSource();
        if (iOutPin != null) {
            hole.getInputPin().connect(iOutPin);
        }
        hole.setEvac(this.src.getEvac());
        return hole;
    }
}

