/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.Geometry;
import pyrosim.geom.Util;
import pyrosim.geom.rasterization.IRaster3D;
import pyrosim.geom.rasterization.Raster3D_V2;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.AdjacencyMerger;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.MergedCell;
import thunderheadeng.util.Pair;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.theUtil;

public class FDSRasterization {
    private static final int INTERIOR_GROUP = -1;
    private final PyroMod d_domain;
    private final Map<Grid, IRaster3D> d_gridRasterMap = new LinkedIdentityHashMap<Grid, IRaster3D>();
    private static final theUtil.DoubleComparator s_gridAlignComp = new theUtil.DoubleComparator(){

        @Override
        public int compare(double d, double d2) {
            return theUtil.compare(d2, d, 1.0E-6);
        }
    };

    public FDSRasterization(PyroMod pyroMod) {
        this.d_domain = pyroMod;
    }

    public FDSRasterization(PyroMod pyroMod, Collection<? extends Grid> collection) {
        this(pyroMod);
        this.addRasters(collection);
    }

    private static IRaster3D createRaster(double[] dArray, double[] dArray2, double[] dArray3) {
        return new Raster3D_V2(dArray, dArray2, dArray3);
    }

    public RasterizationOptions getRastOptions() {
        return this.d_domain.getRastOptions();
    }

    private SortCache<FaceProps> getFaceProps(Collection<? extends FDSObject> collection) {
        LinkedHashSet<FaceProps> linkedHashSet = new LinkedHashSet<FaceProps>();
        for (FDSObject fDSObject : collection) {
            IFDSObjProps iFDSObjProps = this.retrieveRasterProps(fDSObject, this.d_gridRasterMap.values());
            if (iFDSObjProps == null) continue;
            int n = fDSObject.getGeom().getNumPrims(1);
            for (int i = 0; i < n; ++i) {
                linkedHashSet.add(iFDSObjProps.getFace(i));
            }
        }
        return new SortCache<FaceProps>(linkedHashSet, false);
    }

    public FDSObjectRasterization rasterize(FDSObject fDSObject) {
        FDSObjectRasterization[] fDSObjectRasterizationArray = this.rasterize(Arrays.asList(fDSObject));
        return fDSObjectRasterizationArray.length > 0 ? fDSObjectRasterizationArray[0] : null;
    }

    public FDSObjectRasterization[] rasterize(FDSObject ... fDSObjectArray) {
        return this.rasterize(Arrays.asList(fDSObjectArray));
    }

    public FDSObjectRasterization[] rasterize(Collection<? extends FDSObject> collection) {
        Map<IFragGenerator, List<FDSObject>> map = this.separateByFragGen(collection);
        ArrayList<FDSObjectRasterization> arrayList = new ArrayList<FDSObjectRasterization>(map.size());
        for (Map.Entry<IFragGenerator, List<FDSObject>> entry : map.entrySet()) {
            this.rasterize(arrayList, entry.getKey(), entry.getValue());
        }
        return arrayList.toArray(new FDSObjectRasterization[arrayList.size()]);
    }

    private Map<IFragGenerator, List<FDSObject>> separateByFragGen(Collection<? extends FDSObject> collection) {
        LinkedHashMap<IFragGenerator, List<FDSObject>> linkedHashMap = new LinkedHashMap<IFragGenerator, List<FDSObject>>();
        for (FDSObject fDSObject : collection) {
            IFDSObjProps iFDSObjProps = this.retrieveRasterProps(fDSObject, this.d_gridRasterMap.values());
            if (iFDSObjProps == null) continue;
            IFragGenerator iFragGenerator = iFDSObjProps.getFragGenerator(this.getRastOptions());
            ArrayList<FDSObject> arrayList = (ArrayList<FDSObject>)linkedHashMap.get(iFragGenerator);
            if (arrayList == null) {
                arrayList = new ArrayList<FDSObject>(2);
                linkedHashMap.put(iFragGenerator, arrayList);
            }
            arrayList.add(fDSObject);
        }
        return linkedHashMap;
    }

    protected void rasterize(List<FDSObjectRasterization> list, IFragGenerator iFragGenerator, List<? extends FDSObject> list2) {
        Object object;
        Object object2;
        Map.Entry entry2;
        SortCache<FaceProps> sortCache = this.getFaceProps(list2);
        if (sortCache.size() == 0) {
            return;
        }
        RasterizationOptions rasterizationOptions = this.d_domain.getRastOptions();
        AABox aABox = new AABox();
        int n = FDSRasterization.calculateShift(list2.size());
        List[] listArray = new List[list2.size()];
        for (Map.Entry<Grid, IRaster3D> object32 : this.d_gridRasterMap.entrySet()) {
            int n2;
            Grid i = object32.getKey();
            entry2 = object32.getValue();
            object2 = null;
            if (!i.isEnabled()) continue;
            object = i.getGeom().getBoundingBox(new AABox());
            int n3 = 0;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                IFDSObjProps iFDSObjProps;
                FDSObject fDSObject = list2.get(n2);
                int n4 = fDSObject.getEvac().evacuation;
                if (n4 == 2 && !i.getEvacuation() || n4 == 1 && i.getEvacuation() || (iFDSObjProps = this.retrieveRasterProps(fDSObject, this.d_gridRasterMap.values())) == null) continue;
                List<Pair<TransformInfo, IGeom>> list3 = fDSObject.getGeom().quickFlatten(1);
                int n5 = 0;
                for (Pair<TransformInfo, IGeom> pair : list3) {
                    IGeom iGeom = (IGeom)pair.v2;
                    aABox.reset();
                    AABox aABox2 = ((TransformInfo)pair.v1).getBounds(iGeom, aABox);
                    if (!FDSRasterization.outsideMesh((AABox)object, aABox2)) {
                        ++n3;
                        if (object2 == null) {
                            object2 = entry2;
                        } else if (object2 == entry2) {
                            object2 = FDSRasterization.createRaster(i);
                        }
                        object2.clear();
                        this.rasterize(rasterizationOptions, (IRaster3D)object2, iFDSObjProps, (TransformInfo)pair.v1, iGeom, sortCache, n5, n, n2, listArray);
                        if (object2 != entry2) {
                            entry2.merge((IRaster3D)object2);
                        }
                    }
                    n5 += iGeom.getNumPrims(1);
                }
            }
            entry2.finalizeData();
            n2 = this.getRastOptions().separateDisconnected && n3 > 1 ? 1 : 0;
            this.retrieveRasterizations((IRaster3D)((Object)entry2), sortCache, rasterizationOptions.largeBlocks, n2 != 0, n, listArray);
            entry2.clear();
        }
        ArrayList arrayList = new ArrayList();
        LinkedIdentityHashMap<List, Pair[]> linkedIdentityHashMap = new LinkedIdentityHashMap<List, Pair[]>();
        for (int fDSObjectRasterization = 0; fDSObjectRasterization < list2.size(); ++fDSObjectRasterization) {
            entry2 = list2.get(fDSObjectRasterization);
            object2 = listArray[fDSObjectRasterization];
            if (object2 != null) {
                object = (List)linkedIdentityHashMap.get(object2);
                if (object == null) {
                    object = new ArrayList();
                    linkedIdentityHashMap.put((List)object2, (Pair[])object);
                }
                object.add(entry2);
                continue;
            }
            arrayList.add(entry2);
        }
        if (!arrayList.isEmpty()) {
            FDSObjectRasterization fDSObjectRasterization = new FDSObjectRasterization(iFragGenerator, arrayList, new Pair[0]);
            list.add(fDSObjectRasterization);
        }
        for (Map.Entry entry2 : linkedIdentityHashMap.entrySet()) {
            object2 = (List)entry2.getKey();
            object = object2.toArray(new Pair[object2.size()]);
            FDSObjectRasterization fDSObjectRasterization = new FDSObjectRasterization(iFragGenerator, (List)entry2.getValue(), (Pair<IGeom, FaceProps[]>[])object);
            list.add(fDSObjectRasterization);
        }
    }

    private static boolean outsideMesh(AABox aABox, AABox aABox2) {
        return FDSRasterization.outsideMesh(aABox.getMinX(), aABox.getMaxX(), aABox2.getMinX(), aABox2.getMaxX()) || FDSRasterization.outsideMesh(aABox.getMinY(), aABox.getMaxY(), aABox2.getMinY(), aABox2.getMaxY()) || FDSRasterization.outsideMesh(aABox.getMinZ(), aABox.getMaxZ(), aABox2.getMinZ(), aABox2.getMaxZ());
    }

    private static boolean outsideMesh(double d, double d2, double d3, double d4) {
        return !theUtil.eq(d3, d4, 1.0E-9) && (theUtil.eq(d3, d2, 1.0E-9) || theUtil.eq(d4, d, 1.0E-9));
    }

    private static List<Pair<IGeom, Integer>> flatten(IGeom iGeom) {
        ArrayList<Pair<IGeom, Integer>> arrayList = new ArrayList<Pair<IGeom, Integer>>();
        FDSRasterization.getNonGroups(iGeom, 0, arrayList);
        return arrayList;
    }

    private static void getNonGroups(IGeom iGeom, int n, List<Pair<IGeom, Integer>> list) {
        if (iGeom instanceof GeomGroup) {
            GeomGroup geomGroup = (GeomGroup)iGeom;
            for (IGeom iGeom2 : geomGroup.children) {
                FDSRasterization.getNonGroups(iGeom2, n, list);
                n += iGeom2.getNumPrims(1);
            }
        } else {
            list.add(new Pair<IGeom, Integer>(iGeom, n));
        }
    }

    private static List<Pair<IGeom, FaceProps[]>> getGeomList(List<Pair<IGeom, FaceProps[]>>[] listArray, int ... nArray) {
        List<Pair<IGeom, FaceProps[]>> list;
        if (nArray.length == 1) {
            List<Pair<IGeom, FaceProps[]>> list2 = listArray[nArray[0]];
            if (list2 == null) {
                listArray[nArray[0]] = list2 = new ArrayList<Pair<IGeom, FaceProps[]>>(2);
            }
            return list2;
        }
        ArrayList<Pair<IGeom, FaceProps[]>> arrayList = null;
        for (int n : nArray) {
            list = listArray[n];
            if (arrayList != null && (list == null || list.size() <= arrayList.size())) continue;
            arrayList = list;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (int n : nArray) {
            list = listArray[n];
            if (list != null && list != arrayList) {
                arrayList.addAll(list);
            }
            listArray[n] = arrayList;
        }
        return arrayList;
    }

    private void rasterize(RasterizationOptions rasterizationOptions, IRaster3D iRaster3D, IFDSObjProps iFDSObjProps, TransformInfo transformInfo, IGeom iGeom, SortCache<FaceProps> sortCache, int n, int n2, int n3, List<Pair<IGeom, FaceProps[]>>[] listArray) {
        assert (!(iGeom instanceof GeomGroup));
        if (!this.shouldRasterize(transformInfo, iGeom, Arrays.asList(iRaster3D))) {
            AABoxGeom aABoxGeom = iGeom instanceof AABoxGeom ? (AABoxGeom)iGeom : new AABoxGeom(transformInfo.getBounds(iGeom, new AABox()));
            FaceProps[] facePropsArray = new FaceProps[6];
            for (int i = 0; i < 6; ++i) {
                facePropsArray[i] = iFDSObjProps.getFace(i + n);
            }
            if (FDSRasterization.areAllEqual(facePropsArray)) {
                facePropsArray = new FaceProps[]{facePropsArray[0]};
            }
            FDSRasterization.getGeomList(listArray, n3).add(new Pair<AABoxGeom, FaceProps[]>(aABoxGeom, facePropsArray));
        } else {
            boolean bl = rasterizationOptions.forceThicken || iFDSObjProps.thickenEnabled();
            List list = thunderheadeng.geometry.objs.GeomUtil.explode(iGeom.transform(transformInfo, 0), IFace.class);
            if (!iGeom.isShell()) {
                int n4;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
                ArrayList<Point3d[]> arrayList2 = new ArrayList<Point3d[]>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    n4 = sortCache.indexOf(iFDSObjProps.getFace(i + n));
                    IFace iFace = (IFace)list.get(i);
                    List<IPolygon> list2 = GeomUtil.toPolys(iFace, 0.1, true);
                    for (IPolygon iPolygon : list2) {
                        arrayList2.add(PolyUtil.getAllVerts(iPolygon, false));
                        arrayList.add(n4);
                    }
                }
                int[] nArray = theUtil.toIntArray(arrayList);
                n4 = FDSRasterization.getInteriorGroup(nArray);
                n4 = FDSRasterization.encodeId(n2, n3, n4);
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = FDSRasterization.encodeId(n2, n3, nArray[i]);
                }
                iRaster3D.rasterizeSolid(bl, n4, nArray, (Point3d[][])arrayList2.toArray((T[])new Point3d[arrayList2.size()][]));
            } else {
                ArrayList<Point3d[]> arrayList = new ArrayList<Point3d[]>(list.size());
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    int n5 = sortCache.indexOf(iFDSObjProps.getFace(i + n));
                    int n6 = FDSRasterization.encodeId(n2, n3, n5);
                    IFace iFace = (IFace)list.get(i);
                    for (IPolygon iPolygon : GeomUtil.toPolys(iFace, 0.1, true)) {
                        Point3d[] point3dArray = PolyUtil.getAllVerts(iPolygon, false);
                        arrayList.add(point3dArray);
                        arrayList3.add(n6);
                    }
                }
                iRaster3D.rasterizeShell(bl, FDSRasterization.encodeId(n2, n3, -1), theUtil.toIntArray(arrayList3), theUtil.toArray(arrayList, Point3d[].class));
            }
        }
    }

    private static int calculateShift(int n) {
        if (n == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(n) / Math.log(2.0));
    }

    private static int encodeId(int n, int n2, int n3) {
        int n4 = n3 << n;
        return n4 |= n2;
    }

    private static int[] decodeId(int n, int n2) {
        int n3 = (1 << n) - 1;
        int n4 = n2 & n3;
        int n5 = n2 >> n;
        return new int[]{n4, n5};
    }

    private static int getInteriorGroup(int[] nArray) {
        if (nArray.length > 0) {
            int n = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == n) continue;
                return -1;
            }
            return n;
        }
        return -1;
    }

    private void retrieveRasterizations(IRaster3D iRaster3D, SortCache<FaceProps> sortCache, boolean bl, boolean bl2, int n, List<Pair<IGeom, FaceProps[]>>[] listArray) {
        IRaster3D.CellListing[] cellListingArray;
        double[] dArray = iRaster3D.getXDiv();
        double[] dArray2 = iRaster3D.getYDiv();
        double[] dArray3 = iRaster3D.getZDiv();
        for (IRaster3D.CellListing cellListing : cellListingArray = iRaster3D.getListings(bl2)) {
            int[] nArray = FDSRasterization.extractSources(cellListing, n);
            List<Pair<IGeom, FaceProps[]>> list = FDSRasterization.getGeomList(listArray, nArray);
            if (bl) {
                this.getFragGeom(FDSRasterization.mergeCells(cellListing.cell, new MultiPropMerger()), new int[]{1, 1, 1}, new int[]{0, 1, 2, 3, 4, 5}, dArray, dArray2, dArray3, sortCache, list);
                this.getFragGeom(FDSRasterization.mergeCells(cellListing.xy, new PlaneMultiPropMerger(AdjacencyMerger.Dir.Z)), new int[]{1, 1, 0}, new int[]{4, 5}, dArray, dArray2, dArray3, sortCache, list);
                this.getFragGeom(FDSRasterization.mergeCells(cellListing.xz, new PlaneMultiPropMerger(AdjacencyMerger.Dir.Y)), new int[]{1, 0, 1}, new int[]{2, 3}, dArray, dArray2, dArray3, sortCache, list);
                this.getFragGeom(FDSRasterization.mergeCells(cellListing.yz, new PlaneMultiPropMerger(AdjacencyMerger.Dir.X)), new int[]{0, 1, 1}, new int[]{0, 1}, dArray, dArray2, dArray3, sortCache, list);
                continue;
            }
            this.getFragGeom(cellListing.cell, new int[]{1, 1, 1}, new int[]{0, 1, 2, 3, 4, 5}, dArray, dArray2, dArray3, sortCache, list);
            this.getFragGeom(cellListing.xy, new int[]{1, 1, 0}, new int[]{4, 5}, dArray, dArray2, dArray3, sortCache, list);
            this.getFragGeom(cellListing.xz, new int[]{1, 0, 1}, new int[]{2, 3}, dArray, dArray2, dArray3, sortCache, list);
            this.getFragGeom(cellListing.yz, new int[]{0, 1, 1}, new int[]{0, 1}, dArray, dArray2, dArray3, sortCache, list);
        }
    }

    private static int[] extractSources(IRaster3D.CellListing cellListing, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        FDSRasterization.extractSources(cellListing.cell, hashSet, n);
        FDSRasterization.extractSources(cellListing.xy, hashSet, n);
        FDSRasterization.extractSources(cellListing.xz, hashSet, n);
        FDSRasterization.extractSources(cellListing.yz, hashSet, n);
        return theUtil.toIntArray(hashSet);
    }

    private static void extractSources(Pair<Point3i, int[]>[] pairArray, Set<Integer> set, int n) {
        for (int i = 0; i < pairArray.length; ++i) {
            Pair<Point3i, int[]> pair = pairArray[i];
            for (int j = 0; j < ((int[])pair.v2).length; ++j) {
                int[] nArray = FDSRasterization.decodeId(n, ((int[])pair.v2)[j]);
                set.add(nArray[0]);
                ((int[])pair.v2)[j] = nArray[1];
            }
            if (!FDSRasterization.areAllSame((int[])pair.v2)) continue;
            pairArray[i] = new Pair(pair.v1, new int[]{((int[])pair.v2)[0]});
        }
    }

    private void getFragGeom(Pair<Point3i, int[]>[] pairArray, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2, double[] dArray3, SortCache<FaceProps> sortCache, List<Pair<IGeom, FaceProps[]>> list) {
        for (Pair<Point3i, int[]> pair : pairArray) {
            Point3i point3i = (Point3i)pair.v1;
            int[] nArray3 = (int[])pair.v2;
            AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(dArray[point3i.x], dArray2[point3i.y], dArray3[point3i.z]), new Point3d(dArray[point3i.x + nArray[0]], dArray2[point3i.y + nArray[1]], dArray3[point3i.z + nArray[2]]), 0);
            FaceProps[] facePropsArray = this.getProps(sortCache, nArray3, nArray2);
            list.add(new Pair<AABoxGeom, FaceProps[]>(aABoxGeom, facePropsArray));
        }
    }

    private void getFragGeom(Collection<MergedCell<MultiProps>> collection, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2, double[] dArray3, SortCache<FaceProps> sortCache, List<Pair<IGeom, FaceProps[]>> list) {
        for (MergedCell<MultiProps> mergedCell : collection) {
            AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(dArray[mergedCell.x1], dArray2[mergedCell.y1], dArray3[mergedCell.z1]), new Point3d(dArray[mergedCell.x2 + nArray[0]], dArray2[mergedCell.y2 + nArray[1]], dArray3[mergedCell.z2 + nArray[2]]), 0);
            FaceProps[] facePropsArray = this.getProps(sortCache, ((MultiProps)mergedCell.val).props, nArray2);
            list.add(new Pair<AABoxGeom, FaceProps[]>(aABoxGeom, facePropsArray));
        }
    }

    private FaceProps[] getProps(SortCache<FaceProps> sortCache, int[] nArray, int[] nArray2) {
        Object[] objectArray;
        if (FDSRasterization.areAllSame(nArray)) {
            objectArray = new FaceProps[]{this.getProp(sortCache, nArray, nArray[0])};
        } else {
            objectArray = new FaceProps[6];
            Arrays.fill(objectArray, this.getProp(sortCache, nArray, nArray[0]));
            for (int i = 0; i < Math.min(nArray2.length, 6); ++i) {
                objectArray[nArray2[i]] = this.getProp(sortCache, nArray, nArray[i]);
            }
        }
        return objectArray;
    }

    private FaceProps getProp(SortCache<FaceProps> sortCache, int[] nArray, int n) {
        if (n == -1) {
            for (int n2 : nArray) {
                if (n2 == -1) continue;
                return sortCache.get(n2);
            }
            return new FaceProps(this.d_domain.getDefaultSurface(), null);
        }
        return sortCache.get(n);
    }

    private static boolean areAllSame(int[] nArray) {
        if (nArray.length == 1) {
            return true;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean areAllEqual(T[] TArray) {
        if (TArray.length == 1) {
            return true;
        }
        T t = TArray[0];
        for (int i = 1; i < TArray.length; ++i) {
            if (TArray[i].equals(t)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareProps(int n, int n2) {
        return n == -1 || n2 == -1 || n == n2;
    }

    private static int[] expand(int[] nArray, int n, int[] nArray2) {
        if (nArray.length == 1) {
            for (int i = 0; i < n; ++i) {
                nArray2[i] = nArray[0];
            }
            return nArray2;
        }
        return nArray;
    }

    private static Collection<MergedCell<MultiProps>> mergeCells(Pair<Point3i, int[]>[] pairArray, AdjacencyMerger.IMergeQuery<MultiProps> iMergeQuery) {
        ArrayList arrayList = new ArrayList();
        for (Pair<Point3i, int[]> pair : pairArray) {
            MergedCell<MultiProps> mergedCell = new MergedCell<MultiProps>(new MultiProps((int[])pair.v2), ((Point3i)pair.v1).x, ((Point3i)pair.v1).x, ((Point3i)pair.v1).y, ((Point3i)pair.v1).y, ((Point3i)pair.v1).z, ((Point3i)pair.v1).z);
            arrayList.add(mergedCell);
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public void update(Events events) {
        boolean bl = false;
        for (EventChannel<PyroMod> eventChannel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
            if (!eventChannel.containsChange(PyroMod.EVT_MODEL_CHANGED)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.reset();
        } else {
            for (EventChannel<IPyroObject> eventChannel : events.getAffectedChannels(Grid.class, new Class[0])) {
                this.addRasters(eventChannel.getAddedObjs());
                this.removeRasters(eventChannel.getRemovedObjs());
                this.updateRasters(eventChannel.getChangedObjs(EventChannel.EVT_GENERAL));
            }
        }
    }

    private void reset() {
        this.d_gridRasterMap.clear();
        if (this.d_domain != null) {
            this.addRasters(this.d_domain.getGridManager().flatten());
        }
    }

    private static IRaster3D createRaster(Grid grid) {
        Unit unit = Geometry.LU;
        double[] dArray = Util.convertArray(grid.getXLinePositions(), unit);
        double[] dArray2 = Util.convertArray(grid.getYLinePositions(), unit);
        double[] dArray3 = Util.convertArray(grid.getZLinePositions(), unit);
        return FDSRasterization.createRaster(dArray, dArray2, dArray3);
    }

    public void addRasters(Collection<? extends Grid> collection) {
        for (Grid grid : collection) {
            IRaster3D iRaster3D = FDSRasterization.createRaster(grid);
            this.d_gridRasterMap.put(grid, iRaster3D);
        }
    }

    public void removeRasters(Collection<? extends Grid> collection) {
        for (Grid grid : collection) {
            this.d_gridRasterMap.remove(grid);
        }
    }

    public void updateRasters(Collection<? extends Grid> collection) {
        Unit unit = Geometry.LU;
        for (Grid grid : collection) {
            IRaster3D iRaster3D = this.d_gridRasterMap.get(grid);
            assert (iRaster3D != null);
            double[] dArray = Util.convertArray(grid.getXLinePositions(), unit);
            double[] dArray2 = Util.convertArray(grid.getYLinePositions(), unit);
            double[] dArray3 = Util.convertArray(grid.getZLinePositions(), unit);
            iRaster3D.setDivisions(dArray, dArray2, dArray3);
        }
    }

    public Map<Grid, IRaster3D> getGridRasters() {
        return this.d_gridRasterMap;
    }

    public Collection<IRaster3D> getRasters() {
        return this.d_gridRasterMap.values();
    }

    public Collection<Grid> getRasterGrids() {
        return this.d_gridRasterMap.keySet();
    }

    public boolean shouldRasterize(FDSObject fDSObject) {
        return this.shouldRasterize(fDSObject, this.getRasters());
    }

    private boolean shouldRasterize(FDSObject fDSObject, Collection<? extends IRaster3D> collection) {
        if (fDSObject.getFragGenerator() == null) {
            return false;
        }
        IGeomNode iGeomNode = fDSObject.getGeom();
        if (!iGeomNode.getChildren().isEmpty()) {
            return true;
        }
        return this.shouldRasterize(iGeomNode.getLocalTransform().getInfo(), iGeomNode.getLocalGeom(), collection);
    }

    private boolean shouldRasterize(TransformInfo transformInfo, IGeom iGeom, Collection<? extends IRaster3D> collection) {
        if (!iGeom.isAxisAlignedBlock(transformInfo)) {
            return true;
        }
        if (!this.d_domain.getRastOptions().rasterizeAligned) {
            return false;
        }
        AABox aABox = transformInfo.getBounds(iGeom, new AABox());
        Point3d[] point3dArray = aABox.getVerts();
        for (IRaster3D iRaster3D : collection) {
            double[] dArray = iRaster3D.getXDiv();
            double[] dArray2 = iRaster3D.getYDiv();
            double[] dArray3 = iRaster3D.getZDiv();
            for (Point3d point3d : point3dArray) {
                int n = theUtil.binarySearch(dArray, point3d.x, s_gridAlignComp);
                if (n < 0) {
                    return true;
                }
                n = theUtil.binarySearch(dArray2, point3d.y, s_gridAlignComp);
                if (n < 0) {
                    return true;
                }
                n = theUtil.binarySearch(dArray3, point3d.z, s_gridAlignComp);
                if (n >= 0) continue;
                return true;
            }
        }
        return false;
    }

    private IFDSObjProps retrieveRasterProps(FDSObject fDSObject, Collection<? extends IRaster3D> collection) {
        return this.shouldRasterize(fDSObject, collection) ? fDSObject.getFragGenerator() : null;
    }

    private static class MultiPropMerger
    implements AdjacencyMerger.IMergeQuery<MultiProps> {
        private final int[] props1 = new int[6];
        private final int[] props2 = new int[6];

        private MultiPropMerger() {
        }

        @Override
        public MultiProps merge(MultiProps multiProps, MultiProps multiProps2, AdjacencyMerger.Dir dir) {
            switch (dir) {
                case X: {
                    return this.mergeX(multiProps, multiProps2);
                }
                case Y: {
                    return this.mergeY(multiProps, multiProps2);
                }
                case Z: {
                    return this.mergeZ(multiProps, multiProps2);
                }
            }
            return null;
        }

        private MultiProps mergeX(MultiProps multiProps, MultiProps multiProps2) {
            return this.merge(multiProps, multiProps2, 2, 4);
        }

        private MultiProps mergeY(MultiProps multiProps, MultiProps multiProps2) {
            return this.merge(multiProps, multiProps2, 0, 4);
        }

        private MultiProps mergeZ(MultiProps multiProps, MultiProps multiProps2) {
            return this.merge(multiProps, multiProps2, 0, 2);
        }

        private MultiProps merge(MultiProps multiProps, MultiProps multiProps2, int n, int n2) {
            int[] nArray;
            int[] nArray2 = FDSRasterization.expand(multiProps.props, 6, this.props1);
            if (FDSRasterization.compareProps(nArray2[n], (nArray = FDSRasterization.expand(multiProps2.props, 6, this.props2))[n]) && FDSRasterization.compareProps(nArray2[n + 1], nArray[n + 1]) && FDSRasterization.compareProps(nArray2[n2], nArray[n2]) && FDSRasterization.compareProps(nArray2[n2 + 1], nArray[n2 + 1])) {
                int[] nArray3 = new int[6];
                for (int i = 0; i < 6; i += 2) {
                    nArray3[i] = nArray2[i] != -1 ? nArray2[i] : nArray[i];
                    nArray3[i + 1] = nArray[i + 1] != -1 ? nArray[i + 1] : nArray2[i + 1];
                }
                return new MultiProps(nArray3);
            }
            return null;
        }
    }

    private static class PlaneMultiPropMerger
    implements AdjacencyMerger.IMergeQuery<MultiProps> {
        private final int[] props1 = new int[2];
        private final int[] props2 = new int[2];
        private final AdjacencyMerger.Dir dir;

        public PlaneMultiPropMerger(AdjacencyMerger.Dir dir) {
            this.dir = dir;
        }

        @Override
        public MultiProps merge(MultiProps multiProps, MultiProps multiProps2, AdjacencyMerger.Dir dir) {
            int[] nArray;
            if (dir.equals((Object)this.dir)) {
                return null;
            }
            int[] nArray2 = FDSRasterization.expand(multiProps.props, 2, this.props1);
            if (nArray2[0] == (nArray = FDSRasterization.expand(multiProps2.props, 2, this.props2))[0] && nArray2[1] == nArray[1]) {
                return multiProps;
            }
            return null;
        }
    }

    private static class MultiProps {
        public final int[] props;

        public MultiProps(int[] nArray) {
            this.props = nArray;
        }
    }
}

