/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFragGenerator;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.Pair;

public class FDSObjectRasterization {
    public final IFragGenerator fragGen;
    public final List<FDSObject> sources;
    public final Pair<IGeom, FaceProps[]>[] geoms;

    public FDSObjectRasterization(IFragGenerator iFragGenerator, List<FDSObject> list, Pair<IGeom, FaceProps[]>[] pairArray) {
        this.fragGen = iFragGenerator;
        this.sources = list;
        this.geoms = new Pair[pairArray.length];
        for (int i = 0; i < pairArray.length; ++i) {
            Pair<IGeom, FaceProps[]> pair;
            IGeom iGeom = (IGeom)pairArray[i].v1;
            IGeom iGeom2 = iFragGenerator.transformGeom(iGeom);
            if (iGeom2 == iGeom) {
                pair = pairArray[i];
            } else {
                Pair<IGeom, FaceProps[]> pair2;
                pair = pair2;
                super(iGeom2, (FaceProps[])pairArray[i].v2);
            }
            this.geoms[i] = pair;
        }
    }

    public IPyroObject getFrags(boolean bl) {
        if (!bl) {
            Collection<FDSObject> collection = this.getFragsAsCollection();
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.size() == 1) {
                return collection.iterator().next();
            }
            ModelComposite modelComposite = new ModelComposite(this.sources.get(0).getName());
            modelComposite.addAll(collection);
            return modelComposite;
        }
        return this.getFragsAsComposite();
    }

    public Collection<FDSObject> getFragsAsCollection() {
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>(this.geoms.length);
        for (Pair<IGeom, FaceProps[]> pair : this.geoms) {
            Object t = this.fragGen.generateFrag((IGeom)pair.v1, (FaceProps[])pair.v2);
            arrayList.add((FDSObject)t);
        }
        if (arrayList.size() > 1) {
            for (FDSObject fDSObject : arrayList) {
                fDSObject.setName(String.format(Intl.intl("%s [Segment]"), fDSObject.getName()));
            }
        }
        return arrayList;
    }

    public FDSObject getFragsAsComposite() {
        int n = 0;
        for (Pair<IGeom, FaceProps[]> object2 : this.geoms) {
            n += ((IGeom)object2.v1).getNumPrims(1);
        }
        if (n == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.geoms.length);
        FaceProps[] facePropsArray = new FaceProps[n];
        int n2 = 0;
        for (Pair<IGeom, FaceProps[]> pair : this.geoms) {
            int n3;
            arrayList.add(pair.v1);
            int n4 = ((IGeom)pair.v1).getNumPrims(1);
            if (((FaceProps[])pair.v2).length == 1) {
                for (n3 = 0; n3 < n4; ++n3) {
                    facePropsArray[n2++] = ((FaceProps[])pair.v2)[0];
                }
                continue;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                facePropsArray[n2++] = ((FaceProps[])pair.v2)[n3];
            }
        }
        IGeom iGeom = arrayList.size() == 1 ? (IGeom)arrayList.get(0) : new GeomGroup(arrayList);
        return this.fragGen.generateFrag(iGeom, facePropsArray);
    }
}

