/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.ramp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class Ramp
implements Serializable,
Cloneable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private List<Entry> d_rampRecords;
    private final IRampInput d_defaultInput;
    private IRampInput d_input;
    private final int d_fUnitType;

    public Ramp(Collection<Entry> collection, IRampInput iRampInput, int n) {
        this(collection, iRampInput, iRampInput, n);
    }

    public Ramp(Collection<Entry> collection, IRampInput iRampInput, IRampInput iRampInput2, int n) {
        this.d_rampRecords = new ArrayList<Entry>(collection);
        this.d_defaultInput = iRampInput;
        this.d_input = iRampInput2;
        this.d_fUnitType = n;
    }

    public Ramp scaleF(double d) {
        if (d == 1.0) {
            return this;
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>(this.getRecords().size());
        for (Entry entry : this.getRecords()) {
            arrayList.add(new Entry(entry.t, entry.f.scale(d)));
        }
        return new Ramp(arrayList, this.d_defaultInput, this.d_input, this.d_fUnitType);
    }

    public int getTUnitType() {
        return this.d_input.getUnitType();
    }

    public IRampInput getDefaultInput() {
        return this.d_defaultInput;
    }

    public IRampInput getInput() {
        return this.d_input;
    }

    public int getFUnitType() {
        return this.d_fUnitType;
    }

    public Object clone() {
        try {
            Ramp ramp = (Ramp)super.clone();
            ramp.d_rampRecords = new ArrayList<Entry>(this.d_rampRecords.size());
            for (Entry entry : this.d_rampRecords) {
                ramp.d_rampRecords.add((Entry)entry.clone());
            }
            return ramp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public Task taskSetInput(IRampInput iRampInput) {
        return new ReplaceInputTask(iRampInput);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ramp)) {
            return false;
        }
        Ramp ramp = (Ramp)object;
        return this.d_rampRecords.equals(ramp.d_rampRecords) && this.d_defaultInput.equals(ramp.d_defaultInput) && this.d_input.equals(ramp.d_input) && this.d_fUnitType == ramp.d_fUnitType;
    }

    public int hashCode() {
        return this.d_rampRecords.hashCode() + this.d_defaultInput.hashCode() + this.d_input.hashCode() + this.d_fUnitType;
    }

    public List<Entry> getRecords() {
        return this.d_rampRecords;
    }

    public boolean isEmpty() {
        return this.d_rampRecords.isEmpty();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        if (this.d_input instanceof SignalInput) {
            SignalInput signalInput = (SignalInput)this.d_input;
            depList.add(DLink.WEAK, (IPyroObject)signalInput.input.getAttachedSource());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        assert (this.d_input instanceof SignalInput);
        IDoubleOutPin iDoubleOutPin = ((SignalInput)this.d_input).input;
        Util.keepIfNullOr(set, ISignalSource.class);
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            IDoubleOutPin iDoubleOutPin2;
            ISignalSource iSignalSource = (ISignalSource)iterator.next();
            if (iSignalSource == null || (iDoubleOutPin2 = this.getReplacementPin(iDoubleOutPin, iSignalSource)) != null) continue;
            iterator.remove();
        }
    }

    private IDoubleOutPin getReplacementPin(IDoubleOutPin iDoubleOutPin, ISignalSource iSignalSource) {
        IDoubleOutPin iDoubleOutPin2 = null;
        for (IOutPin iOutPin : iSignalSource.getOutputPins()) {
            if (!(iOutPin instanceof IDoubleOutPin)) continue;
            if (iDoubleOutPin2 == null) {
                iDoubleOutPin2 = (IDoubleOutPin)iOutPin;
            }
            if (!iOutPin.getName().equals(iDoubleOutPin.getName())) continue;
            return (IDoubleOutPin)iOutPin;
        }
        return iDoubleOutPin2;
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        assert ((iPyroObject2 == null || iPyroObject2 instanceof ISignalSource) && this.d_input instanceof SignalInput);
        SignalInput signalInput = (SignalInput)this.d_input;
        ISignalSource iSignalSource = (ISignalSource)iPyroObject2;
        if (iSignalSource == null) {
            return new ReplaceInputTask(this.getDefaultInput());
        }
        IDoubleOutPin iDoubleOutPin = this.getReplacementPin(signalInput.input, iSignalSource);
        assert (iDoubleOutPin != null);
        SignalInput signalInput2 = new SignalInput(iDoubleOutPin);
        return new ReplaceInputTask(signalInput2);
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    private class ReplaceInputTask
    extends AUndoableTask {
        private final IRampInput d_replacement;
        private List<Entry> d_oldVals;
        private IRampInput d_oldInput;

        public ReplaceInputTask(IRampInput iRampInput) {
            this.d_replacement = iRampInput;
        }

        @Override
        public void run() {
            Unit unit;
            Unit unit2;
            this.d_oldInput = Ramp.this.d_input;
            UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
            if (unitSystem == null) {
                unitSystem = SIUS.getInstance();
            }
            if (!UnitDouble.areCompatible(unit2 = ((Entry)((Ramp)Ramp.this).d_rampRecords.get((int)0)).t.getUnit(), unit = unitSystem.getUnit(this.d_replacement.getUnitType()))) {
                this.d_oldVals = Ramp.this.d_rampRecords;
                ArrayList<Entry> arrayList = new ArrayList<Entry>(Ramp.this.d_rampRecords.size());
                for (Entry entry : Ramp.this.d_rampRecords) {
                    UnitDouble unitDouble = entry.t.reinterpret(unit);
                    arrayList.add(new Entry(unitDouble, entry.f));
                }
                Ramp.this.d_rampRecords = arrayList;
            } else {
                this.d_oldVals = null;
            }
            Ramp.this.d_input = this.d_replacement;
        }

        @Override
        public void undo() {
            Ramp.this.d_input = this.d_oldInput;
            if (this.d_oldVals != null) {
                Ramp.this.d_rampRecords = this.d_oldVals;
            }
        }
    }

    public static class Entry
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public final UnitDouble t;
        public final UnitDouble f;

        public Entry(UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.t = unitDouble;
            this.f = unitDouble2;
        }

        public Object clone() {
            return new Entry(this.t, this.f);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.t.equals(entry.t) && this.f.equals(entry.f);
        }

        public int hashCode() {
            return this.t.hashCode() + this.f.hashCode();
        }
    }
}

