/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityCategory;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.util.theUtil;

public class QuantityUtil {
    public static final Predicate<Quantity> STATIC_QUANT_FILTER = new Predicate<Quantity>(){

        @Override
        public boolean test(Quantity quantity) {
            return quantity.getNumArgs() != 0;
        }
    };
    public static final Predicate<Quantity> OBJ_QUANT_FILTER = new Predicate<Quantity>(){

        @Override
        public boolean test(Quantity quantity) {
            return quantity.getNumArgs() <= 0;
        }
    };

    public static boolean isOneOf(Quantity quantity, QuantityType ... quantityTypeArray) {
        for (QuantityType quantityType : quantityTypeArray) {
            if (quantity.quantityType != quantityType) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutputAll(Quantity quantity, int n) {
        return (quantity.outputTypes & n) == n;
    }

    public static boolean canOutputAny(Quantity quantity, int n) {
        return (quantity.outputTypes & n) != 0;
    }

    public static boolean isSpecMassFraction(Quantity quantity) {
        return quantity.unitType == 18;
    }

    public static Collection<Quantity> getQuantities(final int n) {
        return QuantityUtil.getQuantities(new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity quantity) {
                return QuantityUtil.canOutputAll(quantity, n);
            }
        });
    }

    public static Collection<Quantity> getQuantities(int n, QuantityType ... quantityTypeArray) {
        TypeFilter typeFilter = new TypeFilter(n, quantityTypeArray);
        return QuantityUtil.getQuantities(typeFilter);
    }

    public static Collection<Quantity> getQuantities(final Predicate<Quantity> predicate) {
        Collection<Quantity> collection = Arrays.asList(Quantity.values());
        collection = theUtil.filter(collection, new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity quantity) {
                return !quantity.isDeprecated() && predicate.test(quantity);
            }
        });
        return collection;
    }

    public static Collection<Quantity> sort(Collection<Quantity> collection) {
        ArrayList<Quantity> arrayList = new ArrayList<Quantity>(collection);
        Collections.sort(arrayList, new ANameSorter<Quantity>(){

            @Override
            protected String getName(Quantity quantity) {
                return quantity.name;
            }
        });
        return arrayList;
    }

    public static Collection<IQuantity> sortQuantities(Collection<? extends IQuantity> collection) {
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(collection);
        Collections.sort(arrayList, new ANameSorter<IQuantity>(){

            @Override
            protected String getName(IQuantity iQuantity) {
                return iQuantity.getDescription();
            }
        });
        return arrayList;
    }

    public static Map<String, List<Quantity>> groupObjQuantities() {
        HashMap<String, List<Quantity>> hashMap = new HashMap<String, List<Quantity>>();
        for (Quantity quantity : Quantity.values()) {
            if (quantity.category == null || quantity.getNumArgs() <= 0) continue;
            ArrayList<Quantity> arrayList = (ArrayList<Quantity>)hashMap.get(quantity.category);
            if (arrayList == null) {
                arrayList = new ArrayList<Quantity>();
                hashMap.put(quantity.category, arrayList);
            }
            arrayList.add(quantity);
        }
        return hashMap;
    }

    public static Quantity getDefaultQuantForCategory(QuantityCategory quantityCategory) {
        return QuantityUtil.getDefaultQuantForCategory(quantityCategory.category);
    }

    public static Quantity getDefaultQuantForCategory(String string) {
        if (string.equals(QuantityCategory.SPECIES.category)) {
            return Quantity.SPEC_VOLUME_FRACTION;
        }
        return null;
    }

    public static Collection<StaticQuantity> generateStaticQuantities(Predicate<Quantity> predicate, boolean bl) {
        predicate = OBJ_QUANT_FILTER.and(predicate);
        Collection<Quantity> collection = QuantityUtil.getQuantities(predicate);
        Function<Quantity, StaticQuantity> function = new Function<Quantity, StaticQuantity>(){

            @Override
            public StaticQuantity apply(Quantity quantity) {
                return quantity.create();
            }
        };
        Collection<StaticQuantity> collection2 = theUtil.map(collection, function);
        if (bl) {
            collection2 = Util.sort(collection2, new ANameSorter<StaticQuantity>(){

                @Override
                protected String getName(StaticQuantity staticQuantity) {
                    return staticQuantity.getDescription();
                }
            });
        }
        return collection2;
    }

    public static List<ObjectQuantity> generateAllObjectQuanties(PyroMod pyroMod, Predicate<Quantity> predicate, boolean bl) {
        ArrayList<ObjectQuantity> arrayList = new ArrayList<ObjectQuantity>();
        predicate = STATIC_QUANT_FILTER.and(predicate);
        for (Quantity quantity : QuantityUtil.getQuantities(predicate)) {
            Collection<? extends IPyroObject> collection;
            ArrayList<Collection<? extends IPyroObject>> arrayList2 = new ArrayList<Collection<? extends IPyroObject>>(quantity.getNumArgs());
            for (int i = 0; i < quantity.getNumArgs() && !(collection = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quantity, i)).isEmpty(); ++i) {
                arrayList2.add(collection);
            }
            if (arrayList2.size() != quantity.getNumArgs()) continue;
            IPyroObject[] iPyroObjectArray = new IPyroObject[quantity.getNumArgs()];
            collection = new ArrayDeque<IPyroObject>();
            collection.push((IPyroObject)((Object)((Collection)arrayList2.get(0)).iterator()));
            while (!collection.isEmpty()) {
                Iterator iterator = (Iterator)collection.peek();
                if (iterator.hasNext()) {
                    iPyroObjectArray[collection.size() - 1] = (IPyroObject)iterator.next();
                    if (collection.size() == quantity.getNumArgs()) {
                        arrayList.add(quantity.create(Arrays.copyOf(iPyroObjectArray, iPyroObjectArray.length)));
                        continue;
                    }
                    collection.push((IPyroObject)((Object)((Collection)arrayList2.get(collection.size())).iterator()));
                    continue;
                }
                collection.pop();
            }
        }
        if (bl) {
            Collections.sort(arrayList, new ANameSorter<ObjectQuantity>(){

                @Override
                protected String getName(ObjectQuantity objectQuantity) {
                    return objectQuantity.getDescription();
                }
            });
        }
        return arrayList;
    }

    public static List<IQuantity> generateAllQuantities(PyroMod pyroMod, Predicate<Quantity> predicate, boolean bl) {
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>();
        arrayList.addAll(QuantityUtil.generateAllObjectQuanties(pyroMod, predicate, bl));
        arrayList.addAll(QuantityUtil.generateStaticQuantities(predicate, bl));
        return arrayList;
    }

    public static Collection<? extends IPyroObject> getValidArguments(PyroMod pyroMod, Quantity quantity, int n) {
        Class<? extends IPyroObject> clazz = quantity.requiredTypes[n];
        Predicate predicate = quantity.typeFilters[n];
        return Util.getAllObjects(pyroMod, clazz, predicate, true);
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, IQuantity ... iQuantityArray) {
        for (IQuantity iQuantity : iQuantityArray) {
            QuantityUtil.takeDepSnapshot(depList, dLink, iQuantity);
        }
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, Collection<IQuantity> collection) {
        for (IQuantity iQuantity : collection) {
            QuantityUtil.takeDepSnapshot(depList, dLink, iQuantity);
        }
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, IQuantity iQuantity) {
        if (iQuantity instanceof ObjectQuantity) {
            ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
            for (Object t : objectQuantity.objects) {
                depList.add(dLink, (IPyroObject)t);
            }
        }
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, IQuantity ... iQuantityArray) {
        for (IQuantity iQuantity : iQuantityArray) {
            if (!QuantityUtil.isQuantityRef(iPyroObject, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, Collection<? extends IQuantity> collection) {
        for (IQuantity iQuantity : collection) {
            if (!QuantityUtil.isQuantityRef(iPyroObject, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, IQuantity iQuantity) {
        if (iQuantity instanceof ObjectQuantity) {
            for (Object t : ((ObjectQuantity)iQuantity).objects) {
                if (t != iPyroObject) continue;
                return true;
            }
        }
        return false;
    }

    public static class TypeFilter
    implements Predicate<Quantity> {
        private final int outputTypes;
        private final QuantityType[] quantityTypes;

        public TypeFilter(int n, QuantityType ... quantityTypeArray) {
            this.outputTypes = n;
            this.quantityTypes = quantityTypeArray;
        }

        @Override
        public boolean test(Quantity quantity) {
            return (this.quantityTypes.length <= 0 || QuantityUtil.isOneOf(quantity, this.quantityTypes)) && QuantityUtil.canOutputAll(quantity, this.outputTypes);
        }
    }
}

