/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.util.Util;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public abstract class QuantityReplacer {
    private final PyroMod d_domain;

    public QuantityReplacer(PyroMod pyroMod) {
        this.d_domain = pyroMod;
    }

    protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
        return true;
    }

    protected abstract Task taskReplaceQuant(IQuantity var1, IQuantity var2);

    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set, IQuantity iQuantity) {
        this.removeInvalidReplacements(t, set, Arrays.asList(iQuantity));
    }

    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set, Collection<? extends IQuantity> collection) {
        List<Pair<ObjectQuantity, int[]>> list = QuantityReplacer.getObjectRefs(t, collection);
        for (Pair<ObjectQuantity<Object>, Object> pair : list) {
            for (int n : (int[])pair.v2) {
                Util.keepIfNullOr(set, ((ObjectQuantity)pair.v1).get().requiredTypes[n]);
                Predicate predicate = ((ObjectQuantity)pair.v1).get().typeFilters[n];
                if (predicate == Predicates.alwaysTrue()) continue;
                Iterator<T> iterator = set.iterator();
                while (iterator.hasNext()) {
                    IPyroObject iPyroObject = (IPyroObject)iterator.next();
                    if (iPyroObject == null || predicate.test(iPyroObject)) continue;
                    iterator.remove();
                }
            }
        }
        Iterator<Pair<ObjectQuantity<Object>, Object>> iterator = set.iterator();
        block3: while (iterator.hasNext()) {
            Pair<ObjectQuantity<Object>, Object> pair;
            pair = iterator.next();
            if (pair == null || !(pair instanceof IPyroObject)) continue;
            Object object = list.iterator();
            while (object.hasNext()) {
                Pair pair2 = (Pair)object.next();
                ObjectQuantity objectQuantity = QuantityReplacer.replaceObjRef((ObjectQuantity)pair2.v1, (int[])pair2.v2, (IPyroObject)((Object)pair));
                if (this.canReplaceQuant((IQuantity)pair2.v1, objectQuantity)) continue;
                iterator.remove();
                continue block3;
            }
        }
    }

    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2, IQuantity iQuantity) {
        return this.taskReplaceDep(iPyroObject, iPyroObject2, Arrays.asList(iQuantity));
    }

    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2, final Collection<? extends IQuantity> collection) {
        return new CompositeTask(this.d_domain){

            @Override
            protected void queueBeginRuntimeTasks() {
                List list = QuantityReplacer.getObjectRefs(iPyroObject, collection);
                for (Pair pair : list) {
                    ObjectQuantity objectQuantity = iPyroObject2 == null ? null : QuantityReplacer.replaceObjRef((ObjectQuantity)pair.v1, (int[])pair.v2, iPyroObject2);
                    this.addTask(QuantityReplacer.this.taskReplaceQuant((IQuantity)pair.v1, objectQuantity));
                }
            }
        };
    }

    private static ObjectQuantity replaceObjRef(ObjectQuantity objectQuantity, int[] nArray, IPyroObject iPyroObject) {
        IPyroObject[] iPyroObjectArray = (IPyroObject[])Arrays.copyOf(objectQuantity.objects, objectQuantity.objects.length);
        for (int n : nArray) {
            iPyroObjectArray[n] = iPyroObject;
        }
        return objectQuantity.get().create(iPyroObjectArray);
    }

    private static List<Pair<ObjectQuantity, int[]>> getObjectRefs(IPyroObject iPyroObject, Collection<? extends IQuantity> collection) {
        ArrayList<Pair<ObjectQuantity, int[]>> arrayList = new ArrayList<Pair<ObjectQuantity, int[]>>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (IQuantity iQuantity : collection) {
            if (!(iQuantity instanceof ObjectQuantity)) continue;
            ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
            for (int i = 0; i < objectQuantity.objects.length; ++i) {
                if (objectQuantity.objects[i] != iPyroObject) continue;
                arrayList2.add(i);
            }
            if (arrayList2.isEmpty()) continue;
            arrayList.add(new Pair<ObjectQuantity, int[]>(objectQuantity, theUtil.toIntArray(arrayList2)));
            arrayList2.clear();
        }
        return arrayList;
    }
}

