/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.util.Util;

public class ObjectQuantity<T extends IPyroObject>
extends StaticQuantity {
    static final long serialVersionUID = 1L;
    public final T[] objects;

    protected ObjectQuantity(Quantity quantity, T ... TArray) {
        super(quantity);
        this.objects = TArray;
    }

    @Override
    public int hashCode() {
        int n = 7811919 + super.hashCode();
        for (T t : this.objects) {
            n += System.identityHashCode(t);
        }
        return n;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object object) {
        assert (!(object instanceof Quantity)) : "ObjectQuantity should not be directly compared to Quantity.";
        return object == this || object instanceof ObjectQuantity && super.equals(object) && Arrays.equals(((ObjectQuantity)object).objects, this.objects);
    }

    @Override
    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : this.objects) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Util.getName(t));
        }
        return String.format("[%1$s: %2$s] %3$s", this.quantity.category, stringBuffer.toString(), super.getDescription());
    }

    @Override
    public String toString() {
        return this.getDescription();
    }
}

