/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.particle;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.variant.Variant;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Particle
extends NamedPyroObject
implements ISignalSink,
ICustomFDSPropsContainer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private Type d_type;
    private String d_fyi;
    private Output d_output;
    private IColoring d_coloring;
    private CustomFDSProps d_customFDSProps;
    private OneLogicInPin d_inPin;
    private Surface d_surf;
    private ExSpec d_species;
    private boolean d_isStatic;
    private Distribution d_distribution;
    private Variant d_medDiam;
    private UnitDouble d_minDiam;
    private UnitDouble d_maxDiam;
    private Double d_sigmaD;
    private double d_gammaD;
    private Drag d_dragType;
    private double d_dragCoef;
    private double d_denseVolumeFrac;

    public Particle(String string, Type type, Output output, IColoring iColoring) {
        super(string);
        this.d_type = type;
        this.d_distribution = Distribution.CONST;
        this.d_output = output;
        this.d_coloring = iColoring;
        this.d_customFDSProps = CustomFDSProps.EMPTY;
        this.d_inPin = new OneLogicInPin(this);
        this.d_surf = null;
        this.d_species = null;
        this.d_isStatic = false;
        if (type == Type.LIQUID) {
            this.setDiameter(new UnitDouble(500.0, SI.MICRO(SI.METER)));
        } else {
            this.d_medDiam = Variant.DEFAULT;
        }
        this.d_minDiam = new UnitDouble(20.0, SI.MICRO(SI.METER));
        this.d_maxDiam = new UnitDouble(Double.POSITIVE_INFINITY, SI.MICRO(SI.METER));
        this.d_gammaD = 2.4;
        this.d_sigmaD = null;
        this.d_dragType = Drag.SPHERE;
        this.d_dragCoef = 0.0;
        this.d_denseVolumeFrac = 1.0E-5;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 66) {
            this.d_dragType = Drag.SPHERE;
            this.d_dragCoef = 0.0;
        }
    }

    public void setType(Type type) {
        this.d_type = type;
    }

    public Type getType() {
        return this.d_type;
    }

    public boolean isType(Type type) {
        return this.d_type == type;
    }

    public Distribution getDistribution() {
        return this.d_distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.d_distribution = distribution;
    }

    public boolean isDistributionType(Distribution distribution) {
        return this.d_distribution == distribution;
    }

    public Variant getDiameter() {
        return this.d_medDiam;
    }

    public void setDiameter(UnitDouble unitDouble) {
        this.d_medDiam = unitDouble != null ? Variant.constant(unitDouble) : Variant.DEFAULT;
    }

    public UnitDouble getMinDiameter() {
        return this.d_minDiam;
    }

    public void setMinDiameter(UnitDouble unitDouble) {
        this.d_minDiam = unitDouble;
    }

    public UnitDouble getMaxDiameter() {
        return this.d_maxDiam;
    }

    public void setMaxDiameter(UnitDouble unitDouble) {
        this.d_maxDiam = unitDouble;
    }

    public Double getSigmaD() {
        return this.d_sigmaD;
    }

    public void setSigmaD(double d) {
        this.d_sigmaD = d;
    }

    public double getGammaD() {
        return this.d_gammaD;
    }

    public void setGammaD(double d) {
        this.d_gammaD = d;
    }

    public void setConstDistribution(UnitDouble unitDouble) {
        this.setDiameter(unitDouble);
        this.setDistribution(Distribution.CONST);
    }

    public void setRosinRammler(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, double d) {
        this.setDiameter(unitDouble);
        this.setMinDiameter(unitDouble2);
        this.setMaxDiameter(unitDouble3);
        this.setGammaD(d);
        this.setDistribution(Distribution.ROSIN);
    }

    public void setLognormal(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, double d) {
        this.setDiameter(unitDouble);
        this.setMinDiameter(unitDouble2);
        this.setMaxDiameter(unitDouble3);
        this.setSigmaD(d);
        this.setDistribution(Distribution.LOGNORMAL);
    }

    public void setRosinRammlerLognormal(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, double d) {
        this.setDiameter(unitDouble);
        this.setMinDiameter(unitDouble2);
        this.setMaxDiameter(unitDouble3);
        this.setGammaD(d);
        this.setDistribution(Distribution.ROSINLOGNORMAL);
    }

    public Drag getDragType() {
        return this.d_dragType;
    }

    public void setDrag(Drag drag) {
        this.d_dragType = drag;
    }

    public double getDragCoef() {
        return this.d_dragCoef;
    }

    public void setDragCoef(double d) {
        this.d_dragCoef = d;
    }

    public double getDenseVolumeFraction() {
        return this.d_denseVolumeFrac;
    }

    public void setDenseVolumeFraction(double d) {
        this.d_denseVolumeFrac = d;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("PART");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        Particle particle = (Particle)super.clone();
        particle.d_inPin = (OneLogicInPin)this.d_inPin.clone(particle);
        return particle;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof Particle && super.equals(object) && ((Particle)object).d_inPin.equals(this.d_inPin) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        return object == this || object instanceof Particle && ((Particle)object).d_isStatic == this.d_isStatic && ((Particle)object).d_output.equals(this.d_output) && theUtil.equal(((Particle)object).d_coloring, this.d_coloring) && ((Particle)object).d_customFDSProps.equals(this.d_customFDSProps);
    }

    public int propHash() {
        return this.d_output.hashCode() + theUtil.hashCode(this.d_isStatic) + (this.d_coloring != null ? this.d_coloring.hashCode() : 0) + this.d_customFDSProps.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    private void fireEventIfChanged(Object object, Object object2) {
        if (!theUtil.equal(object, object2)) {
            this.changedEvt(new Object[0]);
        }
    }

    public Output getOutput() {
        return this.d_output;
    }

    public void setOutput(Output output) {
        Output output2 = this.d_output;
        this.d_output = output;
        this.fireEventIfChanged(output2, this.d_output);
    }

    public IColoring getColoring() {
        return this.d_coloring;
    }

    public void setColoring(IColoring iColoring) {
        IColoring iColoring2 = this.d_coloring;
        this.d_coloring = iColoring;
        this.fireEventIfChanged(iColoring2, this.d_coloring);
    }

    public Color getDefaultColor() {
        switch (this.d_type) {
            case SOLID: {
                return Color.ORANGE;
            }
            case TRACER: {
                return Color.BLACK;
            }
            case LIQUID: {
                return Color.BLUE;
            }
        }
        throw new RuntimeException("Invalid particle type.");
    }

    public void setDefaultColor() {
        this.setColoring(new ConstColoring(this.getDefaultColor()));
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surface) {
        Surface surface2 = this.d_surf;
        this.d_surf = surface;
        this.fireEventIfChanged(surface2, this.d_surf);
    }

    public ExSpec getSpecies() {
        return this.d_species;
    }

    public void setSpecies(ExSpec exSpec) {
        ExSpec exSpec2 = this.d_species;
        this.d_species = exSpec;
        this.fireEventIfChanged(exSpec2, this.d_species);
    }

    public boolean isStatic() {
        return this.d_isStatic;
    }

    public void setStatic(boolean bl) {
        this.d_isStatic = bl;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_surf);
        depList.add(DLink.WEAK, (IPyroObject)this.d_species);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(ExSpec exSpec) {
                    Particle.this.setSpecies(exSpec);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    public static enum Drag {
        SPHERE,
        CYLINDER,
        SCREEN,
        COEF;

    }

    public static enum Distribution {
        CONST,
        ROSIN,
        LOGNORMAL,
        ROSINLOGNORMAL;

    }

    public static enum Type {
        TRACER,
        LIQUID,
        SOLID;

    }
}

