/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;

public class VolumeSlice
extends Slice
implements INamed {
    private static final long serialVersionUID = 1L;
    private IGeom d_geom;
    private String d_name;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public VolumeSlice(String string, IGeom iGeom, IQuantity iQuantity, boolean bl, boolean bl2) {
        super(iQuantity, bl, bl2);
        assert (iGeom instanceof AABoxGeom);
        this.d_geom = iGeom;
        this.d_name = string;
    }

    public VolumeSlice(String string, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, UnitDouble unitDouble4, UnitDouble unitDouble5, UnitDouble unitDouble6, IQuantity iQuantity, boolean bl, boolean bl2) {
        super(iQuantity, bl, bl2);
        AABox aABox = new AABox(unitDouble.getValue(Geometry.LU), unitDouble3.getValue(Geometry.LU), unitDouble5.getValue(Geometry.LU), unitDouble2.getValue(Geometry.LU), unitDouble4.getValue(Geometry.LU), unitDouble6.getValue(Geometry.LU));
        this.d_geom = new AABoxGeom(aABox);
        this.d_name = string;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IGeom iGeom = this.getSliceGeom();
        IPrimProps.Face face = new IPrimProps.Face(s_color, null, 2);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(iGeom), (IPrimProps)face);
    }

    @Override
    public IGeom getSliceGeom() {
        if (this.d_geom instanceof AABoxGeom && !(this.d_geom instanceof BlockGeom)) {
            AABoxGeom aABoxGeom = (AABoxGeom)this.d_geom;
            return new BlockGeom(aABoxGeom.min, aABoxGeom.max, 0);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    @Override
    public void setGeom(IGeom iGeom) {
        if (AABoxGeom.class.isAssignableFrom(iGeom.getClass())) {
            this.d_geom = iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public int hashCode() {
        int n = 7;
        n += 31 * n + this.getQuantity().hashCode();
        n += 31 * n + this.d_geom.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        VolumeSlice volumeSlice = (VolumeSlice)object;
        return this.getQuantity().equals(volumeSlice.getQuantity()) && this.getGeom().equals(volumeSlice.getGeom());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    @Override
    public void setName(String string) {
        if (!string.equals(this.d_name) && this.getDomain() != null) {
            ((PyroMod)this.getDomain()).getNames(this).updateRegisteredName(this.d_name, string);
            this.d_name = string;
            this.changedEvt(new Object[0]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_name == null) {
            this.setName(this.getQuantity().getDescription());
        }
    }
}

