/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.Grid;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class StatGeom {

    public static class LinearArrayGeom
    extends LineSeg
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int d_numPoints;

        public LinearArrayGeom(Point3d point3d, Point3d point3d2, int n) {
            super(point3d, point3d2);
            this.d_numPoints = n;
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            Collection<? extends IHandle> collection = super.generateManipHandles();
            return collection.stream().map(iHandle -> new Handle(this, (IHandle)iHandle)).collect(Collectors.toList());
        }

        private static class Handle
        implements IHandle {
            private LinearArrayGeom d_geom;
            private IHandle d_lineSegHandle;

            public Handle(LinearArrayGeom linearArrayGeom, IHandle iHandle) {
                this.d_geom = linearArrayGeom;
                this.d_lineSegHandle = iHandle;
            }

            public boolean equals(Object object) {
                return object == this || object instanceof Handle;
            }

            @Override
            public IGeomNode getGeom() {
                return this.d_lineSegHandle.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.d_lineSegHandle.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d point3d) {
                return this.d_lineSegHandle.getConstraint(point3d);
            }

            @Override
            public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
                this.d_lineSegHandle.begin(point3d, iSnapConstraint);
            }

            @Override
            public Object modify(Point3d point3d) throws ManipException {
                Object object = this.d_lineSegHandle.modify(point3d);
                if (object instanceof LineSeg) {
                    LineSeg lineSeg = (LineSeg)object;
                    this.d_geom = new LinearArrayGeom(lineSeg.p1, lineSeg.p2, this.d_geom.d_numPoints);
                }
                return this.d_geom;
            }

            @Override
            public Object end() {
                Object object = this.d_lineSegHandle.end();
                if (object instanceof LineSeg) {
                    LineSeg lineSeg = (LineSeg)object;
                    this.d_geom = new LinearArrayGeom(lineSeg.p1, lineSeg.p2, this.d_geom.d_numPoints);
                }
                return this.d_geom;
            }
        }
    }

    public static class GridGeom
    implements IGeom,
    Serializable {
        static final long serialVersionUID = 1L;
        public final Grid grid;

        public GridGeom(Grid grid) {
            this.grid = grid;
        }

        public int hashCode() {
            return this.grid.hashCode();
        }

        public boolean equals(Object object) {
            return object == this || object instanceof GridGeom && ((GridGeom)object).grid.equals(this.grid);
        }

        protected AABoxGeom toBox() {
            return new AABoxGeom(this.grid.getGeom().getBoundingBox(new AABox()));
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> collection) {
            collection.add(this.toBox());
            return collection;
        }

        @Override
        public AABox getBoundingBox(AABox aABox) {
            return this.grid.getGeom().getBoundingBox(new AABox());
        }

        @Override
        public int getNumPrims(int n) {
            if ((n & 1) != 0) {
                return 6;
            }
            return 0;
        }

        @Override
        public boolean isShell() {
            return Boolean.FALSE;
        }

        @Override
        public IGeom optimize(IPointOptimizer iPointOptimizer) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.NONE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.NONE;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
            return true;
        }

        @Override
        public IGeom transform(TransformInfo transformInfo, int n) {
            return this;
        }

        @Override
        public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
            this.toBox().pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
        }

        @Override
        public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
            this.toBox().pickBox(object, iIsectFilter, convexHull, iBoxCollector);
        }

        @Override
        public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
            this.toBox().find(iTest, iResult);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> iResult) {
            this.toBox().getAll(iResult);
        }
    }
}

