/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.SetReplacementTask;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SolidMsrStat
extends AMsrStat {
    static final long serialVersionUID = 1L;
    private final Set<Surface> d_surfaces;

    public SolidMsrStat(String string, IQuantity iQuantity) {
        this(string, iQuantity, new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public SolidMsrStat(String string, IQuantity iQuantity, IGeom iGeom, Collection<Surface> collection, Collection<Integer> collection2) {
        super(string, iQuantity, collection2, iGeom);
        this.d_surfaces = new LinkedIdentityHashSet<Surface>(collection);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(this.d_surfaces instanceof LinkedIdentityHashSet)) {
            try {
                theUtil.assignFinalField(this, SolidMsrStat.class, "d_surfaces", new LinkedIdentityHashSet<Surface>((Collection<Surface>)this.d_surfaces));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof SolidMsrStat && super.equals(object) && Util.identitySetsEqual(((SolidMsrStat)object).d_surfaces, this.d_surfaces);
    }

    @Override
    public Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(1, QuantityType.SOLID);
    }

    public Set<Surface> getSurfaces() {
        return Collections.unmodifiableSet(this.d_surfaces);
    }

    public void setSurfaces(Collection<Surface> collection) {
        this.d_surfaces.clear();
        this.d_surfaces.addAll(collection);
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.WEAK, this.d_surfaces);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        super.removeInvalidReplacements(t, set);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Surface) {
            return new SetReplacementTask<Surface>(this, this.d_surfaces, iPyroObject, iPyroObject2);
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }
}

