/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import junit.framework.TestCase;
import org.jscience.physics.units.SI;
import pyrosim.PyroSim;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;

public class SliceTest
extends TestCase {
    private PlanarSlice d_slcfRec;

    public SliceTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_slcfRec = new PlanarSlice(0, new UnitDouble(1.0, SI.METER), Quantity.DENSITY.create(), true, false);
    }

    public void testGetAttributes() {
        int n = this.d_slcfRec.getPlane();
        SliceTest.assertSame((Object)0, (Object)n);
        double d = this.d_slcfRec.getLocation().getValue(SI.METER);
        SliceTest.assertEquals((double)1.0, (double)d, (double)0.0);
        IQuantity iQuantity = this.d_slcfRec.getQuantity();
        SliceTest.assertEquals((Object)((Object)Quantity.DENSITY), (Object)((Object)iQuantity.get()));
        boolean bl = this.d_slcfRec.includeFlowVector();
        SliceTest.assertSame((Object)true, (Object)bl);
        boolean bl2 = this.d_slcfRec.isCellCentered();
        SliceTest.assertSame((Object)false, (Object)bl2);
    }

    public void testEquals() {
        PlanarSlice planarSlice = new PlanarSlice(1, new UnitDouble(1.0, SI.METER), Quantity.DENSITY.create(), true, false);
        SliceTest.assertFalse((boolean)planarSlice.equals(this.d_slcfRec));
        planarSlice = new PlanarSlice(0, new UnitDouble(2.0, SI.METER), Quantity.DENSITY.create(), true, false);
        SliceTest.assertFalse((boolean)planarSlice.equals(this.d_slcfRec));
        planarSlice = new PlanarSlice(0, new UnitDouble(1.0, SI.METER), Quantity.TEMPERATURE.create(), true, false);
        SliceTest.assertFalse((boolean)planarSlice.equals(this.d_slcfRec));
        planarSlice = new PlanarSlice(0, new UnitDouble(1.0, SI.METER), Quantity.DENSITY.create(), false, false);
        SliceTest.assertFalse((boolean)planarSlice.equals(this.d_slcfRec));
        planarSlice = new PlanarSlice(0, new UnitDouble(1.0, SI.METER), Quantity.DENSITY.create(), true, true);
        planarSlice = new PlanarSlice(0, new UnitDouble(1.0, SI.METER), Quantity.DENSITY.create(), true, false);
        SliceTest.assertTrue((boolean)planarSlice.equals(this.d_slcfRec));
    }

    static {
        new PyroSim();
    }
}

